/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.home;

import com.atlassian.stash.internal.home.AtomicFileMover;
import com.atlassian.stash.internal.home.DefaultHomeSubdirectoryResolver;
import com.atlassian.stash.internal.home.FileMover;
import com.atlassian.stash.internal.home.HomeDirectoryDetails;
import com.atlassian.stash.internal.home.HomeDirectoryMigrationException;
import com.atlassian.stash.internal.home.HomeFileMover;
import com.atlassian.stash.internal.home.HomeSubdirectoryResolver;
import com.atlassian.stash.internal.spring.env.PropertySourceUtils;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.nio.file.FileStore;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.SystemUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.EnvironmentAware;
import org.springframework.core.env.Environment;
import org.springframework.core.env.PropertySource;

public class HomeDirectoryMigration
implements EnvironmentAware {
    private static final List<String> FILES_AND_DIRECTORIES_TO_MOVE = ImmutableList.of((Object)"config", (Object)"data", (Object)"plugins/installed-plugins", (Object)"stash-config.properties");
    private static final List<String> FILES_AND_DIRECTORIES_TO_VALIDATE = new ImmutableList.Builder().addAll(FILES_AND_DIRECTORIES_TO_MOVE).add((Object)"data/repositories").build();
    private static final Logger log = LoggerFactory.getLogger(HomeDirectoryMigration.class);
    private final FileMover fileMover;
    private final Path homeDir;
    private final HomeSubdirectoryResolver subdirectoryResolver;
    private final Path sharedHomeDir;
    private Environment environment;

    public HomeDirectoryMigration(HomeDirectoryDetails homeDirectoryDetails) {
        this(homeDirectoryDetails, new HomeFileMover(new AtomicFileMover()), (HomeSubdirectoryResolver)new DefaultHomeSubdirectoryResolver());
    }

    public HomeDirectoryMigration(HomeDirectoryDetails details, FileMover fileMover, HomeSubdirectoryResolver subdirectoryResolver) {
        this.fileMover = fileMover;
        this.subdirectoryResolver = subdirectoryResolver;
        this.homeDir = details.getHome();
        this.sharedHomeDir = details.getSharedHome();
    }

    public void perform() {
        this.validate(this.homeDir, this.sharedHomeDir);
        for (String fileToMove : FILES_AND_DIRECTORIES_TO_MOVE) {
            if (!this.performMove(this.homeDir, this.sharedHomeDir, fileToMove) || !"stash-config.properties".equals(fileToMove)) continue;
            this.updateEnvironment();
        }
    }

    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }

    private static void checkHomeDirectory(Path directory, String type) {
        if (!Files.exists(directory, new LinkOption[0])) {
            throw new HomeDirectoryMigrationException(type + " directory [" + String.valueOf(directory) + "] does not exist.");
        }
        if (!Files.isDirectory(directory, new LinkOption[0])) {
            throw new HomeDirectoryMigrationException(type + " directory [" + String.valueOf(directory) + "] is not a directory.");
        }
        if (SystemUtils.IS_OS_WINDOWS && directory.toString().length() > 200) {
            log.warn("The {} directory is close to the Windows max path length ({}). This is likely to cause errors when merging pull requests. See {} for more details.", new Object[]{type, directory.toString().length(), "https://confluence.atlassian.com/x/04oMEg"});
        }
    }

    private static FileStore getFileStore(Path file) {
        try {
            return Files.getFileStore(file);
        }
        catch (IOException | SecurityException e) {
            return null;
        }
    }

    private boolean performMove(Path sourceParentDir, Path targetParentDir, String name) {
        Path sourceFile = sourceParentDir.resolve(name);
        Path targetFile = targetParentDir.resolve(name);
        try {
            return this.fileMover.move(sourceFile, targetFile);
        }
        catch (IOException exc) {
            throw new HomeDirectoryMigrationException("Could not move '" + String.valueOf(sourceFile.getFileName()) + "' to '" + String.valueOf(targetFile.getFileName()) + "'.", (Throwable)exc);
        }
    }

    private void raiseValidationErrorsIfAny(List<String> validationErrors) {
        if (validationErrors.size() > 0) {
            throw new HomeDirectoryMigrationException(validationErrors);
        }
    }

    private void updateEnvironment() {
        PropertySourceUtils.withPropertySource((Environment)this.environment, (Path)this.homeDir.resolve("stash-config.properties"), (propertySources, propertySource) -> {
            PropertySource renamed = PropertySourceUtils.renamePropertySource((PropertySource)propertySource, (Path)this.sharedHomeDir.resolve("stash-config.properties"));
            propertySources.replace(propertySource.getName(), renamed);
        });
    }

    private void validate(Path homeDir, Path sharedHomeDir) {
        HomeDirectoryMigration.checkHomeDirectory(homeDir, "Home");
        HomeDirectoryMigration.checkHomeDirectory(sharedHomeDir, "Shared Home");
        this.subdirectoryResolver.getOverride("config");
        this.subdirectoryResolver.getOverride("data");
        this.subdirectoryResolver.getOverride("plugins");
        ArrayList<String> validationErrors = new ArrayList<String>();
        for (String fileToValidate : FILES_AND_DIRECTORIES_TO_VALIDATE) {
            this.validateMove(homeDir, sharedHomeDir, fileToValidate, validationErrors);
        }
        this.raiseValidationErrorsIfAny(validationErrors);
    }

    private void validateMove(Path sourceParentDir, Path targetParentDir, String name, List<String> validationErrors) {
        Path source = sourceParentDir.resolve(name);
        Path target = targetParentDir.resolve(name);
        if (Files.exists(source, new LinkOption[0]) && Files.exists(target, new LinkOption[0])) {
            validationErrors.add("Both old '" + String.valueOf(source.toAbsolutePath()) + "' and new '" + String.valueOf(target.toAbsolutePath()) + "' exist.");
        }
        FileStore sourceFileStore = HomeDirectoryMigration.getFileStore(source);
        FileStore targetParentFileStore = HomeDirectoryMigration.getFileStore(targetParentDir);
        if (sourceFileStore != null && !sourceFileStore.equals(targetParentFileStore)) {
            validationErrors.add("Can't move '" + String.valueOf(source.toAbsolutePath()) + "' to '" + String.valueOf(target.toAbsolutePath()) + "' automatically, as it is on a different volume or mount point.\nVolume for '" + String.valueOf(source.toAbsolutePath()) + "': " + String.valueOf(sourceFileStore) + "\nVolume for '" + String.valueOf(targetParentDir.toAbsolutePath()) + "': " + String.valueOf(targetParentFileStore));
        }
        try {
            Path sourceSymbolicLink = Files.readSymbolicLink(source);
            if (!sourceSymbolicLink.isAbsolute()) {
                validationErrors.add("Can't move '" + String.valueOf(source.toAbsolutePath()) + "' to '" + String.valueOf(target.toAbsolutePath()) + "' automatically, as it is a relative symbolic link to '" + sourceSymbolicLink.toString() + "'.");
            }
        }
        catch (IOException | SecurityException | UnsupportedOperationException exception) {
            // empty catch block
        }
    }
}

