/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.home;

import com.atlassian.stash.internal.home.FileMover;
import com.atlassian.stash.internal.home.HomeDirectoryMigrationException;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HomeFileMover
implements FileMover {
    private static final Logger log = LoggerFactory.getLogger(HomeFileMover.class);
    private final FileMover fileMover;

    public HomeFileMover(FileMover fileMover) {
        this.fileMover = fileMover;
    }

    @Override
    public boolean move(Path source, Path target) throws IOException {
        if (!Files.exists(source, new LinkOption[0])) {
            return false;
        }
        if (Files.exists(target, new LinkOption[0])) {
            throw new HomeDirectoryMigrationException("The '" + String.valueOf(target.getFileName()) + "' directory exists on both " + String.valueOf(source.toAbsolutePath()) + " and " + String.valueOf(target.toAbsolutePath()) + ".");
        }
        try {
            Files.createDirectories(target.getParent(), new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new HomeDirectoryMigrationException("'" + String.valueOf(target.getParent()) + "'  could not be created.", (Throwable)e);
        }
        log.info("Moving {} to {}", (Object)source.toAbsolutePath(), (Object)target.toAbsolutePath());
        boolean moved = this.fileMover.move(source, target);
        if (moved) {
            log.debug("Moved {} to {}", (Object)source.toAbsolutePath(), (Object)target.toAbsolutePath());
        }
        return moved;
    }
}

