/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.home;

import com.atlassian.bitbucket.Product;
import com.atlassian.bitbucket.ServiceException;
import com.atlassian.bitbucket.concurrent.LockService;
import com.atlassian.bitbucket.help.HelpPathService;
import com.atlassian.bitbucket.home.HomeUpdate;
import com.atlassian.bitbucket.home.HomeUpdateHandler;
import com.atlassian.bitbucket.home.HomeUpdateHandlerModuleDescriptor;
import com.atlassian.bitbucket.home.SimpleHomeUpdate;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.server.StorageService;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.johnson.event.AddEvent;
import com.atlassian.johnson.event.Event;
import com.atlassian.johnson.event.EventLevel;
import com.atlassian.johnson.event.EventType;
import com.atlassian.johnson.event.RemoveEvent;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.event.events.PluginFrameworkStartedEvent;
import com.atlassian.stash.internal.server.InternalApplicationPropertiesService;
import jakarta.annotation.Nonnull;
import java.util.ArrayList;
import java.util.Collections;
import java.util.concurrent.locks.Lock;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.DependsOn;
import org.springframework.stereotype.Component;

@Component
@DependsOn(value={"homeLockAcquirer"})
public class HomeTracker {
    private static final Logger log = LoggerFactory.getLogger(HomeTracker.class);
    private final EventPublisher eventPublisher;
    private final HelpPathService helpPathService;
    private final I18nService i18nService;
    private final LockService lockService;
    private final InternalApplicationPropertiesService propertiesService;
    private final StorageService storageService;

    @Autowired
    public HomeTracker(EventPublisher eventPublisher, HelpPathService helpPathService, I18nService i18nService, LockService lockService, InternalApplicationPropertiesService propertiesService, StorageService storageService) {
        this.eventPublisher = eventPublisher;
        this.helpPathService = helpPathService;
        this.i18nService = i18nService;
        this.lockService = lockService;
        this.propertiesService = propertiesService;
        this.storageService = storageService;
    }

    @EventListener
    public void onPluginFrameworkStarted(PluginFrameworkStartedEvent event) {
        Lock lock = this.lockService.getLock(HomeTracker.class.getName() + ".sharedHome");
        lock.lock();
        try {
            this.checkLastHomeDir(event);
        }
        finally {
            lock.unlock();
        }
    }

    private void checkLastHomeDir(PluginFrameworkStartedEvent event) {
        String sharedHomeDir = this.storageService.getSharedHomeDir().toString();
        String lastSharedHomeDir = this.propertiesService.getLastSharedHomeDir();
        if (lastSharedHomeDir == null) {
            log.info("Capturing benchmark shared home directory: {}", (Object)sharedHomeDir);
            this.propertiesService.setLastSharedHomeDir(sharedHomeDir);
        } else if (!lastSharedHomeDir.equals(sharedHomeDir)) {
            log.warn("The shared home directory has been moved from {} to {}", (Object)lastSharedHomeDir, (Object)sharedHomeDir);
            if (this.invokeHandlers(event.getPluginAccessor(), sharedHomeDir, lastSharedHomeDir)) {
                log.info("Updating benchmark shared home directory: {}", (Object)sharedHomeDir);
                this.propertiesService.setLastSharedHomeDir(sharedHomeDir);
            } else {
                log.warn("Not updating benchmark shared home directory. An update handler failed. Subsequent restarts will attempt to run the handlers again, unless the home directory is moved back to {}", (Object)lastSharedHomeDir);
            }
        }
    }

    private boolean invokeHandlers(PluginAccessor pluginAccessor, String newHomeDir, String oldHomeDir) {
        ArrayList descriptors = new ArrayList(pluginAccessor.getEnabledModuleDescriptorsByClass(HomeUpdateHandlerModuleDescriptor.class));
        if (CollectionUtils.isEmpty(descriptors)) {
            return true;
        }
        Collections.sort(descriptors);
        String helpTitle = this.helpPathService.getPageTitle("bitbucket.help.home.directory");
        String helpUrl = this.helpPathService.getPageUrl("bitbucket.help.home.directory");
        String message = this.i18nService.getMessage("bitbucket.shared.home.updated", new Object[]{Product.NAME, helpTitle, helpUrl});
        Event lock = new Event(EventType.get((String)"home-updated"), message, EventLevel.get((String)"warning"));
        this.eventPublisher.publish((Object)new AddEvent((Object)this, lock));
        SimpleHomeUpdate update = new SimpleHomeUpdate.Builder().newDir(newHomeDir).oldDir(oldHomeDir).build();
        log.info("Invoking {} handler(s) after shared home directory update", (Object)descriptors.size());
        ArrayList successful = new ArrayList(descriptors.size());
        try {
            descriptors.stream().map(DelegatingHomeUpdateHandler::new).peek(arg_0 -> HomeTracker.lambda$invokeHandlers$0((HomeUpdate)update, arg_0)).forEach(successful::add);
        }
        catch (RuntimeException e) {
            String reason = e instanceof ServiceException ? e.getLocalizedMessage() : e.getMessage();
            lock.setDesc(this.i18nService.getMessage("bitbucket.shared.home.updatefailed", new Object[]{Product.NAME, reason, helpTitle, helpUrl}));
            lock.setLevel(EventLevel.get((String)"fatal"));
            Collections.reverse(successful);
            for (HomeUpdateHandler revert : successful) {
                revert.rollback((HomeUpdate)update);
            }
            return false;
        }
        log.info("{} handler(s) have applied the home directory update successfully", (Object)descriptors.size());
        this.eventPublisher.publish((Object)new RemoveEvent((Object)this, lock));
        return true;
    }

    private static /* synthetic */ void lambda$invokeHandlers$0(HomeUpdate update, DelegatingHomeUpdateHandler handler) {
        handler.apply(update);
    }

    private static class DelegatingHomeUpdateHandler
    implements HomeUpdateHandler {
        private final HomeUpdateHandlerModuleDescriptor descriptor;
        private final HomeUpdateHandler handler;

        private DelegatingHomeUpdateHandler(HomeUpdateHandlerModuleDescriptor descriptor) {
            this.descriptor = descriptor;
            this.handler = descriptor.getModule();
        }

        public void apply(@Nonnull HomeUpdate update) {
            log.debug("{}: Applying home update", (Object)this.descriptor.getCompleteKey());
            try {
                this.handler.apply(update);
            }
            catch (RuntimeException e) {
                log.error(this.descriptor.getCompleteKey() + ": Failed to apply home update", (Throwable)e);
                throw e;
            }
        }

        public void rollback(@Nonnull HomeUpdate update) {
            log.debug("{}: Rolling back successful home update", (Object)this.descriptor.getCompleteKey());
            try {
                this.handler.rollback(update);
            }
            catch (RuntimeException e) {
                log.error(this.descriptor.getCompleteKey() + ": Failed to rollback the home update after another handler failed. This may have left some home directory contents in an inconsistent state, with a mixture of references to the old and new locations.", (Throwable)e);
            }
        }
    }
}

