/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.home;

import com.atlassian.bitbucket.Product;
import com.atlassian.stash.internal.home.HomeLock;
import com.atlassian.stash.internal.home.HomeLockAcquirer;
import java.nio.file.Path;

public class SharedHomeLockAcquirer
extends HomeLockAcquirer {
    public SharedHomeLockAcquirer(Path homeDir) {
        super(homeDir);
    }

    @Override
    protected String getFailedMessage(HomeLock lock) {
        if (lock.isShared()) {
            return String.format("Unable to create and acquire shared lock file '%3$s' for %1$s shared home directory '%2$s'.\n\nPlease ensure that the user running %1$s has permission to write to this directory and that file locking is enabled for your network file system.\n\nIf this is already the case, please check the logs for more information.", Product.NAME, this.homeDir.toAbsolutePath(), lock);
        }
        return super.getFailedMessage(lock);
    }

    @Override
    protected String getLockDeniedMessage(HomeLock lock) {
        if (lock.isShared()) {
            return String.format("Shared home directory '%2$s' is already locked by a non-clustered instance of %1$s.\n\nPlease stop the other instance of %1$s and restart this instance.\n\nIf you are absolutely certain that no other instance of %1$s is running, please remove the lock file '%3$s' and restart this instance.", Product.NAME, this.homeDir.toAbsolutePath(), lock);
        }
        return super.getLockDeniedMessage(lock);
    }

    @Override
    protected HomeLock createHomeLock(Path homeDir) {
        return new HomeLock(homeDir, true);
    }
}

