/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.hook;

import com.atlassian.bitbucket.hook.ScmHookDetails;
import com.atlassian.bitbucket.hook.repository.RepositoryHookRequest;
import com.atlassian.bitbucket.hook.repository.RepositoryHookResult;
import com.atlassian.bitbucket.hook.repository.RepositoryHookVeto;
import com.atlassian.bitbucket.hook.repository.RepositoryPushHookRequest;
import com.atlassian.bitbucket.repository.RefChange;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.stash.internal.hook.BuiltinHookHandlerFactory;
import com.atlassian.stash.internal.hook.HookHandler;
import com.atlassian.stash.internal.hook.repository.InternalRepositoryHookService;
import com.atlassian.stash.internal.hook.repository.SimpleScmHookDetails;
import jakarta.annotation.Nonnull;
import java.io.PrintWriter;
import java.util.Collection;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="builtinHookHandlerFactory")
public class DefaultBuiltInHookHandlerFactory
implements BuiltinHookHandlerFactory {
    private final InternalRepositoryHookService repositoryHookService;

    @Autowired
    public DefaultBuiltInHookHandlerFactory(InternalRepositoryHookService repositoryHookService) {
        this.repositoryHookService = repositoryHookService;
    }

    @Nonnull
    public HookHandler preReceive(@Nonnull Repository repository, @Nonnull Collection<RefChange> refChanges) {
        return (request, response) -> {
            RepositoryHookResult result = this.repositoryHookService.preUpdate((RepositoryHookRequest)((RepositoryPushHookRequest.Builder)((RepositoryPushHookRequest.Builder)new RepositoryPushHookRequest.Builder(repository).refChanges((Iterable)refChanges)).scmHookDetails((ScmHookDetails)new SimpleScmHookDetails(request, response))).build());
            PrintWriter err = response.err();
            String separator = "";
            for (RepositoryHookVeto veto : result.getVetoes()) {
                String details = veto.getDetailedMessage();
                String summary = veto.getSummaryMessage();
                Object message = StringUtils.isNotEmpty((CharSequence)details) && !details.equals(summary) ? StringUtils.appendIfMissing((String)summary, (CharSequence)"\n", (CharSequence[])new CharSequence[0]) + details : summary;
                err.append(separator).println((String)message);
                separator = ((String)message).indexOf(10) == -1 || ((String)message).endsWith("\n") ? "" : "\n";
            }
            return result.isAccepted();
        };
    }

    @Nonnull
    public HookHandler postReceive(@Nonnull Repository repository, @Nonnull Collection<RefChange> refChanges) {
        return (request, response) -> {
            this.repositoryHookService.postUpdateSynchronous((RepositoryHookRequest)((RepositoryPushHookRequest.Builder)((RepositoryPushHookRequest.Builder)new RepositoryPushHookRequest.Builder(repository).refChanges((Iterable)refChanges)).scmHookDetails((ScmHookDetails)new SimpleScmHookDetails(request, response))).build());
            return true;
        };
    }
}

