/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.hook;

import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.repository.RepositorySupplier;
import com.atlassian.bitbucket.user.EscalatedSecurityContext;
import com.atlassian.bitbucket.user.SecurityService;
import com.atlassian.bitbucket.util.FileUtils;
import com.atlassian.bitbucket.util.IoUtils;
import com.atlassian.bitbucket.util.Timer;
import com.atlassian.bitbucket.util.TimerUtils;
import com.atlassian.sal.api.executor.ThreadLocalContextManager;
import com.atlassian.security.random.SecureTokenGenerator;
import com.atlassian.stash.internal.hook.HookHandler;
import com.atlassian.stash.internal.hook.HookRequest;
import com.atlassian.stash.internal.hook.HookRequestHandle;
import com.atlassian.stash.internal.hook.HookResponse;
import com.atlassian.stash.internal.hook.HookService;
import com.atlassian.stash.internal.hook.SimpleHookResponse;
import com.atlassian.stash.internal.hook.SocketTransferInput;
import com.atlassian.stash.internal.hook.SocketTransferOutput;
import com.atlassian.stash.internal.scm.InternalScmService;
import com.atlassian.stash.internal.server.InternalStorageService;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Strings;
import com.google.common.io.Files;
import jakarta.annotation.Nonnull;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.nio.BufferOverflowException;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.ClassPathResource;

public class DefaultHookService
implements HookService {
    private static final String CALLBACK_SCRIPT = "hook-callback.pl";
    private static final String COORDINATOR_SCRIPT = "hook-coordinator.sh";
    private static final int DEFAULT_BACKLOG = 0;
    private static final Logger log = LoggerFactory.getLogger(DefaultHookService.class);
    private final ExecutorService executor;
    private final File hookScriptDirectory;
    private final RepositorySupplier repositorySupplier;
    private final InternalScmService scmService;
    private final SecureTokenGenerator tokenGenerator;
    private final ConcurrentMap<String, HookState> stateForScmRequest;
    private final ThreadLocalContextManager<Object> stateManager;
    private final long hookBufferCapacity;
    private final String hookAddress;
    private final int hookPort;
    private final EscalatedSecurityContext withRepoRead;
    private ServerSocket serverSocket;
    private String serverSocketHost;
    private int serverSocketPort;
    private volatile boolean shutdown;

    public DefaultHookService(ExecutorService executor, RepositorySupplier repositorySupplier, InternalScmService scmService, SecurityService securityService, ThreadLocalContextManager<Object> stateManager, InternalStorageService storageService, SecureTokenGenerator tokenGenerator, long hookBufferCapacity, String hookAddress, int hookPort) {
        this.executor = executor;
        this.repositorySupplier = repositorySupplier;
        this.scmService = scmService;
        this.stateManager = stateManager;
        this.tokenGenerator = tokenGenerator;
        this.hookBufferCapacity = Math.max(hookBufferCapacity, 32768L);
        this.hookAddress = Strings.emptyToNull((String)hookAddress);
        this.hookPort = Math.max(hookPort, 0);
        this.hookScriptDirectory = storageService.getBinDir().resolve("git-hooks").toFile();
        this.stateForScmRequest = new ConcurrentHashMap<String, HookState>();
        this.withRepoRead = securityService.withPermission(Permission.REPO_READ, "look up repository for hooks");
    }

    public <T> T doWithHookRequest(int repositoryId, @Nonnull Function<HookRequestHandle, T> callback) {
        Objects.requireNonNull(callback, "callback");
        try (HookRequestHandle handle = this.registerRequest(repositoryId);){
            T t = callback.apply(handle);
            return t;
        }
    }

    @Nonnull
    public String getCallbackAddress() {
        return this.serverSocketHost;
    }

    public int getCallbackPort() {
        return this.serverSocketPort;
    }

    @Nonnull
    public HookRequestHandle registerRequest(int repositoryId, @Nonnull HookHandler handler) {
        return this.internalRegisterRequest(repositoryId, Objects.requireNonNull(handler, "handler"));
    }

    @Nonnull
    public HookRequestHandle registerRequest(int repositoryId) {
        return this.internalRegisterRequest(repositoryId, null);
    }

    public void startup() throws IOException {
        this.installHookScripts();
        this.startHookCallbackListener();
    }

    public void shutdown() {
        this.shutdown = true;
        try {
            if (this.serverSocket != null) {
                this.serverSocket.close();
            }
        }
        catch (IOException e) {
            log.warn("Could not close socket for hook callbacks", (Throwable)e);
        }
    }

    private void installHookScript(String scriptName, File targetDir) throws IOException {
        File scriptFile = new File(targetDir, scriptName);
        ClassPathResource script = new ClassPathResource("/hooks/" + scriptName, DefaultHookService.class);
        try (InputStream scriptStream = script.getInputStream();){
            IoUtils.copy((InputStream)scriptStream, (File)scriptFile);
        }
        if (!scriptFile.setExecutable(true)) {
            throw new IOException(scriptFile.getAbsolutePath() + " could not be set executable.");
        }
    }

    private void installHookScripts() throws IOException {
        if (this.hookScriptDirectory.exists() && !this.hookScriptDirectory.isDirectory()) {
            log.warn("{} must be a directory. Attempting to move the file", (Object)this.hookScriptDirectory.getAbsolutePath());
            try {
                File moved = new File(this.hookScriptDirectory.getParent(), this.hookScriptDirectory.getName() + ".moved");
                Files.move((File)this.hookScriptDirectory, (File)moved);
                log.warn("The file at {} has been renamed to {}", (Object)this.hookScriptDirectory.getAbsolutePath(), (Object)moved.getName());
            }
            catch (IOException e) {
                throw new IOException(this.hookScriptDirectory.getAbsolutePath() + " exists and is not a directory, preventing installation of required hook support scripts.", e);
            }
        }
        try {
            FileUtils.mkdir((File)this.hookScriptDirectory);
        }
        catch (IllegalStateException e) {
            throw new IOException(this.hookScriptDirectory.getAbsolutePath() + " could not be created. Hook support scripts cannot be installed.", e);
        }
        try {
            this.installHookScript(CALLBACK_SCRIPT, this.hookScriptDirectory);
            this.installHookScript(COORDINATOR_SCRIPT, this.hookScriptDirectory);
        }
        catch (IOException e) {
            throw new IOException("Hook support scripts could not be written to " + this.hookScriptDirectory.getAbsolutePath(), e);
        }
    }

    @Nonnull
    private HookRequestHandle internalRegisterRequest(int repositoryId, HookHandler hookHandler) {
        String scmRequestId = this.tokenGenerator.generateToken();
        DefaultRequestHandle handle = new DefaultRequestHandle(scmRequestId);
        this.stateForScmRequest.put(scmRequestId, new HookState(handle, hookHandler, repositoryId, this.stateManager.getThreadLocalContext()));
        return handle;
    }

    private void startHookCallbackListener() throws IOException {
        this.serverSocket = new ServerSocket(this.hookPort, 0, InetAddress.getByName(this.hookAddress));
        this.serverSocketHost = this.serverSocket.getInetAddress().getHostAddress();
        this.serverSocketPort = this.serverSocket.getLocalPort();
        Thread socketListenerThread = new Thread("hook-callback-listener"){

            @Override
            public void run() {
                while (!DefaultHookService.this.shutdown) {
                    Socket socket;
                    try {
                        socket = DefaultHookService.this.serverSocket.accept();
                    }
                    catch (Exception e) {
                        if (DefaultHookService.this.shutdown) continue;
                        log.warn("A hook connection could not be established; accept failed", (Throwable)e);
                        continue;
                    }
                    DefaultHookService.this.executor.execute(() -> {
                        block18: {
                            try (Socket ignored = socket;
                                 SocketTransferInput input = new SocketTransferInput(socket.getInputStream());
                                 SocketTransferOutput output = new SocketTransferOutput(socket.getOutputStream());){
                                DefaultHookService.this.handleRawRequest(input, output);
                            }
                            catch (Exception e) {
                                if (DefaultHookService.this.shutdown) break block18;
                                log.warn("Hook socket I/O failed before the repository/hook could be identified", (Throwable)e);
                            }
                        }
                    });
                }
            }
        };
        socketListenerThread.setDaemon(true);
        socketListenerThread.start();
        log.info("Hook callback socket listening on {}:{}", (Object)this.serverSocketHost, (Object)this.serverSocketPort);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    void handleRawRequest(SocketTransferInput input, SocketTransferOutput output) throws IOException {
        HookState hookState = null;
        HookRequest request = null;
        try (Timer timer = null;){
            boolean acceptRequest = false;
            SimpleHookResponse response = new SimpleHookResponse();
            try {
                request = input.readRequest(this.hookBufferCapacity);
                hookState = this.getHookState(request);
                timer = TimerUtils.start((String)("DefaultHookService hook callback " + request.getHookName() + " for repository " + hookState.getRepositoryId()));
                acceptRequest = this.handleRequest(request, response, hookState);
            }
            catch (BufferOverflowException e) {
                response.err().println("This push is too large to process.");
            }
            finally {
                DefaultRequestHandle handle;
                if (hookState != null && (handle = hookState.getHandle()) != null) {
                    handle.setAccepted(acceptRequest);
                    handle.setCalled(true);
                }
            }
            this.writeResponse(output, response, acceptRequest);
        }
    }

    @VisibleForTesting
    HookState getHookState(HookRequest hookRequest) {
        String hookRequestId = hookRequest.getId();
        if (hookRequestId != null) {
            log.trace("Received hook callback with request id {}", (Object)hookRequestId);
            HookState hookState = (HookState)this.stateForScmRequest.get(hookRequestId);
            if (hookState == null) {
                throw new NoSuchElementException(hookRequestId);
            }
            return hookState;
        }
        int repositoryId = hookRequest.getRepositoryId();
        return new HookState(null, null, repositoryId, null);
    }

    @VisibleForTesting
    void writeResponse(SocketTransferOutput output, SimpleHookResponse response, boolean acceptRequest) throws IOException {
        String err;
        String out = response.getOutput();
        if (out.length() > 0) {
            output.writeStdOut(out);
        }
        if ((err = response.getError()).length() > 0) {
            output.writeStdErr(err);
        }
        output.writeExitCode(acceptRequest ? 0 : 1);
        output.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    boolean handleRequest(HookRequest request, HookResponse response, HookState hookState) {
        this.stateManager.setThreadLocalContext(hookState.getThreadLocalState());
        try {
            boolean bl = this.doHandleRequest(request, response, hookState);
            return bl;
        }
        finally {
            this.stateManager.clearThreadLocalContext();
        }
    }

    @VisibleForTesting
    boolean doHandleRequest(HookRequest request, HookResponse response, HookState hookState) {
        HookHandler customHandler = hookState.getHandler();
        if (customHandler != null && customHandler.supports(request)) {
            return customHandler.handle(request, response);
        }
        Repository repository = (Repository)this.withRepoRead.call(() -> this.repositorySupplier.getById(hookState.getRepositoryId()));
        if (repository == null) {
            log.warn("Failed to find repository with id {} for hook callback", (Object)hookState.getRepositoryId());
            return false;
        }
        HookHandler handler = this.scmService.getHookHandlerFactory(repository).create(request);
        return handler == null || handler.handle(request, response);
    }

    private class DefaultRequestHandle
    implements HookRequestHandle {
        private final String requestId;
        private volatile boolean accepted;
        private volatile boolean called;

        private DefaultRequestHandle(String requestId) {
            this.requestId = requestId;
        }

        public void close() {
            DefaultHookService.this.stateForScmRequest.remove(this.requestId);
        }

        @Nonnull
        public File getCallbackScript() {
            return new File(DefaultHookService.this.hookScriptDirectory, DefaultHookService.CALLBACK_SCRIPT);
        }

        @Nonnull
        public File getCoordinatorScript() {
            return new File(DefaultHookService.this.hookScriptDirectory, DefaultHookService.COORDINATOR_SCRIPT);
        }

        @Nonnull
        public String getHostAddress() {
            return DefaultHookService.this.serverSocketHost;
        }

        public int getPort() {
            return DefaultHookService.this.serverSocketPort;
        }

        @Nonnull
        public String getRequestId() {
            return this.requestId;
        }

        public boolean isAccepted() {
            return this.accepted;
        }

        public boolean isCalled() {
            return this.called;
        }

        public void setAccepted(boolean accepted) {
            this.accepted = accepted;
        }

        public void setCalled(boolean called) {
            this.called = called;
        }
    }

    @VisibleForTesting
    static class HookState {
        private final DefaultRequestHandle handle;
        private final HookHandler handler;
        private final int repositoryId;
        private final Object threadLocalState;

        private HookState(DefaultRequestHandle handle, HookHandler handler, int repositoryId, Object threadLocalState) {
            this.handle = handle;
            this.handler = handler;
            this.repositoryId = repositoryId;
            this.threadLocalState = threadLocalState;
        }

        DefaultRequestHandle getHandle() {
            return this.handle;
        }

        HookHandler getHandler() {
            return this.handler;
        }

        int getRepositoryId() {
            return this.repositoryId;
        }

        Object getThreadLocalState() {
            return this.threadLocalState;
        }
    }
}

