/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.hook;

import com.atlassian.bitbucket.util.BuilderSupport;
import com.atlassian.stash.internal.hook.HookRequest;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class SimpleHookRequest
implements HookRequest {
    private final List<String> arguments;
    private final String directory;
    private final Map<String, String> environment;
    private final String hookName;
    private final String id;
    private final String input;
    private final int repositoryId;
    private final String requestId;

    private SimpleHookRequest(Builder builder) {
        this.arguments = builder.arguments.build();
        this.directory = builder.directory;
        this.environment = builder.environment.build();
        this.input = builder.input.toString();
        this.hookName = builder.hookName;
        this.id = builder.id;
        this.repositoryId = builder.repositoryId;
        this.requestId = builder.requestId;
    }

    @Nonnull
    public List<String> getArguments() {
        return this.arguments;
    }

    public String getDirectory() {
        return this.directory;
    }

    @Nonnull
    public Map<String, String> getEnvironment() {
        return this.environment;
    }

    public String getHookName() {
        return this.hookName;
    }

    public String getId() {
        return this.id;
    }

    public String getRequestId() {
        return this.requestId;
    }

    @Nonnull
    public CharSequence getInput() {
        return this.input;
    }

    public int getRepositoryId() {
        return this.repositoryId;
    }

    public static class Builder
    extends BuilderSupport {
        private final ImmutableList.Builder<String> arguments = ImmutableList.builder();
        private final ImmutableMap.Builder<String, String> environment = ImmutableMap.builder();
        private final StringBuilder input = new StringBuilder();
        private String directory;
        private String hookName;
        private String id;
        private int repositoryId = -1;
        private String requestId;

        @Nonnull
        public Builder argument(@Nonnull String value) {
            this.arguments.add((Object)Builder.requireNonBlank((String)value, (String)"value"));
            return this;
        }

        @Nonnull
        public SimpleHookRequest build() {
            Builder.requireNonBlank((String)this.hookName, (String)"hookName");
            return new SimpleHookRequest(this);
        }

        @Nonnull
        public Builder directory(@Nullable String value) {
            this.directory = value;
            return this;
        }

        @Nonnull
        public Builder environment(@Nonnull String key, @Nonnull String value) {
            this.environment.put((Object)Builder.requireNonBlank((String)key, (String)"key"), (Object)Objects.requireNonNull(value, "value"));
            return this;
        }

        @Nonnull
        public Builder hookName(@Nonnull String value) {
            this.hookName = Builder.requireNonBlank((String)value, (String)"hookName");
            return this;
        }

        @Nonnull
        public Builder id(@Nullable String value) {
            this.id = value;
            return this;
        }

        @Nonnull
        public Builder input(@Nonnull String value) {
            this.input.append(value);
            return this;
        }

        @Nonnull
        public Builder repositoryId(int value) {
            this.repositoryId = value;
            return this;
        }

        @Nonnull
        public Builder requestId(@Nullable String value) {
            this.requestId = value;
            return this;
        }
    }
}

