/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.hook;

import com.atlassian.stash.internal.hook.HookRequest;
import com.atlassian.stash.internal.hook.SimpleHookRequest;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import jakarta.annotation.Nonnull;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.BufferOverflowException;
import java.nio.charset.StandardCharsets;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;

public class SocketTransferInput
implements Closeable {
    private final DataInputStream in;
    private long bytesRead;

    public SocketTransferInput(InputStream in) {
        this.in = new DataInputStream(in);
    }

    @Override
    public void close() throws IOException {
        this.in.close();
    }

    public HookRequest readRequest(long maxBytes) throws IOException {
        ChunkType type;
        SimpleHookRequest.Builder builder = new SimpleHookRequest.Builder();
        byte[] buffer = new byte[65535];
        while ((type = this.readType()) != ChunkType.END) {
            if (type == ChunkType.ARG) {
                builder.argument(this.readString(buffer));
            } else if (type == ChunkType.ENVIRONMENT) {
                String[] keyAndValue = StringUtils.splitPreserveAllTokens((String)this.readString(buffer), (String)"=", (int)2);
                builder.environment(keyAndValue[0], keyAndValue[1]);
            } else if (type == ChunkType.STDIN) {
                builder.input(this.readString(buffer));
            } else if (type == ChunkType.DIRECTORY) {
                builder.directory(this.readString());
            } else if (type == ChunkType.HOOK_TYPE) {
                builder.hookName(this.readString());
            } else if (type == ChunkType.REQUEST_ID) {
                builder.id(this.readString());
            } else if (type == ChunkType.REQUEST_AND_REPOSITORY_ID) {
                builder.requestId(this.readString());
                builder.repositoryId(Integer.parseInt(this.readString()));
            } else {
                throw new IllegalStateException("Unexpected chunk from hook request: " + type.getCharacter());
            }
            if (this.bytesRead <= maxBytes) continue;
            throw new BufferOverflowException();
        }
        return builder.build();
    }

    @VisibleForTesting
    Pair<ChunkType, String> readChunk() throws IOException {
        return Pair.of((Object)((Object)this.readType()), (Object)this.readString());
    }

    private char readAsciiChar() throws IOException {
        byte b = (byte)this.in.read();
        if (b == -1) {
            throw new EOFException();
        }
        int c = b & 0xFF;
        Preconditions.checkState((c <= 127 ? 1 : 0) != 0, (Object)"Only ASCII characters are supported");
        return (char)c;
    }

    private String readString() throws IOException {
        return this.readString(null);
    }

    private String readString(byte[] buffer) throws IOException {
        int len = this.in.readUnsignedShort();
        if (buffer == null) {
            buffer = new byte[len];
        }
        this.in.readFully(buffer, 0, len);
        this.bytesRead += (long)len;
        return new String(buffer, 0, len, StandardCharsets.UTF_8);
    }

    private ChunkType readType() throws IOException {
        return ChunkType.forChar(this.readAsciiChar());
    }

    static enum ChunkType {
        ARG('A'),
        DIRECTORY('D'),
        END('E'),
        ENVIRONMENT('V'),
        HOOK_TYPE('T'),
        REQUEST_ID('X'),
        REQUEST_AND_REPOSITORY_ID('R'),
        STDIN('I');

        private final char character;

        private ChunkType(char character) {
            this.character = character;
        }

        @Nonnull
        static ChunkType forChar(char c) {
            for (ChunkType type : ChunkType.values()) {
                if (type.getCharacter() != c) continue;
                return type;
            }
            throw new IllegalArgumentException("Unknown channel '" + c + "'");
        }

        char getCharacter() {
            return this.character;
        }
    }
}

