/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.hook;

import com.google.common.base.Preconditions;
import java.io.Closeable;
import java.io.DataOutputStream;
import java.io.Flushable;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.channels.Channels;
import java.nio.channels.WritableByteChannel;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.output.CloseShieldOutputStream;

public class SocketTransferOutput
implements Closeable,
Flushable {
    static final int SOCKET_OUTPUT_MAX = 65535;
    private final DataOutputStream out;

    public SocketTransferOutput(OutputStream out) {
        this.out = new DataOutputStream(out);
    }

    @Override
    public void close() throws IOException {
        this.out.close();
    }

    @Override
    public void flush() throws IOException {
        this.out.flush();
    }

    public void writeStdOut(String chunk) throws IOException {
        this.writeInChunks('O', chunk);
    }

    public void writeStdErr(String chunk) throws IOException {
        this.writeInChunks('E', chunk);
    }

    public void writeExitCode(int exitCode) throws IOException {
        this.writeAsciiChar('X');
        this.out.writeShort(exitCode);
    }

    private void writeAsciiChar(char c) throws IOException {
        Preconditions.checkArgument((c >= '\u0001' && c <= '\u007f' ? 1 : 0) != 0, (Object)"Only ASCII characters are supported");
        this.out.write((byte)c);
    }

    private void writeInChunks(char type, String data) throws IOException {
        CharsetEncoder utf8Encoder = StandardCharsets.UTF_8.newEncoder().onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE);
        CharBuffer chars = CharBuffer.wrap(data);
        ByteBuffer bytes = ByteBuffer.allocate(Math.min(65535, chars.length() * 4));
        try (WritableByteChannel byteChannel = Channels.newChannel((OutputStream)new CloseShieldOutputStream((OutputStream)this.out));){
            CoderResult result;
            do {
                result = utf8Encoder.encode(chars, bytes, true);
                bytes.flip();
                this.writeAsciiChar(type);
                this.out.writeShort(bytes.remaining());
                byteChannel.write(bytes);
                bytes.clear();
            } while (result.isOverflow());
        }
    }
}

