/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.hook;

import com.atlassian.bitbucket.auth.AuthenticationContext;
import com.atlassian.bitbucket.dmz.repository.RefUpdateType;
import com.atlassian.bitbucket.event.repository.RepositoryPushEvent;
import com.atlassian.bitbucket.hook.repository.CommitRemovedDetails;
import com.atlassian.bitbucket.hook.repository.PostRepositoryHook;
import com.atlassian.bitbucket.hook.repository.PostRepositoryHookContext;
import com.atlassian.bitbucket.hook.repository.RepositoryHookCommitCallback;
import com.atlassian.bitbucket.hook.repository.RepositoryHookCommitFilter;
import com.atlassian.bitbucket.hook.repository.RepositoryHookRequest;
import com.atlassian.bitbucket.hook.repository.RepositoryHookTrigger;
import com.atlassian.bitbucket.hook.repository.StandardRepositoryHookTrigger;
import com.atlassian.bitbucket.hook.repository.SynchronousPreferred;
import com.atlassian.bitbucket.repository.MinimalRef;
import com.atlassian.bitbucket.repository.RefChange;
import com.atlassian.bitbucket.repository.RefChangeType;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.repository.StandardRefType;
import com.atlassian.bitbucket.request.RequestManager;
import com.atlassian.bitbucket.scm.git.hook.GitRepositoryHookTrigger;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.bitbucket.util.MoreCollectors;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.stash.internal.InternalConverter;
import com.atlassian.stash.internal.event.AnalyticsRepositoryPushEvent;
import com.atlassian.stash.internal.pull.rescope.PullRequestRescopeScheduler;
import com.atlassian.stash.internal.repository.InternalPushRefChange;
import com.atlassian.stash.internal.repository.InternalRefChange;
import com.atlassian.stash.internal.repository.InternalRepository;
import com.atlassian.stash.internal.repository.InternalRepositoryPushActivity;
import com.atlassian.stash.internal.repository.RepositoryActivityDao;
import com.atlassian.stash.internal.spring.SpringTransactionUtils;
import com.atlassian.stash.internal.user.InternalApplicationUser;
import jakarta.annotation.Nonnull;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.EnvironmentAware;
import org.springframework.core.env.Environment;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionCallbackWithoutResult;
import org.springframework.transaction.support.TransactionTemplate;

@SynchronousPreferred
public class SystemPostRepositoryHook
implements PostRepositoryHook<RepositoryHookRequest>,
EnvironmentAware {
    private static final Logger log = LoggerFactory.getLogger(SystemPostRepositoryHook.class);
    private final RepositoryActivityDao activityDao;
    private final AuthenticationContext authenticationContext;
    private final EventPublisher eventPublisher;
    private final RequestManager requestManager;
    private final Optional<PullRequestRescopeScheduler> rescopeScheduler;
    private final TransactionTemplate transactionTemplate;
    private boolean detectForcedUpdates;

    public SystemPostRepositoryHook(RepositoryActivityDao activityDao, AuthenticationContext authenticationContext, EventPublisher eventPublisher, RequestManager requestManager, Optional<PullRequestRescopeScheduler> rescopeScheduler, PlatformTransactionManager transactionManager) {
        this(activityDao, authenticationContext, eventPublisher, requestManager, rescopeScheduler, new TransactionTemplate(transactionManager, SpringTransactionUtils.REQUIRES_NEW));
    }

    SystemPostRepositoryHook(RepositoryActivityDao activityDao, AuthenticationContext authenticationContext, EventPublisher eventPublisher, RequestManager requestManager, Optional<PullRequestRescopeScheduler> rescopeScheduler, TransactionTemplate transactionTemplate) {
        this.activityDao = activityDao;
        this.authenticationContext = authenticationContext;
        this.eventPublisher = eventPublisher;
        this.requestManager = requestManager;
        this.rescopeScheduler = rescopeScheduler;
        this.transactionTemplate = transactionTemplate;
        this.detectForcedUpdates = true;
    }

    public void postUpdate(@Nonnull PostRepositoryHookContext context, @Nonnull RepositoryHookRequest request) {
        Collection refChanges = request.getRefChanges();
        InternalRepository repository = InternalConverter.convertToInternalRepository((Repository)request.getRepository());
        RepositoryHookTrigger trigger = request.getTrigger();
        if (refChanges.isEmpty()) {
            log.debug("{}: {} hook was invoked with no ref changes", (Object)repository, (Object)trigger.getId());
            return;
        }
        log.trace("{}: {} hook was invoked with ref changes: {}", new Object[]{repository, trigger.getId(), InternalRefChange.formatRefChanges((Iterable)refChanges)});
        RepositoryPushEvent event = request.getScmHookDetails().map(ignored -> new AnalyticsRepositoryPushEvent(this, (Repository)repository, refChanges, this.requestManager.getRequestMetadata())).orElse(null);
        InternalApplicationUser user = InternalConverter.convertToInternalUser((ApplicationUser)this.authenticationContext.getCurrentUser());
        if (user == null) {
            log.warn("{}: {} hook was invoked anonymously for the following ref changes:{}", new Object[]{repository, trigger.getId(), InternalRefChange.formatRefChanges((Iterable)refChanges)});
        } else {
            if (this.detectForcedUpdates) {
                event = this.addActivityOrRegisterCallback(context, event, repository, refChanges, user, trigger);
            } else {
                this.addActivity(repository, refChanges, user, trigger);
            }
            this.rescopeScheduler.ifPresent(scheduler -> scheduler.schedule(repository, user, refChanges));
        }
        if (event != null) {
            this.eventPublisher.publish((Object)event);
        }
    }

    public void setEnvironment(Environment environment) {
        this.detectForcedUpdates = (Boolean)environment.getProperty("audit.push.detectforcedupdates", Boolean.TYPE, (Object)true);
    }

    private void addActivity(InternalRepository repository, Collection<RefChange> refChanges, InternalApplicationUser user, RepositoryHookTrigger trigger) {
        final InternalRepositoryPushActivity activity = ((InternalRepositoryPushActivity.Builder)((InternalRepositoryPushActivity.Builder)new InternalRepositoryPushActivity.Builder(InternalConverter.convertToInternalRepository((Repository)repository)).createdDate(new Date())).refChanges(refChanges).triggerId(trigger.getId()).user(user)).build();
        if (activity.getRefChanges().isEmpty()) {
            log.warn("{}: {} hook was invoked for {} with invalid ref changes:{}", new Object[]{repository, trigger.getId(), user.getName(), InternalRefChange.formatRefChanges(refChanges)});
            return;
        }
        try {
            this.transactionTemplate.execute((TransactionCallback)new TransactionCallbackWithoutResult(){

                protected void doInTransactionWithoutResult(@Nonnull TransactionStatus transactionStatus) {
                    SystemPostRepositoryHook.this.activityDao.create((Object)activity);
                }
            });
        }
        catch (RuntimeException e) {
            log.error("{}: An activity could not be created for {} hook ref changes:{}", new Object[]{repository, trigger.getId(), InternalRefChange.formatRefChanges(refChanges), e});
        }
    }

    private RepositoryPushEvent addActivityOrRegisterCallback(PostRepositoryHookContext context, RepositoryPushEvent event, InternalRepository repository, Collection<RefChange> refChanges, InternalApplicationUser user, RepositoryHookTrigger trigger) {
        if (trigger == StandardRepositoryHookTrigger.REPO_PUSH) {
            HashMap<String, RefChange> nonTagUpdates = new HashMap<String, RefChange>();
            ArrayList<RefChange> tagUpdates = new ArrayList<RefChange>();
            ArrayList<RefChange> nonUpdates = new ArrayList<RefChange>();
            for (RefChange refChange2 : refChanges) {
                if (refChange2.getType() == RefChangeType.UPDATE) {
                    MinimalRef ref = refChange2.getRef();
                    if (ref.getType() == StandardRefType.TAG) {
                        tagUpdates.add(refChange2);
                        continue;
                    }
                    nonTagUpdates.put(ref.getId(), refChange2);
                    continue;
                }
                nonUpdates.add(refChange2);
            }
            if (!nonTagUpdates.isEmpty()) {
                context.registerCommitCallback((RepositoryHookCommitCallback)new RecordForcePushCommitCallback(event, nonTagUpdates, nonUpdates, repository, tagUpdates, user), RepositoryHookCommitFilter.REMOVED_FROM_ANY_REF, new RepositoryHookCommitFilter[0]);
                return null;
            }
        }
        refChanges = (Collection)refChanges.stream().map(refChange -> {
            RefUpdateType refUpdateType = trigger == GitRepositoryHookTrigger.REBASE || refChange.getType() == RefChangeType.UPDATE && refChange.getRef().getType() == StandardRefType.TAG ? RefUpdateType.FORCED : RefUpdateType.NOT_FORCED;
            return new InternalPushRefChange(refChange, refUpdateType);
        }).collect(MoreCollectors.toImmutableList());
        this.addActivity(repository, refChanges, user, trigger);
        return event;
    }

    private class RecordForcePushCommitCallback
    implements RepositoryHookCommitCallback {
        private final RepositoryPushEvent event;
        private final Map<String, RefChange> nonTagUpdates;
        private final List<RefChange> nonUpdates;
        private final List<RefChange> pushRefChanges;
        private final InternalRepository repository;
        private final List<RefChange> tagUpdates;
        private final InternalApplicationUser user;

        private RecordForcePushCommitCallback(RepositoryPushEvent event, Map<String, RefChange> nonTagUpdates, List<RefChange> nonUpdates, InternalRepository repository, List<RefChange> tagUpdates, InternalApplicationUser user) {
            this.event = event;
            this.nonTagUpdates = nonTagUpdates;
            this.nonUpdates = nonUpdates;
            this.repository = repository;
            this.tagUpdates = tagUpdates;
            this.user = user;
            this.pushRefChanges = new ArrayList<RefChange>();
        }

        public boolean onCommitRemoved(@Nonnull CommitRemovedDetails commitDetails) {
            RefChange refChange = this.nonTagUpdates.remove(commitDetails.getRef().getId());
            if (refChange == null) {
                return true;
            }
            this.pushRefChanges.add((RefChange)new InternalPushRefChange(refChange, RefUpdateType.FORCED));
            return !this.nonTagUpdates.isEmpty();
        }

        public void onEnd() {
            this.enrichRefChanges(this.tagUpdates, RefUpdateType.FORCED);
            this.enrichRefChanges(this.nonUpdates, RefUpdateType.NOT_FORCED);
            this.enrichRefChanges(this.nonTagUpdates.values(), RefUpdateType.NOT_FORCED);
            SystemPostRepositoryHook.this.addActivity(this.repository, this.pushRefChanges, this.user, (RepositoryHookTrigger)StandardRepositoryHookTrigger.REPO_PUSH);
            if (this.event != null) {
                SystemPostRepositoryHook.this.eventPublisher.publish((Object)this.event);
            }
        }

        private void enrichRefChanges(Collection<RefChange> refChanges, RefUpdateType refUpdateType) {
            refChanges.stream().map(refChange -> new InternalPushRefChange(refChange, refUpdateType)).forEach(this.pushRefChanges::add);
        }
    }
}

