/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.hook.repository;

import com.atlassian.bitbucket.commit.Commit;
import com.atlassian.bitbucket.commit.CommitCallback;
import com.atlassian.bitbucket.commit.CommitContext;
import com.atlassian.bitbucket.commit.CommitSummary;
import com.atlassian.bitbucket.commit.MinimalCommit;
import com.atlassian.bitbucket.commit.SimpleCommit;
import com.atlassian.bitbucket.hook.repository.MergeHookRequest;
import com.atlassian.bitbucket.hook.repository.RepositoryHookRequest;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.repository.RefChange;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.repository.SimpleRefChange;
import com.atlassian.bitbucket.repository.StandardRefType;
import com.atlassian.bitbucket.scm.Command;
import com.atlassian.bitbucket.scm.CommandFailedException;
import com.atlassian.bitbucket.scm.CommandResult;
import com.atlassian.bitbucket.scm.CommitsCommandParameters;
import com.atlassian.bitbucket.scm.CommonAncestorCommandParameters;
import com.atlassian.bitbucket.scm.FeatureUnsupportedScmException;
import com.atlassian.bitbucket.scm.RefsCommandParameters;
import com.atlassian.bitbucket.scm.ResolveCommitsCommandParameters;
import com.atlassian.bitbucket.scm.UnavailableScmException;
import com.atlassian.bitbucket.scm.UnsupportedScmException;
import com.atlassian.bitbucket.server.StorageService;
import com.atlassian.bitbucket.util.MoreFiles;
import com.atlassian.stash.internal.hook.repository.HookRequestState;
import com.atlassian.stash.internal.hook.repository.HookRequestStateManager;
import com.atlassian.stash.internal.hook.repository.RepositoryHookScmHelper;
import com.atlassian.stash.internal.scm.InternalScmService;
import com.atlassian.util.contentcache.internal.util.Closeables;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableSet;
import jakarta.annotation.Nonnull;
import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.security.MessageDigest;
import java.time.Duration;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.codec.digest.DigestUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component(value="repositoryHookScmHelper")
public class CachingRepositoryHookScmHelper
implements RepositoryHookScmHelper {
    static final RefsCommandParameters REFS_PARAMETERS = new RefsCommandParameters.Builder().build();
    private static final Logger log = LoggerFactory.getLogger(CachingRepositoryHookScmHelper.class);
    private static final byte[] MARKER = "-------".getBytes(StandardCharsets.UTF_8);
    private final Path cacheDir;
    private final Map<String, HookRequestCache> caches;
    private final I18nService i18nService;
    private final int maxCommits;
    private final int maxExtraCommits;
    private final InternalScmService scmService;
    private final HookRequestStateManager stateManager;
    private final Duration timeout;

    @Autowired
    public CachingRepositoryHookScmHelper(I18nService i18nService, InternalScmService scmService, HookRequestStateManager stateManager, StorageService storageService, @Value(value="${repository.hook.cache.commits.max}") int maxCommits, @Value(value="${repository.hook.cache.commits.extra}") int maxExtraCommits, @Value(value="${repository.hook.cache.commits.timeout}") int timeoutSeconds) {
        this.i18nService = i18nService;
        this.maxCommits = maxCommits;
        this.maxExtraCommits = maxExtraCommits;
        this.scmService = scmService;
        this.stateManager = stateManager;
        this.cacheDir = MoreFiles.mkdir((Path)storageService.getCacheDir(), (String)"hooks");
        this.caches = new ConcurrentHashMap<String, HookRequestCache>();
        this.timeout = Duration.ofSeconds(Math.max(30L, (long)timeoutSeconds));
    }

    @Override
    public void commits(@Nonnull RepositoryHookRequest request, @Nonnull CommitsCommandParameters parameters, @Nonnull CommitCallback commitCallback) {
        this.getCache(request).commits(request.getRepository(), parameters, commitCallback, this::internalCommits);
    }

    @Override
    public MinimalCommit commonAncestor(@Nonnull RepositoryHookRequest request, @Nonnull CommonAncestorCommandParameters parameters) {
        return this.getCache(request).commonAncestor(request.getRepository(), parameters, this::internalCommonAncestor);
    }

    @Override
    @Nonnull
    public Set<String> getUnchangedRefCommitIds(@Nonnull RepositoryHookRequest request) {
        Set<String> modifiedRefIds = request.isDryRun() && request instanceof MergeHookRequest ? Collections.singleton(((MergeHookRequest)request).getToRef().getId()) : request.getRefChanges().stream().map(change -> change.getRef().getId()).collect(Collectors.toSet());
        Repository repository = request.getRepository();
        return this.getCache(request).getUnchangedRefHashes(repository, modifiedRefIds, this::internalGetUnchangedHashes);
    }

    @Override
    @Nonnull
    public Collection<RefChange> resolveCommitIds(@Nonnull RepositoryHookRequest request) {
        return this.getCache(request).resolveCommitIds(request, this::internalResolveCommitIds);
    }

    @VisibleForTesting
    int getCacheSize() {
        return this.caches.size();
    }

    private static String getCacheKey(@Nonnull CommonAncestorCommandParameters parameters) {
        MessageDigest digest = DigestUtils.getSha1Digest();
        parameters.getCommitIds().stream().sorted().map(String::getBytes).forEach(digest::update);
        return Hex.encodeHexString((byte[])digest.digest());
    }

    private static String getCacheKey(@Nonnull CommitsCommandParameters parameters) {
        MessageDigest digest = DigestUtils.getSha1Digest();
        parameters.getExcludes().stream().sorted().map(String::getBytes).forEach(digest::update);
        digest.update(MARKER);
        parameters.getIncludes().stream().sorted().map(String::getBytes).forEach(digest::update);
        return Hex.encodeHexString((byte[])digest.digest());
    }

    private static String hashHookRequestId(String requestId) {
        MessageDigest digest = DigestUtils.getSha1Digest();
        digest.update(requestId.getBytes(StandardCharsets.UTF_8));
        return Hex.encodeHexString((byte[])digest.digest());
    }

    private void internalCommits(Repository repository, CommitsCommandParameters parameters, CommitCallback callback) {
        Command command = this.scmService.getCommandFactory(repository).commits(parameters, callback);
        command.setTimeout(this.timeout);
        command.call();
    }

    private MinimalCommit internalCommonAncestor(Repository repository, CommonAncestorCommandParameters parameters) {
        return (MinimalCommit)this.scmService.getCommandFactory(repository).commonAncestor(parameters).call();
    }

    private Set<String> internalGetUnchangedHashes(Repository repository, Set<String> modifiedRefIds) {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        Command command = this.scmService.getCommandFactory(repository).refs(REFS_PARAMETERS, ref -> {
            if (!modifiedRefIds.contains(ref.getId())) {
                builder.add((Object)ref.getLatestCommit());
            }
            return true;
        });
        command.setTimeout(this.timeout);
        command.call();
        return builder.build();
    }

    private Collection<RefChange> internalResolveCommitIds(@Nonnull RepositoryHookRequest request) {
        Repository repository = request.getRepository();
        Collection refChanges = request.getRefChanges();
        ResolveCommitsCommandParameters.Builder builder = new ResolveCommitsCommandParameters.Builder();
        refChanges.stream().filter(refChange -> refChange.getRef().getType() == StandardRefType.TAG).forEach(refChange -> {
            switch (refChange.getType()) {
                case ADD: {
                    builder.revisions(refChange.getToHash(), new String[0]);
                    break;
                }
                case DELETE: {
                    builder.revisions(refChange.getFromHash(), new String[0]);
                    break;
                }
                case UPDATE: {
                    builder.revisions(refChange.getFromHash(), new String[]{refChange.getToHash()});
                }
            }
        });
        ResolveCommitsCommandParameters parameters = builder.build();
        if (parameters.getRevisions().isEmpty()) {
            return refChanges;
        }
        try {
            Map result = (Map)this.scmService.getCommandFactory(repository).resolveCommits(parameters).call();
            if (result == null || result.isEmpty()) {
                return refChanges;
            }
            return refChanges.stream().map(refChange -> {
                if (refChange.getRef().getType() == StandardRefType.TAG) {
                    return ((SimpleRefChange.Builder)((SimpleRefChange.Builder)new SimpleRefChange.Builder(refChange).fromHash(result.getOrDefault(refChange.getFromHash(), refChange.getFromHash()))).toHash(result.getOrDefault(refChange.getToHash(), refChange.getToHash()))).build();
                }
                return refChange;
            }).collect(Collectors.toList());
        }
        catch (FeatureUnsupportedScmException | UnavailableScmException | UnsupportedScmException e) {
            return refChanges;
        }
    }

    private HookRequestCache getCache(RepositoryHookRequest hookRequest) {
        return this.getCache(this.getState(hookRequest));
    }

    private HookRequestCache getCache(HookRequestState state) {
        String cacheKey = CachingRepositoryHookScmHelper.hashHookRequestId(state.getRequestId());
        HookRequestCache cache = this.caches.computeIfAbsent(cacheKey, key -> new HookRequestCache(MoreFiles.mkdir((Path)this.cacheDir, (String)key)));
        if (state.isPostUpdateCalled()) {
            cache.setReadOnly();
        }
        return cache;
    }

    private HookRequestState getState(RepositoryHookRequest request) {
        String repositoryName;
        HookRequestState state = this.stateManager.getState(request);
        String requestId = CachingRepositoryHookScmHelper.hashHookRequestId(state.getRequestId());
        String string = repositoryName = log.isDebugEnabled() ? request.getRepository().toString() : "";
        if (!this.caches.containsKey(requestId)) {
            state.addCleanupCallback(() -> {
                log.debug("[{}] Cleaning up repository-hook caches for request {}", (Object)repositoryName, (Object)requestId);
                HookRequestCache cache = this.caches.remove(requestId);
                if (cache != null) {
                    cache.discard();
                }
            });
        }
        return state;
    }

    private class HookRequestCache {
        private final Path cacheDir;
        private final Map<String, MinimalCommit> commonAncestor;
        private volatile Collection<RefChange> resolvedCommitIds;
        private volatile Set<String> unchangedRefHashes;
        private volatile boolean writeable;

        HookRequestCache(Path cacheDir) {
            this.cacheDir = cacheDir;
            this.commonAncestor = new HashMap<String, MinimalCommit>();
            this.writeable = true;
        }

        MinimalCommit commonAncestor(Repository repository, CommonAncestorCommandParameters parameters, BiFunction<Repository, CommonAncestorCommandParameters, MinimalCommit> cacheLoader) {
            String cacheKey = CachingRepositoryHookScmHelper.getCacheKey(parameters);
            MinimalCommit result = this.commonAncestor.get(cacheKey);
            if (result == null) {
                result = cacheLoader.apply(repository, parameters);
                if (this.writeable) {
                    this.commonAncestor.put(cacheKey, result);
                }
            }
            return result;
        }

        void commits(Repository repository, CommitsCommandParameters parameters, CommitCallback commitCallback, CommitsLoader commitsLoader) {
            String cacheKey = CachingRepositoryHookScmHelper.getCacheKey(parameters);
            Path cacheFile = this.cacheDir.resolve(cacheKey);
            if (Files.isRegularFile(cacheFile, new LinkOption[0])) {
                this.streamFromCache(repository, cacheFile, commitCallback);
            } else {
                CommitCallback callback = this.writeable ? new CachingCommitCallback(cacheFile, commitCallback, CachingRepositoryHookScmHelper.this.maxCommits, CachingRepositoryHookScmHelper.this.maxExtraCommits) : commitCallback;
                commitsLoader.getCommits(repository, parameters, callback);
            }
        }

        Set<String> getUnchangedRefHashes(Repository repository, Set<String> modifiedRefIds, BiFunction<Repository, Set<String>, Set<String>> cacheLoader) {
            if (this.unchangedRefHashes != null) {
                return this.unchangedRefHashes;
            }
            Set<String> result = cacheLoader.apply(repository, modifiedRefIds);
            if (this.writeable) {
                this.unchangedRefHashes = result;
            }
            return result;
        }

        Collection<RefChange> resolveCommitIds(RepositoryHookRequest request, Function<RepositoryHookRequest, Collection<RefChange>> cacheLoader) {
            if (this.resolvedCommitIds != null) {
                return this.resolvedCommitIds;
            }
            Collection<RefChange> result = cacheLoader.apply(request);
            if (this.writeable) {
                this.resolvedCommitIds = result;
            }
            return result;
        }

        void setReadOnly() {
            this.writeable = false;
        }

        void discard() {
            if (Files.exists(this.cacheDir, new LinkOption[0])) {
                try {
                    MoreFiles.deleteRecursively((Path)this.cacheDir);
                }
                catch (IOException e) {
                    log.warn("Failed to delete cache dir {}", (Object)this.cacheDir, (Object)e);
                }
            }
        }

        private void streamFromCache(Repository repository, Path cacheFile, CommitCallback commitCallback) {
            try (ObjectInputStream in = new ObjectInputStream(Files.newInputStream(cacheFile, new OpenOption[0]));){
                commitCallback.onStart(new CommitContext.Builder().build());
                boolean callEnd = true;
                try {
                    Commit commit;
                    while ((commit = (Commit)in.readObject()) != null) {
                        if (commit instanceof SimpleCommit) {
                            ((SimpleCommit)commit).setRepository(repository);
                        }
                        commitCallback.onCommit(commit);
                    }
                    callEnd = false;
                    commitCallback.onEnd(new CommitSummary.Builder(CommandResult.SUCCEEDED).build());
                }
                catch (Exception e) {
                    if (callEnd) {
                        try {
                            commitCallback.onEnd(new CommitSummary.Builder(CommandResult.FAILED).build());
                        }
                        catch (Exception ex) {
                            e.addSuppressed(ex);
                        }
                    }
                    throw e;
                }
            }
            catch (Exception e) {
                throw new CommandFailedException(CachingRepositoryHookScmHelper.this.i18nService.createKeyedMessage("bitbucket.service.repository.hook.commits.failed", new Object[0]), (Throwable)e);
            }
        }
    }

    @FunctionalInterface
    private static interface CommitsLoader {
        public void getCommits(Repository var1, CommitsCommandParameters var2, CommitCallback var3);
    }

    private static class CachingCommitCallback
    implements CommitCallback {
        private final CommitCallback delegate;
        private final int maxCommits;
        private Path cacheFile;
        private int count;
        private boolean delegateWantsMore;
        private int commitsRemaining;
        private ObjectOutputStream outputStream;

        CachingCommitCallback(Path cacheFile, CommitCallback delegate, int maxCommits, int maxExtraCommits) {
            this.cacheFile = cacheFile;
            this.delegate = delegate;
            this.maxCommits = maxCommits;
            this.commitsRemaining = maxExtraCommits;
            this.delegateWantsMore = true;
        }

        public boolean onCommit(@Nonnull Commit commit) throws IOException {
            if (this.outputStream != null) {
                try {
                    if (commit instanceof Serializable && ++this.count <= this.maxCommits) {
                        this.outputStream.writeObject(commit);
                    } else {
                        this.discardCacheFile();
                    }
                }
                catch (IOException e) {
                    log.warn("Failed to write to cache file. Abandoning caching of commits for this call", (Throwable)e);
                    this.discardCacheFile();
                }
            }
            if (this.delegateWantsMore) {
                this.delegateWantsMore = this.delegate.onCommit(commit);
                return true;
            }
            if (--this.commitsRemaining > 0) {
                return true;
            }
            this.discardCacheFile();
            return false;
        }

        public void onEnd(@Nonnull CommitSummary summary) throws IOException {
            this.close();
            if (summary.getResult() != CommandResult.SUCCEEDED) {
                this.discardCacheFile();
            }
            this.delegate.onEnd(summary);
        }

        public void onStart(@Nonnull CommitContext context) throws IOException {
            this.delegate.onStart(context);
            if (this.cacheFile != null) {
                try {
                    this.outputStream = new ObjectOutputStream(Files.newOutputStream(this.cacheFile, StandardOpenOption.CREATE_NEW));
                }
                catch (IOException e) {
                    log.warn("Could not create cache file {}. SCM call to retrieve commits will not be cached", (Object)this.cacheFile, (Object)e);
                }
            }
        }

        private void close() {
            if (this.outputStream != null) {
                try {
                    this.outputStream.writeObject(null);
                }
                catch (IOException e) {
                    log.debug("Failed to write end marker in cache file {}", (Object)this.cacheFile, (Object)e);
                }
            }
            Closeables.closeQuietly((Closeable)this.outputStream);
            this.outputStream = null;
        }

        private void discardCacheFile() {
            this.close();
            if (this.cacheFile != null) {
                try {
                    Files.delete(this.cacheFile);
                }
                catch (FileNotFoundException | NoSuchFileException iOException) {
                }
                catch (IOException e) {
                    log.debug("Failed to delete cache file {}; will attempt to delete on exit", (Object)this.cacheFile, (Object)e);
                    MoreFiles.deleteOnExit((Path)this.cacheFile);
                }
            }
            this.cacheFile = null;
        }
    }
}

