/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.hook.repository;

import com.atlassian.bitbucket.content.FileEditHookRequest;
import com.atlassian.bitbucket.event.branch.BranchCreatedEvent;
import com.atlassian.bitbucket.event.branch.BranchCreationHookRequest;
import com.atlassian.bitbucket.event.branch.BranchDeletedEvent;
import com.atlassian.bitbucket.event.branch.BranchDeletionHookRequest;
import com.atlassian.bitbucket.event.content.FileEditedEvent;
import com.atlassian.bitbucket.event.pull.PullRequestMergedEvent;
import com.atlassian.bitbucket.event.repository.RepositoryPushEvent;
import com.atlassian.bitbucket.event.repository.RepositoryRefsChangedEvent;
import com.atlassian.bitbucket.event.tag.TagCreatedEvent;
import com.atlassian.bitbucket.event.tag.TagCreationHookRequest;
import com.atlassian.bitbucket.event.tag.TagDeletedEvent;
import com.atlassian.bitbucket.event.tag.TagDeletionHookRequest;
import com.atlassian.bitbucket.hook.repository.RepositoryHookRequest;
import com.atlassian.bitbucket.hook.repository.RepositoryHookService;
import com.atlassian.bitbucket.hook.repository.RepositoryHookTrigger;
import com.atlassian.bitbucket.hook.repository.RepositoryPushHookRequest;
import com.atlassian.bitbucket.hook.repository.SimplePullRequestMergeHookRequest;
import com.atlassian.bitbucket.hook.repository.SimpleRepositoryHookRequest;
import com.atlassian.bitbucket.hook.repository.StandardRepositoryHookTrigger;
import com.atlassian.bitbucket.repository.RefChange;
import com.atlassian.bitbucket.repository.sync.RefsSynchronizedEvent;
import com.atlassian.event.api.EventListener;
import com.google.common.collect.Iterables;
import jakarta.annotation.Nonnull;
import java.util.Collections;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CoreRefChangeEventToRepositoryHookAdapter {
    private static final Logger log = LoggerFactory.getLogger(CoreRefChangeEventToRepositoryHookAdapter.class);
    private final RepositoryHookService repositoryHookService;

    @Autowired
    public CoreRefChangeEventToRepositoryHookAdapter(RepositoryHookService repositoryHookService) {
        this.repositoryHookService = repositoryHookService;
    }

    @EventListener
    public void onRefsChanged(@Nonnull RepositoryRefsChangedEvent event) {
        RepositoryHookRequest request = this.buildRequest(event);
        if (request != null) {
            this.repositoryHookService.postUpdate(request);
        }
    }

    private RepositoryHookRequest buildRequest(RepositoryRefsChangedEvent event) {
        if (event instanceof RepositoryPushEvent) {
            return ((RepositoryPushHookRequest.Builder)new RepositoryPushHookRequest.Builder(event.getRepository()).refChanges((Iterable)event.getRefChanges())).build();
        }
        if (event instanceof PullRequestMergedEvent) {
            PullRequestMergedEvent mergedEvent = (PullRequestMergedEvent)event;
            String mergeHash = mergedEvent.getCommit() == null ? null : mergedEvent.getCommit().getId();
            return ((SimplePullRequestMergeHookRequest.Builder)new SimplePullRequestMergeHookRequest.Builder(mergedEvent.getPullRequest()).autoMerge(mergedEvent.isAutoMerge()).message(mergedEvent.getMessage()).mergeHash(mergeHash).dryRun(false)).strategyId(mergedEvent.getStrategyId()).build();
        }
        if (event instanceof BranchCreatedEvent) {
            return new BranchCreationHookRequest.Builder(event.getRepository(), ((BranchCreatedEvent)event).getBranch()).build();
        }
        if (event instanceof BranchDeletedEvent) {
            return new BranchDeletionHookRequest.Builder(event.getRepository(), ((BranchDeletedEvent)event).getBranch()).build();
        }
        if (event instanceof TagCreatedEvent) {
            return new TagCreationHookRequest.Builder(event.getRepository(), ((TagCreatedEvent)event).getTag()).build();
        }
        if (event instanceof TagDeletedEvent) {
            return new TagDeletionHookRequest.Builder(event.getRepository(), ((TagDeletedEvent)event).getTag()).build();
        }
        if (event instanceof FileEditedEvent) {
            FileEditedEvent editedEvent = (FileEditedEvent)event;
            RefChange change = (RefChange)Iterables.getFirst((Iterable)event.getRefChanges(), null);
            if (change == null) {
                log.warn("Not invoking PostRepositoryHooks for FileEditedEvent with no RefChanges");
                return null;
            }
            return new FileEditHookRequest.Builder(editedEvent.getRepository(), editedEvent.getBranch(), editedEvent.getPath(), editedEvent.getContent()).fromHash(change.getFromHash()).toHash(change.getToHash()).message(editedEvent.getMessage()).build();
        }
        SimpleRepositoryHookRequest.Builder builder = (SimpleRepositoryHookRequest.Builder)new SimpleRepositoryHookRequest.Builder(event.getRepository(), (RepositoryHookTrigger)StandardRepositoryHookTrigger.UNKNOWN).refChanges((Iterable)event.getRefChanges());
        if (event instanceof RefsSynchronizedEvent) {
            builder.context(Collections.singletonMap("isRefSync", true));
        }
        return builder.build();
    }
}

