/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.hook.repository;

import com.atlassian.bitbucket.hook.repository.PullRequestMergeHookRequest;
import com.atlassian.bitbucket.hook.repository.RepositoryHookRequest;
import com.atlassian.bitbucket.hook.repository.RepositoryHookResult;
import com.atlassian.bitbucket.request.RequestManager;
import com.atlassian.stash.internal.config.Clock;
import com.atlassian.stash.internal.hook.repository.HookRequestState;
import com.atlassian.stash.internal.hook.repository.HookRequestStateManager;
import com.google.common.annotations.VisibleForTesting;
import jakarta.annotation.Nonnull;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.codec.digest.DigestUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component(value="hookRequestStateManager")
public class DefaultHookRequestStateManager
implements HookRequestStateManager {
    private static final Logger log = LoggerFactory.getLogger(DefaultHookRequestStateManager.class);
    private final Clock clock;
    private final Object expiryLock;
    private final ConcurrentMap<String, SimpleHookRequestState> hookStateById;
    private final RequestManager requestManager;
    private final long stateTtlNanos;
    private long nextEvictionTimestamp;

    @Autowired
    public DefaultHookRequestStateManager(Clock clock, RequestManager requestManager, @Value(value="${repository.hook.state.ttl}") long ttlSeconds) {
        this.clock = clock;
        this.requestManager = requestManager;
        this.expiryLock = new Object();
        this.hookStateById = new ConcurrentHashMap<String, SimpleHookRequestState>();
        this.stateTtlNanos = TimeUnit.SECONDS.toNanos(Math.max(1L, ttlSeconds));
        this.nextEvictionTimestamp = clock.nanoTime() + this.stateTtlNanos / 2L;
    }

    @Override
    @Nonnull
    public HookRequestState getState(@Nonnull RepositoryHookRequest hookRequest) {
        return this.getState(this.getRequestId(hookRequest));
    }

    @VisibleForTesting
    boolean contains(String requestId) {
        return this.hookStateById.containsKey(requestId);
    }

    @Nonnull
    String getRequestId(@Nonnull RepositoryHookRequest hookRequest) {
        MessageDigest digest = DigestUtils.getSha256Digest();
        hookRequest.getRefChanges().stream().sorted((o1, o2) -> o1.getRef().getId().compareToIgnoreCase(o2.getRef().getId())).forEach(change -> {
            digest.update(change.getRef().getId().getBytes(StandardCharsets.UTF_8));
            digest.update(change.getFromHash().getBytes(StandardCharsets.UTF_8));
            digest.update(change.getToHash().getBytes(StandardCharsets.UTF_8));
        });
        StringBuilder key = new StringBuilder();
        String requestId = this.requestManager.getRequestId();
        if (requestId != null) {
            key.append(requestId).append("_");
        }
        if (hookRequest.isDryRun()) {
            int objectId = System.identityHashCode(hookRequest);
            digest.update(ByteBuffer.allocate(4).putInt(objectId).array());
        }
        if (hookRequest instanceof PullRequestMergeHookRequest) {
            key.append(((PullRequestMergeHookRequest)hookRequest).getPullRequest().getId()).append("_");
        }
        return key.append(hookRequest.getRepository().getId()).append("_").append(Hex.encodeHex((byte[])digest.digest())).toString();
    }

    @VisibleForTesting
    int getSize() {
        return this.hookStateById.size();
    }

    @Nonnull
    HookRequestState getState(@Nonnull String requestId) {
        this.maybeEvictExpiredHookRequestState();
        return this.hookStateById.computeIfAbsent(requestId, x$0 -> new SimpleHookRequestState((String)x$0));
    }

    void removeState(@Nonnull String requestId) {
        this.hookStateById.remove(requestId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void maybeEvictExpiredHookRequestState() {
        if (this.shouldEvict()) {
            Object object = this.expiryLock;
            synchronized (object) {
                if (this.shouldEvict()) {
                    this.nextEvictionTimestamp = this.clock.nanoTime() + this.stateTtlNanos / 2L;
                    this.hookStateById.values().removeIf(hookRequestState -> {
                        boolean stale;
                        boolean bl = stale = hookRequestState.getAge().toNanos() >= this.stateTtlNanos;
                        if (stale) {
                            hookRequestState.callCleanupCallbacks();
                        }
                        return stale;
                    });
                }
            }
        }
    }

    private boolean shouldEvict() {
        return this.nextEvictionTimestamp <= this.clock.nanoTime() && !this.hookStateById.isEmpty();
    }

    private class SimpleHookRequestState
    implements HookRequestState {
        private final List<Runnable> cleanupCallbacks;
        private final AtomicBoolean postUpdateCalled;
        private final AtomicBoolean postUpdateSynchronousCalled;
        private final AtomicBoolean preUpdateCalled;
        private final String requestId;
        private final long timestamp;
        private volatile RepositoryHookResult result;

        private SimpleHookRequestState(String requestId) {
            this.requestId = requestId;
            this.cleanupCallbacks = new ArrayList<Runnable>(4);
            this.postUpdateCalled = new AtomicBoolean(false);
            this.postUpdateSynchronousCalled = new AtomicBoolean(false);
            this.preUpdateCalled = new AtomicBoolean(false);
            this.timestamp = DefaultHookRequestStateManager.this.clock.nanoTime();
        }

        @Override
        public void addCleanupCallback(@Nonnull Runnable callback) {
            this.cleanupCallbacks.add(Objects.requireNonNull(callback, "callback"));
        }

        @Override
        public void callCleanupCallbacks() {
            for (Runnable callback : this.cleanupCallbacks) {
                try {
                    callback.run();
                }
                catch (Exception e) {
                    log.warn("Cleanup callback {} failed", callback.getClass(), (Object)e);
                }
            }
            this.cleanupCallbacks.clear();
        }

        @Override
        @Nonnull
        public Duration getAge() {
            return Duration.ofNanos(DefaultHookRequestStateManager.this.clock.nanoTime() - this.timestamp);
        }

        @Override
        @Nonnull
        public String getRequestId() {
            return this.requestId;
        }

        @Override
        @Nonnull
        public Optional<RepositoryHookResult> getResult() {
            return Optional.ofNullable(this.result);
        }

        @Override
        public boolean isPostUpdateCalled() {
            return this.postUpdateCalled.get();
        }

        @Override
        public boolean isPostUpdateSynchronousCalled() {
            return this.postUpdateSynchronousCalled.get();
        }

        @Override
        public boolean isPreUpdateCalled() {
            return this.preUpdateCalled.get();
        }

        @Override
        public boolean setPostUpdateCalled() {
            return this.postUpdateCalled.compareAndSet(false, true);
        }

        @Override
        public boolean setPostUpdateSynchronousCalled() {
            return this.postUpdateSynchronousCalled.compareAndSet(false, true);
        }

        @Override
        public boolean setPreUpdateCalled() {
            return this.preUpdateCalled.compareAndSet(false, true);
        }

        @Override
        public void setResult(@Nonnull RepositoryHookResult value) {
            this.result = value;
        }
    }
}

