/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.hook.repository;

import com.atlassian.bitbucket.commit.Commit;
import com.atlassian.bitbucket.commit.CommitCallback;
import com.atlassian.bitbucket.commit.CommitOrder;
import com.atlassian.bitbucket.commit.MinimalCommit;
import com.atlassian.bitbucket.hook.repository.MergeHookRequest;
import com.atlassian.bitbucket.hook.repository.RepositoryHookCommitFilter;
import com.atlassian.bitbucket.hook.repository.RepositoryHookRequest;
import com.atlassian.bitbucket.hook.repository.RepositoryHookResult;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.repository.MinimalRef;
import com.atlassian.bitbucket.repository.Ref;
import com.atlassian.bitbucket.repository.RefChange;
import com.atlassian.bitbucket.repository.RefChangeType;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.repository.SimpleRefChange;
import com.atlassian.bitbucket.scm.CommitsCommandParameters;
import com.atlassian.bitbucket.scm.CommonAncestorCommandParameters;
import com.atlassian.bitbucket.util.ShaUtils;
import com.atlassian.bitbucket.util.SortedShaSet;
import com.atlassian.stash.internal.hook.repository.RepositoryHookCallbackInvoker;
import com.atlassian.stash.internal.hook.repository.RepositoryHookCallbackRegistration;
import com.atlassian.stash.internal.hook.repository.RepositoryHookScmHelper;
import com.atlassian.stash.internal.hook.repository.SafeRepositoryHookCommitCallback;
import com.atlassian.stash.internal.hook.repository.SimpleCommitAddedDetails;
import com.atlassian.stash.internal.hook.repository.SimpleCommitRemovedDetails;
import jakarta.annotation.Nonnull;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component(value="repositoryHookCallbackInvoker")
public class DefaultRepositoryHookCallbackInvoker
implements RepositoryHookCallbackInvoker {
    private static final Logger log = LoggerFactory.getLogger(Logger.class);
    private final I18nService i18nService;
    private final int maxMessageLength;
    private final RepositoryHookScmHelper scmHelper;

    @Autowired
    public DefaultRepositoryHookCallbackInvoker(I18nService i18nService, RepositoryHookScmHelper scmHelper, @Value(value="${commit.message.bulk.max}") int maxMessageLength) {
        this.i18nService = i18nService;
        this.maxMessageLength = maxMessageLength;
        this.scmHelper = scmHelper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void invokePostCallbacks(@Nonnull RepositoryHookRequest request, @Nonnull List<RepositoryHookCallbackRegistration> registrations) {
        if (registrations.isEmpty()) {
            log.trace("[{}] No commit details requested. Skipping providing commit details", (Object)request.getRepository());
            return;
        }
        SafeRepositoryHookCommitCallback callback = new SafeRepositoryHookCommitCallback(request, false, log, this.i18nService, registrations, false);
        callback.onStart();
        try {
            this.streamCommitDetails(request, callback);
        }
        finally {
            callback.onEnd();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nonnull
    public RepositoryHookResult invokePreCallbacks(@Nonnull RepositoryHookRequest request, @Nonnull List<RepositoryHookCallbackRegistration> registrations) {
        if (registrations.isEmpty()) {
            log.trace("[{}] No commit details requested. Skipping providing commit details", (Object)request.getRepository());
            return RepositoryHookResult.accepted();
        }
        if (request.getRefChanges().isEmpty() && !DefaultRepositoryHookCallbackInvoker.isDryRunMerge(request)) {
            log.trace("[{}] No ref-changes provided for {} request with trigger {}. Skipping providing commit details", new Object[]{request.getRepository(), request.getClass().getSimpleName(), request.getTrigger().getId()});
            return RepositoryHookResult.accepted();
        }
        SafeRepositoryHookCommitCallback callback = new SafeRepositoryHookCommitCallback(request, true, log, this.i18nService, registrations, request.getTrigger().isAbortOnFirstVeto());
        callback.onStart();
        try {
            this.streamCommitDetails(request, callback);
        }
        finally {
            callback.onEnd();
        }
        return callback.getResult();
    }

    private static boolean canIntroduceCommits(RepositoryHookRequest request) {
        if (request instanceof MergeHookRequest) {
            MergeHookRequest mergeRequest = (MergeHookRequest)request;
            return mergeRequest.isCrossRepository();
        }
        return request.getRefChanges().stream().anyMatch(change -> change.getType() != RefChangeType.DELETE);
    }

    private static boolean canStripCommits(RepositoryHookRequest request) {
        if (request instanceof MergeHookRequest) {
            return false;
        }
        return request.getRefChanges().stream().anyMatch(change -> change.getType() != RefChangeType.ADD);
    }

    private static boolean isDryRunMerge(RepositoryHookRequest request) {
        return request.isDryRun() && request instanceof MergeHookRequest;
    }

    private static <T> void removeAll(Iterable<T> iterable, Predicate<T> predicate) {
        Iterator<T> it = iterable.iterator();
        while (it.hasNext()) {
            T item = it.next();
            if (!predicate.test(item)) continue;
            it.remove();
        }
    }

    private void streamCommitDetails(RepositoryHookRequest request, SafeRepositoryHookCommitCallback hooksCallback) {
        if (hooksCallback.isDone()) {
            return;
        }
        if (DefaultRepositoryHookCallbackInvoker.isDryRunMerge(request)) {
            this.streamCommitDetailsForDryRunMerge((MergeHookRequest)request, hooksCallback);
        } else {
            this.streamCommitDetailsForRefChanges(request, hooksCallback);
        }
    }

    private void streamCommitDetailsForDryRunMerge(MergeHookRequest request, SafeRepositoryHookCommitCallback hooksCallback) {
        RefChangeAnalyzer analyzer = new RefChangeAnalyzer((RefChange)((SimpleRefChange.Builder)((SimpleRefChange.Builder)((SimpleRefChange.Builder)new SimpleRefChange.Builder().fromHash(ShaUtils.NULL_SHA1)).to((Ref)request.getFromRef())).type(RefChangeType.ADD)).build());
        Repository fromRepository = request.getFromRef().getRepository();
        boolean crossRepository = request.isCrossRepository();
        List<RefChangeAnalyzer> analyzers = Collections.singletonList(analyzer);
        HookCallbackInvokingCallback commitCallback = new HookCallbackInvokingCallback(analyzers, hooksCallback);
        if (crossRepository && hooksCallback.matches(RepositoryHookCommitFilter.ADDED_TO_REPOSITORY)) {
            Set<String> unchangedRefHashes = this.scmHelper.getUnchangedRefCommitIds((RepositoryHookRequest)request);
            CommitsCommandParameters.Builder builder = new CommitsCommandParameters.Builder().exclude(unchangedRefHashes).ignoreMissing(true).exclude(request.getToRef().getLatestCommit(), new String[0]).include(request.getFromRef().getLatestCommit(), new String[0]).maxMessageLength(this.maxMessageLength).order(CommitOrder.TOPOLOGICAL).secondaryRepository(fromRepository);
            commitCallback.markAddedCommitsAreIntroduced(true);
            this.scmHelper.commits((RepositoryHookRequest)request, builder.build(), commitCallback);
            commitCallback.markAddedCommitsAreIntroduced(false);
            if (hooksCallback.isDone()) {
                return;
            }
        }
        if (hooksCallback.matches(RepositoryHookCommitFilter.ADDED_TO_ANY_REF)) {
            CommitsCommandParameters.Builder parameterBuilder = new CommitsCommandParameters.Builder().exclude(request.getToRef().getLatestCommit(), new String[0]).maxMessageLength(this.maxMessageLength).secondaryRepository((Repository)(crossRepository ? fromRepository : null)).order(CommitOrder.TOPOLOGICAL);
            analyzer.toShas.forEach(x$0 -> parameterBuilder.include(x$0, new String[0]));
            this.scmHelper.commits((RepositoryHookRequest)request, parameterBuilder.build(), commitCallback);
        }
    }

    private void streamCommitDetailsForRefChanges(RepositoryHookRequest request, SafeRepositoryHookCommitCallback hooksCallback) {
        if (hooksCallback.isDone() || request.getRefChanges().isEmpty()) {
            return;
        }
        boolean canIntroduceCommits = DefaultRepositoryHookCallbackInvoker.canIntroduceCommits(request);
        boolean canStripCommits = DefaultRepositoryHookCallbackInvoker.canStripCommits(request);
        Collection<RefChange> refChanges = this.scmHelper.resolveCommitIds(request);
        LinkedList<RefChangeAnalyzer> analyzers = new LinkedList<RefChangeAnalyzer>();
        refChanges.forEach(change -> analyzers.add(new RefChangeAnalyzer((RefChange)change)));
        Set<String> unchangedRefHashes = this.scmHelper.getUnchangedRefCommitIds(request);
        HookCallbackInvokingCallback commitCallback = new HookCallbackInvokingCallback(analyzers, hooksCallback);
        if (canIntroduceCommits && hooksCallback.matches(RepositoryHookCommitFilter.ADDED_TO_REPOSITORY)) {
            this.streamIntroducedCommits(request, unchangedRefHashes, analyzers, commitCallback);
        }
        DefaultRepositoryHookCallbackInvoker.removeAll(analyzers, analyzer -> analyzer.type == RefChangeType.ADD);
        if (hooksCallback.isDone() || analyzers.isEmpty()) {
            return;
        }
        if (canStripCommits && hooksCallback.matches(RepositoryHookCommitFilter.REMOVED_FROM_REPOSITORY)) {
            this.streamStrippedCommits(request, unchangedRefHashes, analyzers, commitCallback);
        }
        DefaultRepositoryHookCallbackInvoker.removeAll(analyzers, tracker -> tracker.type == RefChangeType.DELETE);
        if (hooksCallback.isDone() || analyzers.isEmpty() || !hooksCallback.matches(RepositoryHookCommitFilter.ADDED_TO_ANY_REF) && !hooksCallback.matches(RepositoryHookCommitFilter.REMOVED_FROM_ANY_REF)) {
            return;
        }
        this.streamCommitsUpToMergeBase(request, analyzers, commitCallback);
    }

    private void streamCommitsUpToMergeBase(RepositoryHookRequest request, List<RefChangeAnalyzer> analyzers, CommitCallback commitCallback) {
        HashSet unresolvedHashes = new HashSet();
        analyzers.forEach(analyzer -> {
            analyzer.fromShas.forEach(unresolvedHashes::add);
            analyzer.toShas.forEach(unresolvedHashes::add);
        });
        MinimalCommit commonAncestor = this.scmHelper.commonAncestor(request, new CommonAncestorCommandParameters.Builder().commitId(unresolvedHashes).build());
        CommitsCommandParameters.Builder unresolvedCommitsParameter = new CommitsCommandParameters.Builder().ignoreMissing(true).include(unresolvedHashes).maxMessageLength(this.maxMessageLength).order(CommitOrder.TOPOLOGICAL);
        if (commonAncestor != null) {
            unresolvedCommitsParameter.exclude(commonAncestor.getId(), new String[0]);
        }
        this.scmHelper.commits(request, unresolvedCommitsParameter.build(), commitCallback);
    }

    private void streamIntroducedCommits(RepositoryHookRequest request, Set<String> unchangedRefHashes, List<RefChangeAnalyzer> analyzers, HookCallbackInvokingCallback commitCallback) {
        CommitsCommandParameters.Builder builder = new CommitsCommandParameters.Builder().exclude(unchangedRefHashes).ignoreMissing(true).maxMessageLength(this.maxMessageLength).order(CommitOrder.TOPOLOGICAL);
        analyzers.forEach(analyzer -> {
            analyzer.fromShas.forEach(x$0 -> builder.exclude(x$0, new String[0]));
            analyzer.toShas.forEach(x$0 -> builder.include(x$0, new String[0]));
        });
        commitCallback.markAddedCommitsAreIntroduced(true);
        this.scmHelper.commits(request, builder.build(), commitCallback);
        commitCallback.markAddedCommitsAreIntroduced(false);
    }

    private void streamStrippedCommits(RepositoryHookRequest request, Set<String> unchangedRefHashes, List<RefChangeAnalyzer> analyzers, HookCallbackInvokingCallback commitCallback) {
        CommitsCommandParameters.Builder builder = new CommitsCommandParameters.Builder().exclude(unchangedRefHashes).ignoreMissing(true).maxMessageLength(this.maxMessageLength).order(CommitOrder.TOPOLOGICAL);
        analyzers.forEach(analyzer -> {
            analyzer.fromShas.forEach(x$0 -> builder.include(x$0, new String[0]));
            analyzer.toShas.forEach(x$0 -> builder.exclude(x$0, new String[0]));
        });
        commitCallback.markRemovedCommitsAsStripped(true);
        this.scmHelper.commits(request, builder.build(), commitCallback);
        commitCallback.markRemovedCommitsAsStripped(false);
    }

    private static class RefChangeAnalyzer {
        private final SortedShaSet fromShas = new SortedShaSet();
        private final SortedShaSet toShas = new SortedShaSet();
        private final MinimalRef ref;
        private final RefChangeType type;

        private RefChangeAnalyzer(RefChange refChange) {
            this.ref = refChange.getRef();
            this.type = refChange.getType();
            switch (refChange.getType()) {
                case ADD: {
                    this.toShas.add(refChange.getToHash());
                    break;
                }
                case DELETE: {
                    this.fromShas.add(refChange.getFromHash());
                    break;
                }
                case UPDATE: {
                    this.toShas.add(refChange.getToHash());
                    this.fromShas.add(refChange.getFromHash());
                }
            }
        }

        boolean isCommonAncestorFound() {
            return this.type == RefChangeType.UPDATE && this.fromShas.equals((Object)this.toShas);
        }

        boolean matchesFrom(Commit commit) {
            if (this.fromShas.remove(commit.getId())) {
                commit.getParents().forEach(parent -> this.fromShas.add(parent.getId()));
                return true;
            }
            return false;
        }

        boolean matchesTo(Commit commit) {
            if (this.toShas.remove(commit.getId())) {
                commit.getParents().forEach(parent -> this.toShas.add(parent.getId()));
                return true;
            }
            return false;
        }
    }

    private static class HookCallbackInvokingCallback
    implements CommitCallback {
        private final List<RefChangeAnalyzer> analyzers;
        private final SafeRepositoryHookCommitCallback callback;
        private boolean introduced;
        private boolean stripped;

        private HookCallbackInvokingCallback(List<RefChangeAnalyzer> analyzers, SafeRepositoryHookCommitCallback callback) {
            this.analyzers = analyzers;
            this.callback = callback;
        }

        public boolean onCommit(@Nonnull Commit commit) throws IOException {
            Iterator<RefChangeAnalyzer> it = this.analyzers.iterator();
            while (it.hasNext()) {
                RefChangeAnalyzer analyzer = it.next();
                boolean matchesTo = analyzer.matchesTo(commit);
                boolean matchesFrom = analyzer.matchesFrom(commit);
                if (matchesTo && !matchesFrom) {
                    this.callback.onCommitAdded(new SimpleCommitAddedDetails(commit, analyzer.ref, this.introduced));
                } else if (matchesFrom && !matchesTo) {
                    this.callback.onCommitRemoved(new SimpleCommitRemovedDetails(commit, analyzer.ref, this.stripped));
                }
                if (!analyzer.isCommonAncestorFound()) continue;
                it.remove();
            }
            return !this.callback.isDone() && !this.analyzers.isEmpty();
        }

        void markAddedCommitsAreIntroduced(boolean value) {
            this.introduced = value;
        }

        void markRemovedCommitsAsStripped(boolean value) {
            this.stripped = value;
        }
    }
}

