/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.hook.repository;

import com.atlassian.bitbucket.dmz.hook.script.RepositoryHookRestrictionEnricher;
import com.atlassian.bitbucket.dmz.hook.script.RestrictedRepositoryHook;
import com.atlassian.bitbucket.dmz.settingsrestriction.ProjectSettingsRestrictionKeys;
import com.atlassian.bitbucket.dmz.settingsrestriction.ProjectSettingsRestrictionState;
import com.atlassian.bitbucket.hook.repository.RepositoryHook;
import com.atlassian.bitbucket.project.Project;
import com.atlassian.bitbucket.scope.ProjectScope;
import com.atlassian.bitbucket.scope.RepositoryScope;
import com.atlassian.bitbucket.scope.Scope;
import com.atlassian.bitbucket.scope.ScopeVisitor;
import com.atlassian.bitbucket.settingsrestriction.ProjectSettingsRestriction;
import com.atlassian.bitbucket.settingsrestriction.ProjectSettingsRestrictionService;
import com.atlassian.bitbucket.settingsrestriction.RestrictionProcessedState;
import com.atlassian.bitbucket.settingsrestriction.SettingsKey;
import com.atlassian.bitbucket.util.Page;
import com.atlassian.plugin.spring.AvailableToPlugins;
import com.atlassian.stash.internal.hook.repository.SimpleRestrictedRepositoryHook;
import jakarta.annotation.Nonnull;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@AvailableToPlugins(value=RepositoryHookRestrictionEnricher.class)
@Component(value="repositoryHookEnricher")
public class DefaultRepositoryHookRestrictionEnricher
implements RepositoryHookRestrictionEnricher {
    private final ProjectSettingsRestrictionService restrictionService;

    @Autowired
    public DefaultRepositoryHookRestrictionEnricher(ProjectSettingsRestrictionService restrictionService) {
        this.restrictionService = restrictionService;
    }

    @Nonnull
    public RestrictedRepositoryHook enrich(@Nonnull RepositoryHook repositoryHook) {
        Objects.requireNonNull(repositoryHook, "repositoryHook");
        return new SimpleRestrictedRepositoryHook(repositoryHook, this.getHookRestrictionState(repositoryHook));
    }

    @Nonnull
    public Page<RestrictedRepositoryHook> enrichPage(@Nonnull Page<RepositoryHook> repositoryHookPage, @Nonnull Scope scope) {
        Objects.requireNonNull(repositoryHookPage, "repositoryHookPage");
        Objects.requireNonNull(scope, "scope");
        Map<String, ProjectSettingsRestrictionState> restrictionStates = this.getHookRestrictionStatesForProject(this.getProject(scope));
        return repositoryHookPage.transform(repositoryHook -> new SimpleRestrictedRepositoryHook((RepositoryHook)repositoryHook, restrictionStates.getOrDefault(repositoryHook.getDetails().getKey(), ProjectSettingsRestrictionState.NONE)));
    }

    private ProjectSettingsRestrictionState getHookRestrictionState(RepositoryHook repositoryHook) {
        Project project = this.getProject(repositoryHook.getScope());
        return this.restrictionService.get(project, ProjectSettingsRestrictionKeys.withComponentKey((SettingsKey)ProjectSettingsRestrictionKeys.HOOKS, (String)repositoryHook.getDetails().getKey())).map(ProjectSettingsRestriction::getProcessedState).map(ProjectSettingsRestrictionState::fromProcessedState).orElse(ProjectSettingsRestrictionState.NONE);
    }

    private Map<String, ProjectSettingsRestrictionState> getHookRestrictionStatesForProject(Project project) {
        Set restrictions = this.restrictionService.getAll(project, ProjectSettingsRestrictionKeys.HOOKS.getNamespace(), ProjectSettingsRestrictionKeys.HOOKS.getFeatureKey());
        return restrictions.stream().filter(restriction -> restriction.getSettingsKey().getComponentKey().isPresent()).collect(Collectors.toMap(restriction -> (String)restriction.getSettingsKey().getComponentKey().get(), restriction -> ProjectSettingsRestrictionState.fromProcessedState((RestrictionProcessedState)restriction.getProcessedState())));
    }

    private Project getProject(Scope scope) {
        return (Project)scope.accept((ScopeVisitor)new ScopeVisitor<Project>(this){

            public Project visit(@Nonnull ProjectScope scope) {
                return scope.getProject();
            }

            public Project visit(@Nonnull RepositoryScope scope) {
                return scope.getProject();
            }
        });
    }
}

