/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.hook.repository;

import com.atlassian.bitbucket.ForbiddenException;
import com.atlassian.bitbucket.IllegalEntityStateException;
import com.atlassian.bitbucket.NoSuchEntityException;
import com.atlassian.bitbucket.avatar.AvatarSupplier;
import com.atlassian.bitbucket.avatar.CacheableAvatarSupplier;
import com.atlassian.bitbucket.avatar.DelegatingCacheableAvatarSupplier;
import com.atlassian.bitbucket.avatar.SimpleAvatarSupplier;
import com.atlassian.bitbucket.dmz.settingsrestriction.DmzProjectSettingsRestrictionService;
import com.atlassian.bitbucket.dmz.settingsrestriction.ProjectSettingsRestrictionKeys;
import com.atlassian.bitbucket.event.hook.RepositoryHookDeletedEvent;
import com.atlassian.bitbucket.event.hook.RepositoryHookDisabledEvent;
import com.atlassian.bitbucket.event.hook.RepositoryHookEnabledEvent;
import com.atlassian.bitbucket.event.hook.RepositoryHookSettingsChangedEvent;
import com.atlassian.bitbucket.hook.repository.AbstractUpdateRepositoryHookRequest;
import com.atlassian.bitbucket.hook.repository.DeleteRepositoryHookRequest;
import com.atlassian.bitbucket.hook.repository.DisableRepositoryHookRequest;
import com.atlassian.bitbucket.hook.repository.EnableRepositoryHookRequest;
import com.atlassian.bitbucket.hook.repository.GetRepositoryHookSettingsRequest;
import com.atlassian.bitbucket.hook.repository.PostRepositoryHook;
import com.atlassian.bitbucket.hook.repository.PostRepositoryHookContext;
import com.atlassian.bitbucket.hook.repository.PreRepositoryHook;
import com.atlassian.bitbucket.hook.repository.PreRepositoryHookContext;
import com.atlassian.bitbucket.hook.repository.RepositoryHook;
import com.atlassian.bitbucket.hook.repository.RepositoryHookCommitCallback;
import com.atlassian.bitbucket.hook.repository.RepositoryHookCommitFilter;
import com.atlassian.bitbucket.hook.repository.RepositoryHookDetails;
import com.atlassian.bitbucket.hook.repository.RepositoryHookRequest;
import com.atlassian.bitbucket.hook.repository.RepositoryHookResult;
import com.atlassian.bitbucket.hook.repository.RepositoryHookSearchRequest;
import com.atlassian.bitbucket.hook.repository.RepositoryHookService;
import com.atlassian.bitbucket.hook.repository.RepositoryHookSettings;
import com.atlassian.bitbucket.hook.repository.RepositoryHookType;
import com.atlassian.bitbucket.hook.repository.SetRepositoryHookSettingsRequest;
import com.atlassian.bitbucket.hook.repository.SynchronousPreferred;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.permission.PermissionValidationService;
import com.atlassian.bitbucket.project.PersonalProject;
import com.atlassian.bitbucket.project.Project;
import com.atlassian.bitbucket.project.ProjectVisitor;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.scope.GlobalScope;
import com.atlassian.bitbucket.scope.ProjectScope;
import com.atlassian.bitbucket.scope.RepositoryScope;
import com.atlassian.bitbucket.scope.Scope;
import com.atlassian.bitbucket.scope.ScopeType;
import com.atlassian.bitbucket.scope.ScopeVisitor;
import com.atlassian.bitbucket.scope.Scopes;
import com.atlassian.bitbucket.setting.Settings;
import com.atlassian.bitbucket.setting.SettingsBuilder;
import com.atlassian.bitbucket.setting.SettingsValidationErrors;
import com.atlassian.bitbucket.setting.SettingsValidator;
import com.atlassian.bitbucket.settingsrestriction.ProjectSettingsRestriction;
import com.atlassian.bitbucket.settingsrestriction.SettingsKey;
import com.atlassian.bitbucket.util.BuilderSupport;
import com.atlassian.bitbucket.util.MoreCollectors;
import com.atlassian.bitbucket.util.Page;
import com.atlassian.bitbucket.util.PageRequest;
import com.atlassian.bitbucket.util.PageUtils;
import com.atlassian.bitbucket.util.Timer;
import com.atlassian.bitbucket.util.TimerUtils;
import com.atlassian.bitbucket.validation.ArgumentValidationException;
import com.atlassian.bitbucket.validation.FormErrors;
import com.atlassian.bitbucket.validation.FormValidationException;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.plugin.ModuleDescriptor;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.descriptors.AbstractModuleDescriptor;
import com.atlassian.plugin.spring.AvailableToPlugins;
import com.atlassian.stash.internal.AbstractService;
import com.atlassian.stash.internal.InternalConverter;
import com.atlassian.stash.internal.annotation.Secured;
import com.atlassian.stash.internal.annotation.Unsecured;
import com.atlassian.stash.internal.hook.repository.EmptyHookSettings;
import com.atlassian.stash.internal.hook.repository.HookRequestState;
import com.atlassian.stash.internal.hook.repository.HookRequestStateManager;
import com.atlassian.stash.internal.hook.repository.InternalRepositoryHookService;
import com.atlassian.stash.internal.hook.repository.RepositoryHookCallbackInvoker;
import com.atlassian.stash.internal.hook.repository.RepositoryHookCallbackRegistrar;
import com.atlassian.stash.internal.hook.repository.RepositoryHookCallbackRegistration;
import com.atlassian.stash.internal.hook.repository.SimplePostRepositoryHookContext;
import com.atlassian.stash.internal.hook.repository.SimplePreRepositoryHookContext;
import com.atlassian.stash.internal.hook.repository.SimpleRepositoryHook;
import com.atlassian.stash.internal.hook.repository.SimpleRepositoryHookDetails;
import com.atlassian.stash.internal.hook.repository.SimpleRepositoryHookSettings;
import com.atlassian.stash.internal.plugin.RepositoryHookModuleDescriptor;
import com.atlassian.stash.internal.plugin.ValidatorModuleDescriptor;
import com.atlassian.stash.internal.repository.InternalRepository;
import com.atlassian.stash.internal.repository.InternalRepositoryHook;
import com.atlassian.stash.internal.repository.RepositoryHookDao;
import com.atlassian.stash.internal.setting.InternalSharedLob;
import com.atlassian.stash.internal.setting.MapSettingsBuilder;
import com.atlassian.stash.internal.setting.SettingsHelper;
import com.atlassian.stash.internal.spring.SpringTransactionUtils;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Collections2;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import jakarta.annotation.Nonnull;
import java.io.IOException;
import java.net.FileNameMap;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.support.DefaultMessageSourceResolvable;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.core.io.Resource;
import org.springframework.core.io.UrlResource;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.support.TransactionTemplate;
import org.springframework.validation.AbstractBindingResult;
import org.springframework.validation.Errors;
import org.springframework.validation.FieldError;

@AvailableToPlugins(value=RepositoryHookService.class)
@Service(value="repositoryHookService")
public class DefaultRepositoryHookService
extends AbstractService
implements InternalRepositoryHookService {
    private static final Logger log = LoggerFactory.getLogger(DefaultRepositoryHookService.class);
    private static final String HOOK_DEFAULT_ICON = "/hooks/icon-default-hook.png";
    private static final String MERGE_CHECK_DEFAULT_ICON = "/hooks/icon-default-merge-check.png";
    private static final Comparator<SimpleRepositoryHookDetails> HOOK_NAME_COMPARATOR = Comparator.comparing(SimpleRepositoryHookDetails::getName);
    private final RepositoryHookCallbackInvoker callbackInvoker;
    private final EventPublisher eventPublisher;
    private final FileNameMap fileNameMap;
    private final RepositoryHookDao hookDao;
    private final HookRequestStateManager hookStateManager;
    private final I18nService i18nService;
    private final TransactionTemplate noTx;
    private final PermissionValidationService permissionValidationService;
    private final PluginAccessor pluginAccessor;
    private final DmzProjectSettingsRestrictionService projectSettingsRestrictionService;
    private final TransactionTemplate readOnlyTx;
    private final SettingsHelper settingsHelper;

    @Autowired
    public DefaultRepositoryHookService(RepositoryHookCallbackInvoker callbackInvoker, EventPublisher eventPublisher, FileNameMap fileNameMap, RepositoryHookDao hookDao, HookRequestStateManager hookStateManager, I18nService i18nService, PermissionValidationService permissionValidationService, PluginAccessor pluginAccessor, SettingsHelper settingsHelper, PlatformTransactionManager transactionManager, DmzProjectSettingsRestrictionService projectSettingsRestrictionService) {
        this(callbackInvoker, eventPublisher, fileNameMap, hookDao, hookStateManager, i18nService, permissionValidationService, pluginAccessor, settingsHelper, new TransactionTemplate(transactionManager, SpringTransactionUtils.definitionFor((int)4)), new TransactionTemplate(transactionManager, SpringTransactionUtils.definitionFor((int)0, (boolean)true)), projectSettingsRestrictionService);
    }

    DefaultRepositoryHookService(RepositoryHookCallbackInvoker callbackInvoker, EventPublisher eventPublisher, FileNameMap fileNameMap, RepositoryHookDao hookDao, HookRequestStateManager hookStateManager, I18nService i18nService, PermissionValidationService permissionValidationService, PluginAccessor pluginAccessor, SettingsHelper settingsHelper, TransactionTemplate noTx, TransactionTemplate readOnlyTx, DmzProjectSettingsRestrictionService projectSettingsRestrictionService) {
        this.callbackInvoker = callbackInvoker;
        this.eventPublisher = eventPublisher;
        this.fileNameMap = fileNameMap;
        this.hookDao = hookDao;
        this.hookStateManager = hookStateManager;
        this.i18nService = i18nService;
        this.noTx = noTx;
        this.permissionValidationService = permissionValidationService;
        this.pluginAccessor = pluginAccessor;
        this.projectSettingsRestrictionService = projectSettingsRestrictionService;
        this.readOnlyTx = readOnlyTx;
        this.settingsHelper = settingsHelper;
    }

    @Nonnull
    @Unsecured(value="No private data is exposed by this method")
    @Transactional(propagation=Propagation.SUPPORTS)
    public SettingsBuilder createSettingsBuilder() {
        return new MapSettingsBuilder();
    }

    @Secured(value="Permission check performed internally")
    @Transactional
    public void delete(@Nonnull DeleteRepositoryHookRequest request) {
        Scope scope = Objects.requireNonNull(request, "request").getScope();
        this.validateAdminPermission(scope);
        if (scope.getType() != ScopeType.REPOSITORY) {
            throw new ArgumentValidationException(this.i18nService.createKeyedMessage("bitbucket.service.repository.hook.delete.invalidscope", new Object[]{scope.getType()}));
        }
        String hookKey = request.getHookKey();
        this.getModuleDescriptorOrFail(hookKey);
        this.validateHookIsNotRestricted(scope, hookKey, "bitbucket.service.repository.hook.delete.restricted");
        this.hookDao.deleteByKey(scope, hookKey);
        this.eventPublisher.publish((Object)new RepositoryHookDeletedEvent((Object)this, scope, hookKey));
    }

    @Nonnull
    @Secured(value="Permission check performed internally")
    @Transactional
    public RepositoryHook disable(@Nonnull DisableRepositoryHookRequest request) {
        String hookKey = Objects.requireNonNull(request, "request").getHookKey();
        Scope scope = request.getScope();
        this.validateAdminPermission(scope);
        this.validateScopeSupported(scope, this.getHookDetailsOrFail(hookKey));
        this.validateHookIsNotRestricted(scope, hookKey, "bitbucket.service.repository.hook.update.restricted");
        return this.setEnabled((AbstractUpdateRepositoryHookRequest)request, null, false);
    }

    @Nonnull
    @Secured(value="Permission check performed internally")
    @Transactional
    public RepositoryHook enable(@Nonnull EnableRepositoryHookRequest request) {
        Objects.requireNonNull(request, "request");
        Scope scope = request.getScope();
        this.validateAdminPermission(scope);
        String hookKey = request.getHookKey();
        Optional opSettings = request.getSettings();
        this.validateScopeSupported(scope, this.getHookDetailsOrFail(hookKey));
        opSettings.ifPresent(settings -> this.validateSettings(hookKey, scope, (Settings)settings));
        this.validateHookIsNotRestricted(scope, hookKey, "bitbucket.service.repository.hook.create.restricted");
        return this.setEnabled((AbstractUpdateRepositoryHookRequest)request, opSettings.orElse(null), true);
    }

    @Nonnull
    @PreAuthorize(value="hasGlobalPermission('LICENSED_USER')")
    public CacheableAvatarSupplier getAvatar(@Nonnull String hookKey) {
        SimpleRepositoryHookDetails details = this.getHookDetailsOrFail(hookKey);
        if (details.getIconPath() == null) {
            return this.getDefaultAvatar(details.getType());
        }
        try {
            Plugin plugin = this.pluginAccessor.getEnabledPluginModule(hookKey).getPlugin();
            URL resource = plugin.getResource(details.getIconPath());
            if (resource != null) {
                return this.getCacheableSupplier((Resource)new UrlResource(resource));
            }
        }
        catch (IOException e) {
            if (log.isDebugEnabled()) {
                log.warn("Error loading icon for {}", (Object)hookKey, (Object)e);
            }
            log.warn("Error loading icon for {}: {}", (Object)hookKey, (Object)e.getMessage());
        }
        return this.getDefaultAvatar(details.getType());
    }

    @Secured(value="Permission check performed internally")
    public RepositoryHook getByKey(@Nonnull Scope scope, @Nonnull String hookKey) {
        ModuleDescriptor moduleDescriptor;
        Objects.requireNonNull(scope, "scope");
        Objects.requireNonNull(hookKey, "hookKey");
        this.validateAdminPermission(scope);
        try {
            moduleDescriptor = this.pluginAccessor.getEnabledPluginModule(hookKey);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
        if (!(moduleDescriptor instanceof RepositoryHookModuleDescriptor)) {
            return null;
        }
        RepositoryHookModuleDescriptor hookDescriptor = (RepositoryHookModuleDescriptor)moduleDescriptor;
        if (!hookDescriptor.isConfigurable()) {
            return null;
        }
        SimpleRepositoryHookDetails hookDetails = SimpleRepositoryHookDetails.FROM_MODULE_DESCRIPTOR.apply((RepositoryHookModuleDescriptor)moduleDescriptor);
        InternalRepositoryHook internalHook = this.getEffectiveRepositoryHook(scope, hookKey);
        if (internalHook == null) {
            Scope definedScope = this.getHighestConfigurableScope(scope, hookDetails);
            return new SimpleRepositoryHook(hookDetails, false, false, definedScope);
        }
        return new SimpleRepositoryHook(hookDetails, internalHook.isEnabled(), internalHook.hasSettings(), internalHook.getScope());
    }

    @Secured(value="Permission check performed internally")
    public RepositoryHookSettings getSettings(@Nonnull GetRepositoryHookSettingsRequest request) {
        Objects.requireNonNull(request, "request");
        String hookKey = request.getHookKey();
        Scope scope = request.getScope();
        this.validateAdminPermission(scope);
        InternalRepositoryHook hook = this.getEffectiveRepositoryHook(scope, hookKey);
        return hook == null || hook.getSettings() == null ? null : new SimpleRepositoryHookSettings(hook.getScope(), this.settingsHelper.deserialize(hook.getSettings().getData()));
    }

    @PreAuthorize(value="hasGlobalPermission('ADMIN')")
    @Transactional
    public int migrateSettings(@Nonnull String oldHookKey, @Nonnull String newHookKey) {
        if (this.pluginAccessor.getEnabledPluginModule(oldHookKey) != null) {
            throw new ArgumentValidationException(this.i18nService.createKeyedMessage("bitbucket.service.repository.hook.migrate.oldstillinstalled", new Object[]{oldHookKey, newHookKey}));
        }
        if (this.pluginAccessor.getEnabledPluginModule(newHookKey) == null) {
            throw new ArgumentValidationException(this.i18nService.createKeyedMessage("bitbucket.service.repository.hook.migrate.newnotinstalled", new Object[]{oldHookKey, newHookKey}));
        }
        return this.hookDao.updateKey(oldHookKey, newHookKey);
    }

    @Transactional(propagation=Propagation.SUPPORTS)
    @Unsecured(value="Free for plugins to call and not exposed otherwise")
    public <T extends RepositoryHookRequest> void postUpdate(@Nonnull T request) {
        this.doPostUpdate(request, false);
    }

    @Transactional(propagation=Propagation.SUPPORTS)
    @Unsecured(value="Internal method only called from SCM hooks")
    public <T extends RepositoryHookRequest> void postUpdateSynchronous(@Nonnull T request) {
        this.doPostUpdate(request, true);
    }

    @Nonnull
    @Transactional(propagation=Propagation.SUPPORTS)
    @Unsecured(value="Free for plugins to call and not exposed otherwise")
    public <T extends RepositoryHookRequest> RepositoryHookResult preUpdate(@Nonnull T request) {
        InternalRepository repository = InternalConverter.convertToInternalRepository((Repository)request.getRepository());
        HookRequestState invocationState = this.hookStateManager.getState(request);
        if (!invocationState.setPreUpdateCalled()) {
            log.debug("[{}] Skipping preUpdate hook invocation. Hooks have already been called.", (Object)repository);
            return invocationState.getResult().orElse(RepositoryHookResult.accepted());
        }
        Class requestClass = request.getClass();
        List<RepositoryHookModuleDescriptor> descriptors = this.getEnabledDescriptors().filter(descriptor -> descriptor.isPreHookFor(requestClass)).sorted().collect(Collectors.toList());
        Map<String, InternalRepositoryHook> configByKey = this.getHooksForDescriptors(repository, descriptors);
        return (RepositoryHookResult)this.noTx.execute(status -> {
            LinkedHashMap<String, PreRepositoryHook> activeHooksByKey = new LinkedHashMap<String, PreRepositoryHook>();
            HashMap<String, SimplePreRepositoryHookContext> contextsByKey = new HashMap<String, SimplePreRepositoryHookContext>();
            HookCallbackRegistrar callbackRegistrar = new HookCallbackRegistrar();
            RepositoryHookResult.Builder resultBuilder = new RepositoryHookResult.Builder();
            boolean abortOnFirstVeto = request.getTrigger().isAbortOnFirstVeto();
            for (RepositoryHookModuleDescriptor descriptor : descriptors) {
                String moduleKey = descriptor.getCompleteKey();
                InternalRepositoryHook config = (InternalRepositoryHook)configByKey.get(moduleKey);
                if (descriptor.isConfigurable() && (config == null || !config.isEnabled())) {
                    log.trace("[{}] Skipping pre hook {} because it is disabled", (Object)repository, (Object)moduleKey);
                    continue;
                }
                PreRepositoryHook hook2 = descriptor.asPreHookFor(requestClass);
                activeHooksByKey.put(moduleKey, hook2);
                SimplePreRepositoryHookContext context = new SimplePreRepositoryHookContext(moduleKey, this.getSettings((InternalRepositoryHook)configByKey.get(moduleKey)), callbackRegistrar);
                contextsByKey.put(moduleKey, context);
                RepositoryHookResult result = this.preUpdate(moduleKey, hook2, context, request);
                resultBuilder.add(result);
                if (!result.isRejected()) continue;
                callbackRegistrar.setCanRegister(false);
                if (!request.isDryRun()) {
                    log.info("[{}] hook '{}' vetoed the {} request", new Object[]{repository, descriptor.getKey(), request.getTrigger().getId()});
                }
                if (!abortOnFirstVeto) continue;
                break;
            }
            callbackRegistrar.setCanRegister(false);
            if (resultBuilder.build().isAccepted()) {
                resultBuilder.add(this.callbackInvoker.invokePreCallbacks(request, callbackRegistrar.getRegistrations()));
            }
            RepositoryHookResult result = resultBuilder.build();
            invocationState.setResult(result);
            activeHooksByKey.forEach((key, hook) -> this.notifyDone((PreRepositoryHookContext)contextsByKey.get(key), (PreRepositoryHook)hook, request, result));
            if (result.isRejected() || request.isDryRun()) {
                invocationState.callCleanupCallbacks();
            }
            return result;
        });
    }

    @Nonnull
    @Secured(value="Permission check performed internally")
    public Page<RepositoryHook> search(@Nonnull RepositoryHookSearchRequest request, @Nonnull PageRequest pageRequest) {
        Objects.requireNonNull(request, "request");
        Objects.requireNonNull(pageRequest, "pageRequest");
        this.validateAdminPermission(request.getScope());
        List hookDetails = (List)request.getType().map(this::getOrderedByType).orElseGet(this::getAllOrdered).collect(MoreCollectors.toImmutableList());
        return this.getRepositoryHookPage(request.getScope(), pageRequest, hookDetails);
    }

    @Nonnull
    @Secured(value="Permission check performed internally")
    @Transactional
    public Settings setSettings(@Nonnull SetRepositoryHookSettingsRequest request) throws FormValidationException {
        Objects.requireNonNull(request, "request");
        Scope scope = request.getScope();
        String hookKey = request.getHookKey();
        Settings settings = request.getSettings();
        this.validateAdminPermission(scope);
        this.validateScopeSupported(scope, this.getHookDetailsOrFail(hookKey));
        this.validateSettings(request.getHookKey(), request.getScope(), request.getSettings());
        this.validateHookIsNotRestricted(scope, hookKey, "bitbucket.service.repository.hook.update.restricted");
        InternalRepositoryHook repositoryHook = this.hookDao.findByKey(scope, hookKey);
        if (repositoryHook == null) {
            this.createHook(hookKey, scope, false, settings);
        } else {
            this.updateHook(repositoryHook, scope, repositoryHook.isEnabled(), settings);
        }
        return settings;
    }

    private static Project getProject(Scope scope) {
        return (Project)scope.accept((ScopeVisitor)new ScopeVisitor<Project>(){

            public Project visit(@Nonnull ProjectScope scope) {
                return scope.getProject();
            }

            public Project visit(@Nonnull RepositoryScope scope) {
                return scope.getProject();
            }
        });
    }

    private static Predicate<RepositoryHookModuleDescriptor> isModuleOfType(RepositoryHookType type) {
        return descriptor -> type.equals((Object)descriptor.getType());
    }

    private void createHook(String hookKey, Scope scope, boolean enabled, Settings settings) {
        InternalRepositoryHook.Builder hookBuilder = new InternalRepositoryHook.Builder().hookKey(hookKey).scope(scope).enabled(enabled);
        if (settings != null) {
            hookBuilder.settings(this.settingsHelper.serialize(settings));
        }
        this.hookDao.create((Object)hookBuilder.build());
        if (enabled) {
            this.eventPublisher.publish((Object)new RepositoryHookEnabledEvent((Object)this, scope, hookKey));
        } else {
            this.eventPublisher.publish((Object)new RepositoryHookDisabledEvent((Object)this, scope, hookKey));
        }
        if (settings != null) {
            this.eventPublisher.publish((Object)new RepositoryHookSettingsChangedEvent((Object)this, scope, hookKey, settings, EmptyHookSettings.INSTANCE));
        }
    }

    private <T extends RepositoryHookRequest> void doPostUpdate(T request, boolean synchronous) {
        InternalRepository repository = InternalConverter.convertToInternalRepository((Repository)request.getRepository());
        HookRequestState invocationState = this.hookStateManager.getState(request);
        boolean syncHooksHaveBeenCalled = invocationState.isPostUpdateSynchronousCalled();
        if (synchronous && !invocationState.setPostUpdateSynchronousCalled()) {
            log.debug("[{}] Skipping synchronous postUpdate hook invocation. Hooks have already been called.", (Object)repository);
            return;
        }
        if (!synchronous) {
            if (!invocationState.setPostUpdateCalled()) {
                log.debug("[{}] Skipping postUpdate hook invocation. Hooks have already been called.", (Object)repository);
                return;
            }
            invocationState.setPostUpdateSynchronousCalled();
        }
        Class requestClass = request.getClass();
        List<RepositoryHookModuleDescriptor> descriptors = this.getEnabledDescriptors().filter(descriptor -> descriptor.isPostHookFor(requestClass)).sorted().collect(Collectors.toList());
        Map<String, InternalRepositoryHook> configByKey = this.getHooksForDescriptors(repository, descriptors);
        this.noTx.execute(status -> {
            HookCallbackRegistrar callbackRegistrar = new HookCallbackRegistrar();
            for (RepositoryHookModuleDescriptor descriptor : descriptors) {
                String moduleKey = descriptor.getCompleteKey();
                InternalRepositoryHook config = (InternalRepositoryHook)configByKey.get(moduleKey);
                if (descriptor.isConfigurable() && (config == null || !config.isEnabled())) {
                    log.trace("[{}] Skipping post hook {} because it is disabled", (Object)repository, (Object)moduleKey);
                    continue;
                }
                PostRepositoryHook hook = descriptor.asPostHookFor(requestClass);
                if (!this.shouldInvokeHook(hook, synchronous, syncHooksHaveBeenCalled)) continue;
                SimplePostRepositoryHookContext context = new SimplePostRepositoryHookContext(moduleKey, this.getSettings(config), callbackRegistrar, synchronous);
                this.postUpdate(hook, context, request);
            }
            this.callbackInvoker.invokePostCallbacks(request, callbackRegistrar.getRegistrations());
            if (!synchronous) {
                invocationState.callCleanupCallbacks();
            }
            return null;
        });
    }

    private Stream<SimpleRepositoryHookDetails> getAllOrdered() {
        return this.getConfigurableDescriptors().map(SimpleRepositoryHookDetails.FROM_MODULE_DESCRIPTOR).sorted(HOOK_NAME_COMPARATOR);
    }

    private void validateHookIsNotRestricted(Scope scope, final String hookKey, final String errorKey) {
        scope.accept((ScopeVisitor)new ScopeVisitor<Void>(){

            public Void visit(@Nonnull RepositoryScope scope) {
                SettingsKey hooksSettingsKey = ProjectSettingsRestrictionKeys.withComponentKey((SettingsKey)ProjectSettingsRestrictionKeys.HOOKS, (String)hookKey);
                if (DefaultRepositoryHookService.this.projectSettingsRestrictionService.get(scope.getProject(), hooksSettingsKey).isPresent()) {
                    throw new ForbiddenException(DefaultRepositoryHookService.this.i18nService.createKeyedMessage(errorKey, new Object[0]));
                }
                return null;
            }
        });
    }

    private Set<ProjectSettingsRestriction> getAllRepositoryRestrictions(Scope scope) {
        return (Set)scope.accept((ScopeVisitor)new ScopeVisitor<Set<ProjectSettingsRestriction>>(){

            public Set<ProjectSettingsRestriction> visit(ProjectScope scope) {
                return Collections.emptySet();
            }

            public Set<ProjectSettingsRestriction> visit(RepositoryScope scope) {
                return DefaultRepositoryHookService.this.projectSettingsRestrictionService.getAllUnsecured(scope.getProject(), ProjectSettingsRestrictionKeys.HOOKS.getNamespace(), ProjectSettingsRestrictionKeys.HOOKS.getFeatureKey());
            }
        });
    }

    private Stream<SimpleRepositoryHookDetails> getByType(RepositoryHookType type) {
        return this.getConfigurableDescriptors().filter(DefaultRepositoryHookService.isModuleOfType(type)).map(SimpleRepositoryHookDetails.FROM_MODULE_DESCRIPTOR);
    }

    private CacheableAvatarSupplier getCacheableSupplier(Resource resource) throws IOException {
        return new DelegatingCacheableAvatarSupplier((AvatarSupplier)new SimpleAvatarSupplier(this.fileNameMap.getContentTypeFor(resource.getFilename()), resource.getInputStream()), resource.lastModified());
    }

    private Stream<RepositoryHookModuleDescriptor> getConfigurableDescriptors() {
        return this.getEnabledDescriptors().filter(RepositoryHookModuleDescriptor::isConfigurable);
    }

    private CacheableAvatarSupplier getDefaultAvatar(RepositoryHookType type) {
        try {
            switch (type) {
                case PRE_PULL_REQUEST_MERGE: {
                    return this.getCacheableSupplier((Resource)new UrlResource(this.getClass().getResource(MERGE_CHECK_DEFAULT_ICON)));
                }
            }
            return this.getCacheableSupplier((Resource)new UrlResource(this.getClass().getResource(HOOK_DEFAULT_ICON)));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private InternalRepositoryHook getEffectiveRepositoryHook(Scope scope, final String hookKey) {
        Optional restriction = this.projectSettingsRestrictionService.get(DefaultRepositoryHookService.getProject(scope), ProjectSettingsRestrictionKeys.withComponentKey((SettingsKey)ProjectSettingsRestrictionKeys.HOOKS, (String)hookKey));
        InternalRepositoryHook hook = this.hookDao.findByKey(scope, hookKey);
        if (hook == null || restriction.isPresent() && scope.getType() == ScopeType.REPOSITORY) {
            return (InternalRepositoryHook)scope.accept((ScopeVisitor)new ScopeVisitor<InternalRepositoryHook>(){

                public InternalRepositoryHook visit(@Nonnull RepositoryScope repositoryScope) {
                    return DefaultRepositoryHookService.this.hookDao.findByKey((Scope)Scopes.project((Project)repositoryScope.getProject()), hookKey);
                }
            });
        }
        return hook;
    }

    private Stream<RepositoryHookModuleDescriptor> getEnabledDescriptors() {
        return this.pluginAccessor.getEnabledModuleDescriptorsByClass(RepositoryHookModuleDescriptor.class).stream();
    }

    private Scope getHighestConfigurableScope(Scope scope, final SimpleRepositoryHookDetails hookDetails) {
        return (Scope)scope.accept((ScopeVisitor)new ScopeVisitor<Scope>(){

            public Scope visit(@Nonnull ProjectScope projectScope) {
                return projectScope;
            }

            public Scope visit(final @Nonnull RepositoryScope repositoryScope) {
                if (hookDetails.getSupportedScopes().contains(ScopeType.PROJECT)) {
                    return (Scope)repositoryScope.getProject().accept((ProjectVisitor)new ProjectVisitor<Scope>(){

                        public Scope visit(@Nonnull Project project) {
                            return Scopes.project((Project)project);
                        }

                        public Scope visit(@Nonnull PersonalProject project) {
                            return repositoryScope;
                        }
                    });
                }
                return repositoryScope;
            }
        });
    }

    private SimpleRepositoryHookDetails getHookDetailsOrFail(String hookKey) {
        return SimpleRepositoryHookDetails.FROM_MODULE_DESCRIPTOR.apply(this.getModuleDescriptorOrFail(hookKey));
    }

    private Set<String> getHookKeys(List<SimpleRepositoryHookDetails> hookDetails) {
        return Maps.uniqueIndex(hookDetails, RepositoryHookDetails::getKey).keySet();
    }

    private Map<String, InternalRepositoryHook> getHooksForDescriptors(InternalRepository repository, List<RepositoryHookModuleDescriptor> descriptors) {
        return (Map)this.readOnlyTx.execute(status -> this.getHooksForScope((Scope)Scopes.repository((Repository)repository), this.getModuleKeys(descriptors), true));
    }

    private Map<String, InternalRepositoryHook> getHooksForScope(Scope scope, Set<String> hookKeys, boolean withSettings) {
        List relevantScopes = (List)scope.accept((ScopeVisitor)new ScopeVisitor<List<Scope>>(){

            public List<Scope> visit(@Nonnull GlobalScope scope) {
                throw new UnsupportedOperationException(DefaultRepositoryHookService.this.i18nService.getMessage("bitbucket.service.repository.hook.invalidglobalscope", new Object[0]));
            }

            public List<Scope> visit(@Nonnull ProjectScope scope) {
                return ImmutableList.of((Object)scope);
            }

            public List<Scope> visit(@Nonnull RepositoryScope scope) {
                return ImmutableList.of((Object)scope, (Object)Scopes.project((Project)scope.getProject()));
            }
        });
        Set<ProjectSettingsRestriction> restrictions = this.getAllRepositoryRestrictions(scope);
        List retrievedHooks = this.hookDao.findByKeys((Collection)relevantScopes, hookKeys, withSettings);
        return retrievedHooks.stream().filter(hook -> hook.getScope().getType() == ScopeType.PROJECT || restrictions.stream().noneMatch(restriction -> restriction.getSettingsKey().getComponentKey().map(componentKey -> componentKey.equals(hook.getHookKey())).orElse(false))).collect(Collectors.toMap(InternalRepositoryHook::getHookKey, Function.identity(), (hook1, hook2) -> hook1.getScope().getType().equals((Object)ScopeType.REPOSITORY) ? hook1 : hook2));
    }

    private RepositoryHookModuleDescriptor getModuleDescriptorOrFail(String hookKey) {
        ModuleDescriptor moduleDescriptor = this.pluginAccessor.getEnabledPluginModule(hookKey);
        if (!(moduleDescriptor instanceof RepositoryHookModuleDescriptor)) {
            throw new NoSuchEntityException(this.i18nService.createKeyedMessage("bitbucket.service.repository.hook.nosuchhook", new Object[]{hookKey}));
        }
        return (RepositoryHookModuleDescriptor)moduleDescriptor;
    }

    private Set<String> getModuleKeys(List<RepositoryHookModuleDescriptor> descriptors) {
        return (Set)descriptors.stream().map(AbstractModuleDescriptor::getCompleteKey).collect(MoreCollectors.toImmutableSet());
    }

    private Stream<SimpleRepositoryHookDetails> getOrderedByType(RepositoryHookType type) {
        return this.getByType(type).sorted(HOOK_NAME_COMPARATOR);
    }

    private Page<RepositoryHook> getRepositoryHookPage(Scope scope, PageRequest pageRequest, List<SimpleRepositoryHookDetails> hookDetails) {
        if (pageRequest.getStart() > hookDetails.size() || hookDetails.isEmpty()) {
            return PageUtils.createEmptyPage((PageRequest)pageRequest);
        }
        Map<String, InternalRepositoryHook> hooksByKey = this.getHooksForScope(scope, this.getHookKeys(hookDetails), false);
        Page hookPage = PageUtils.createPage(hookDetails.subList(pageRequest.getStart(), hookDetails.size()), (PageRequest)pageRequest);
        return hookPage.transform(details -> {
            String hookKey = details.getKey();
            InternalRepositoryHook internalRepositoryHook = (InternalRepositoryHook)hooksByKey.get(hookKey);
            if (internalRepositoryHook == null) {
                return new SimpleRepositoryHook((SimpleRepositoryHookDetails)details, false, false, this.getHighestConfigurableScope(scope, (SimpleRepositoryHookDetails)details));
            }
            return new SimpleRepositoryHook((SimpleRepositoryHookDetails)details, internalRepositoryHook.isEnabled(), internalRepositoryHook.hasSettings(), internalRepositoryHook.getScope());
        });
    }

    @Nonnull
    private Settings getSettings(InternalRepositoryHook repositoryHook) {
        InternalSharedLob settings;
        InternalSharedLob internalSharedLob = settings = repositoryHook == null ? null : repositoryHook.getSettings();
        if (settings == null) {
            return EmptyHookSettings.INSTANCE;
        }
        return this.settingsHelper.deserialize(settings.getData());
    }

    private RepositoryHookResult hookFailed(String hookName, Exception e) {
        return RepositoryHookResult.rejected((String)this.i18nService.getMessage("bitbucket.service.hook.failed", new Object[]{hookName}), (String)((String)MoreObjects.firstNonNull((Object)e.getMessage(), (Object)e.getClass().getName())));
    }

    private <T extends RepositoryHookRequest> void notifyDone(PreRepositoryHookContext context, PreRepositoryHook<T> hook, T request, RepositoryHookResult result) {
        try {
            hook.onEnd(context, request, result);
        }
        catch (Exception e) {
            log.warn("[{}] Error while notifying hook '{}' that ref-changes were accepted", new Object[]{request.getRepository(), hook.getClass().getName(), e});
        }
    }

    private <T extends RepositoryHookRequest> void postUpdate(PostRepositoryHook<T> hook, PostRepositoryHookContext context, T request) {
        try (Timer ignored = TimerUtils.start((String)(hook.getClass().getName() + "#postUpdate"));){
            hook.postUpdate(context, request);
        }
        catch (Exception e) {
            log.warn("[{}] Error calling {}.postUpdate", new Object[]{request.getRepository(), hook.getClass().getSimpleName(), e});
        }
    }

    private <T extends RepositoryHookRequest> RepositoryHookResult preUpdate(String hookName, PreRepositoryHook<T> hook, PreRepositoryHookContext context, T request) {
        RepositoryHookResult repositoryHookResult;
        block8: {
            Timer ignored = TimerUtils.start((String)(hookName + "#preUpdate"));
            try {
                repositoryHookResult = Objects.requireNonNull(hook.preUpdate(context, request), hookName + ".preUpdate() returned null");
                if (ignored == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (ignored != null) {
                        try {
                            ignored.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    log.warn("[{}] Error calling {}.preUpdate ({})", new Object[]{request.getRepository(), hook.getClass().getName(), hookName, e});
                    return this.hookFailed(hookName, e);
                }
            }
            ignored.close();
        }
        return repositoryHookResult;
    }

    private boolean requiresSettings(SimpleRepositoryHookDetails hookDetails) {
        return StringUtils.isNotBlank((CharSequence)hookDetails.getConfigFormKey());
    }

    private RepositoryHook setEnabled(AbstractUpdateRepositoryHookRequest request, Settings settings, boolean enabling) {
        boolean hasSettings;
        Objects.requireNonNull(request, "request");
        String hookKey = request.getHookKey();
        Scope scope = request.getScope();
        SimpleRepositoryHookDetails hookDetails = this.getHookDetailsOrFail(hookKey);
        if (!hookDetails.isConfigurable()) {
            throw new IllegalEntityStateException(this.i18nService.createKeyedMessage("bitbucket.service.hook.notconfigurable", new Object[]{hookKey}));
        }
        InternalRepositoryHook hook = this.hookDao.findByKey(scope, hookKey);
        boolean bl = hasSettings = hook != null && hook.getSettings() != null || settings != null;
        if (enabling && this.requiresSettings(hookDetails) && !hasSettings) {
            throw new IllegalEntityStateException(this.i18nService.createKeyedMessage("bitbucket.service.hook.notconfigured", new Object[]{hookKey}));
        }
        if (hook == null) {
            this.createHook(hookKey, scope, enabling, settings);
        } else if (this.shouldUpdateHook(hook, settings, enabling)) {
            this.updateHook(hook, scope, enabling, settings);
        }
        return new SimpleRepositoryHook(hookDetails, enabling, hasSettings, scope);
    }

    private boolean shouldInvokeHook(PostRepositoryHook<?> hook, boolean synchronous, boolean syncHooksHaveBeenCalled) {
        if (hook == null) {
            return false;
        }
        SynchronousPreferred annotation = (SynchronousPreferred)AnnotationUtils.findAnnotation((Class)hook.getClass(), SynchronousPreferred.class);
        if (synchronous) {
            return annotation != null;
        }
        return annotation == null || !syncHooksHaveBeenCalled && annotation.asyncSupported();
    }

    private boolean shouldUpdateHook(InternalRepositoryHook hook, Settings settings, boolean enabling) {
        return hook.isEnabled() != enabling || settings != null;
    }

    private void updateHook(InternalRepositoryHook hook, Scope scope, boolean enabled, Settings settings) {
        boolean wasEnabled = hook.isEnabled();
        Settings oldSettings = this.getSettings(hook);
        InternalRepositoryHook.Builder hookBuilder = new InternalRepositoryHook.Builder(hook).enabled(enabled);
        if (settings != null) {
            hookBuilder.settings(this.settingsHelper.serialize(settings));
        }
        this.hookDao.update((Object)hookBuilder.build());
        if (wasEnabled != enabled) {
            if (enabled) {
                this.eventPublisher.publish((Object)new RepositoryHookEnabledEvent((Object)this, scope, hook.getHookKey()));
            } else {
                this.eventPublisher.publish((Object)new RepositoryHookDisabledEvent((Object)this, scope, hook.getHookKey()));
            }
        }
        if (settings != null) {
            this.eventPublisher.publish((Object)new RepositoryHookSettingsChangedEvent((Object)this, scope, hook.getHookKey(), (Settings)MoreObjects.firstNonNull((Object)settings, (Object)EmptyHookSettings.INSTANCE), oldSettings));
        }
    }

    private void validateAdminPermission(@Nonnull Scope scope) {
        scope.accept((ScopeVisitor)new ScopeVisitor<Void>(){

            public Void visit(@Nonnull GlobalScope scope) {
                throw new UnsupportedOperationException(DefaultRepositoryHookService.this.i18nService.getMessage("bitbucket.service.repository.hook.invalidglobalscope", new Object[0]));
            }

            public Void visit(final @Nonnull ProjectScope scope) {
                return (Void)scope.getProject().accept((ProjectVisitor)new ProjectVisitor<Void>(){

                    public Void visit(@Nonnull Project project) {
                        DefaultRepositoryHookService.this.permissionValidationService.validateForProject(scope.getProject(), Permission.PROJECT_ADMIN);
                        return null;
                    }

                    public Void visit(@Nonnull PersonalProject project) {
                        throw new UnsupportedOperationException(DefaultRepositoryHookService.this.i18nService.getMessage("bitbucket.service.repository.hook.invalidpersonalprojectscope", new Object[0]));
                    }
                });
            }

            public Void visit(@Nonnull RepositoryScope scope) {
                DefaultRepositoryHookService.this.permissionValidationService.validateForRepository(scope.getRepository(), Permission.REPO_ADMIN);
                return null;
            }
        });
    }

    private void validateScopeSupported(Scope scope, SimpleRepositoryHookDetails hookDetails) {
        if (!Iterables.contains(hookDetails.getSupportedScopes(), (Object)scope.getType())) {
            throw new IllegalEntityStateException(this.i18nService.createKeyedMessage("bitbucket.service.hook.notconfigurable.atscope", new Object[]{hookDetails.getKey(), scope.getType()}));
        }
    }

    private void validateSettings(String hookKey, Scope scope, Settings settings) throws FormValidationException {
        ModuleDescriptor pluginModule = this.pluginAccessor.getEnabledPluginModule(hookKey);
        Preconditions.checkArgument((boolean)ValidatorModuleDescriptor.class.isInstance(pluginModule), (Object)("Module '" + hookKey + "' does not implement " + ValidatorModuleDescriptor.class.getName()));
        SettingsValidator validator = ((ValidatorModuleDescriptor)pluginModule).getValidator();
        if (validator != null) {
            SimpleSettingsValidationErrors validationErrors = new SimpleSettingsValidationErrors((Errors)new SettingsErrors(settings));
            validator.validate(settings, (SettingsValidationErrors)validationErrors, scope);
            if (!validationErrors.isEmpty()) {
                throw new FormValidationException(this.i18nService.createKeyedMessage("bitbucket.repository.setting.validation.error", new Object[0]), (FormErrors)validationErrors);
            }
        }
    }

    private static class SimpleSettingsValidationErrors
    implements SettingsValidationErrors,
    FormErrors {
        private final Errors errors;

        private SimpleSettingsValidationErrors(Errors errors) {
            this.errors = errors;
        }

        public void addFieldError(@Nonnull String fieldName, @Nonnull String errorMessage) {
            this.errors.rejectValue(fieldName, errorMessage, errorMessage);
        }

        public void addFormError(@Nonnull String errorMessage) {
            this.errors.reject(errorMessage, errorMessage);
        }

        @Nonnull
        public Collection<String> getErrors(@Nonnull String field) {
            return Collections2.transform((Collection)this.errors.getFieldErrors(field), DefaultMessageSourceResolvable::getDefaultMessage);
        }

        @Nonnull
        public Map<String, Collection<String>> getFieldErrors() {
            HashMultimap errorMap = HashMultimap.create();
            for (FieldError message : this.errors.getFieldErrors()) {
                errorMap.put((Object)message.getField(), (Object)message.getDefaultMessage());
            }
            return errorMap.asMap();
        }

        @Nonnull
        public Collection<String> getFormErrors() {
            return Collections2.transform((Collection)this.errors.getGlobalErrors(), DefaultMessageSourceResolvable::getDefaultMessage);
        }

        public boolean isEmpty() {
            return !this.errors.hasErrors();
        }
    }

    private static class SettingsErrors
    extends AbstractBindingResult {
        private final Settings settings;

        SettingsErrors(Settings settings) {
            super("__OBJECT__");
            this.settings = settings;
        }

        public Object getTarget() {
            return this.settings;
        }

        protected Object getActualFieldValue(String field) {
            return this.settings.asMap().get(field);
        }
    }

    private static class HookCallbackRegistrar
    extends BuilderSupport
    implements RepositoryHookCallbackRegistrar {
        private final List<RepositoryHookCallbackRegistration> registrations = new ArrayList<RepositoryHookCallbackRegistration>();
        private boolean canRegister = true;

        HookCallbackRegistrar() {
        }

        @Override
        @Nonnull
        public List<RepositoryHookCallbackRegistration> getRegistrations() {
            return Collections.unmodifiableList(this.registrations);
        }

        @Override
        public boolean register(@Nonnull String moduleKey, @Nonnull RepositoryHookCommitCallback callback, @Nonnull RepositoryHookCommitFilter filter, RepositoryHookCommitFilter ... moreFilters) {
            if (!this.canRegister || callback == null) {
                return false;
            }
            EnumSet<RepositoryHookCommitFilter> filters = EnumSet.noneOf(RepositoryHookCommitFilter.class);
            HookCallbackRegistrar.addIf(Objects::nonNull, filters, (Object)filter, (Object[])moreFilters);
            if (filters.isEmpty()) {
                return false;
            }
            this.registrations.add(new RepositoryHookCallbackRegistration(moduleKey, callback, filters));
            return true;
        }

        void setCanRegister(boolean value) {
            this.canRegister = value;
        }
    }
}

