/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.hook.repository;

import com.atlassian.bitbucket.dmz.settingsrestriction.ProjectSettingsRestrictionKeys;
import com.atlassian.bitbucket.project.Project;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.settingsrestriction.ProjectSettingsRestrictionProcessor;
import com.atlassian.bitbucket.settingsrestriction.RestrictionProcessingRequest;
import com.atlassian.bitbucket.util.MoreCollectors;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.stash.internal.hook.event.RepositoryHookBulkDeletedEvent;
import com.atlassian.stash.internal.repository.RepositoryHookDao;
import com.atlassian.util.profiling.Ticker;
import com.atlassian.util.profiling.Timers;
import jakarta.annotation.Nonnull;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component(value="hooksRestrictionProcessor")
public class HooksRestrictionProcessor
implements ProjectSettingsRestrictionProcessor {
    private static final Logger log = LoggerFactory.getLogger(HooksRestrictionProcessor.class);
    private final EventPublisher eventPublisher;
    private final RepositoryHookDao repositoryHookDao;

    @Autowired
    public HooksRestrictionProcessor(EventPublisher eventPublisher, RepositoryHookDao repositoryHookDao) {
        this.eventPublisher = eventPublisher;
        this.repositoryHookDao = repositoryHookDao;
    }

    public String getFeatureKey() {
        return ProjectSettingsRestrictionKeys.HOOKS.getFeatureKey();
    }

    public String getNamespace() {
        return ProjectSettingsRestrictionKeys.HOOKS.getNamespace();
    }

    @Transactional
    public boolean process(@Nonnull RestrictionProcessingRequest processingRequest) {
        log.trace("Deleting repository hook configurations for request {}", (Object)processingRequest);
        if (processingRequest.getRepositories().isEmpty()) {
            log.trace("No repos to process {}", (Object)processingRequest);
            return true;
        }
        Project project = ((Repository)processingRequest.getRepositories().iterator().next()).getProject();
        Set repositoryIds = (Set)processingRequest.getRepositories().stream().map(Repository::getId).collect(MoreCollectors.toImmutableSet());
        try (Ticker ignored = Timers.timer((String)String.format("HooksRestrictionProcessor: Processing restrictions for %s repositories", repositoryIds.size())).start(new Object[]{project.getId()});){
            processingRequest.getSettingsKey().getComponentKey().ifPresent(componentKey -> {
                this.repositoryHookDao.deleteByKeyAndRepositoryIds(componentKey, repositoryIds);
                this.eventPublisher.publish((Object)new RepositoryHookBulkDeletedEvent(this, project, repositoryIds.size()));
            });
        }
        return true;
    }
}

