/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.hook.repository;

import com.atlassian.bitbucket.hook.repository.RepositoryHookCommitCallback;
import com.atlassian.bitbucket.hook.repository.RepositoryHookCommitFilter;
import jakarta.annotation.Nonnull;
import java.util.EnumSet;
import java.util.Objects;

class RepositoryHookCallbackRegistration {
    private final RepositoryHookCommitCallback callback;
    private final EnumSet<RepositoryHookCommitFilter> filters;
    private final String moduleKey;

    RepositoryHookCallbackRegistration(String moduleKey, RepositoryHookCommitCallback callback, EnumSet<RepositoryHookCommitFilter> filters) {
        this.callback = Objects.requireNonNull(callback, "callback");
        this.filters = Objects.requireNonNull(filters, "types");
        this.moduleKey = Objects.requireNonNull(moduleKey, "moduleKey");
    }

    @Nonnull
    public RepositoryHookCommitCallback getCallback() {
        return this.callback;
    }

    @Nonnull
    public EnumSet<RepositoryHookCommitFilter> getFilters() {
        return this.filters;
    }

    @Nonnull
    public String getModuleKey() {
        return this.moduleKey;
    }

    public boolean matches(@Nonnull RepositoryHookCommitFilter filter) {
        if (this.filters.contains(filter)) {
            return true;
        }
        if (filter == RepositoryHookCommitFilter.ADDED_TO_REPOSITORY) {
            return this.filters.contains(RepositoryHookCommitFilter.ADDED_TO_ANY_REF);
        }
        return filter == RepositoryHookCommitFilter.REMOVED_FROM_REPOSITORY && this.filters.contains(RepositoryHookCommitFilter.REMOVED_FROM_ANY_REF);
    }
}

