/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.hook.repository;

import com.atlassian.plugin.ModuleDescriptor;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.stash.internal.plugin.RepositoryHookModuleDescriptor;
import com.atlassian.troubleshooting.spi.RootLevelSupportDataAppender;
import com.atlassian.troubleshooting.spi.SupportDataBuilder;
import java.util.function.Predicate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="repositoryHookModuleSupportData")
public class RepositoryHookModuleSupportData
extends RootLevelSupportDataAppender {
    private static final String HOOK_MODULE = "bitbucket.atst.repository.hooks.module";
    private static final String HOOK_MODULES = "bitbucket.atst.repository.hooks.modules";
    private static final String HOOK_KEY = "bitbucket.atst.repository.hooks.module.key";
    private static final String HOOK_DESCRIPTION = "bitbucket.atst.repository.hooks.module.description";
    private static final String HOOK_CLASS = "bitbucket.atst.repository.hooks.module.class";
    private static final String HOOK_SOURCE = "bitbucket.atst.repository.hooks.module.plugin.key";
    private final PluginAccessor pluginAccessor;

    @Autowired
    public RepositoryHookModuleSupportData(PluginAccessor pluginAccessor) {
        this.pluginAccessor = pluginAccessor;
    }

    protected void addSupportData(SupportDataBuilder supportDataBuilder) {
        this.addCommitHookPluginInformation(supportDataBuilder.addCategory(HOOK_MODULES));
    }

    private void addCommitHookPluginInformation(SupportDataBuilder builder) {
        Predicate<ModuleDescriptor> predicate = RepositoryHookModuleDescriptor.class::isInstance;
        for (ModuleDescriptor descriptor : this.pluginAccessor.getModuleDescriptors(predicate)) {
            SupportDataBuilder hookBuilder = builder.addCategory(HOOK_MODULE);
            hookBuilder.addValue(HOOK_KEY, descriptor.getCompleteKey());
            hookBuilder.addValue(HOOK_DESCRIPTION, descriptor.getDescription());
            if (descriptor.getModuleClass() != null) {
                hookBuilder.addValue(HOOK_CLASS, descriptor.getModuleClass().getName());
            }
            hookBuilder.addValue(HOOK_SOURCE, descriptor.getPlugin().getKey());
            hookBuilder.addContext((Object)descriptor);
        }
    }
}

