/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.hook.repository;

import com.atlassian.bitbucket.hook.repository.RepositoryHook;
import com.atlassian.bitbucket.hook.repository.RepositoryHookSearchRequest;
import com.atlassian.bitbucket.hook.repository.RepositoryHookService;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.scope.Scope;
import com.atlassian.bitbucket.scope.Scopes;
import com.atlassian.bitbucket.util.PageUtils;
import com.atlassian.troubleshooting.spi.SupportDataAppender;
import com.atlassian.troubleshooting.spi.SupportDataBuilder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="repositoryHookSupportData")
public class RepositoryHookSupportData
implements SupportDataAppender<Repository> {
    private static final String REPOSITORY_HOOK = "bitbucket.atst.repository.hook";
    private static final String REPOSITORY_HOOKS = "bitbucket.atst.repository.hooks";
    private static final String REPOSITORY_HOOK_KEY = "bitbucket.atst.repository.hook.key";
    private static final String REPOSITORY_HOOK_CONFIG = "bitbucket.atst.repository.hook.config";
    private final RepositoryHookService repositoryHookService;

    @Autowired
    public RepositoryHookSupportData(RepositoryHookService repositoryHookService) {
        this.repositoryHookService = repositoryHookService;
    }

    public void addSupportData(SupportDataBuilder supportDataBuilder, Repository repository) {
        SupportDataBuilder hooksBuilder = supportDataBuilder.addCategory(REPOSITORY_HOOKS);
        RepositoryHookSearchRequest request = new RepositoryHookSearchRequest.Builder((Scope)Scopes.repository((Repository)repository)).build();
        PageUtils.toStream(pageRequest -> this.repositoryHookService.search(request, pageRequest), (int)500).filter(RepositoryHook::isEnabled).forEach(hook -> hooksBuilder.addCategory(REPOSITORY_HOOK).addValue(REPOSITORY_HOOK_KEY, hook.getDetails().getKey()).addValue(REPOSITORY_HOOK_CONFIG, Boolean.toString(hook.isConfigured())).addContext(hook));
    }
}

