/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.hook.repository;

import com.atlassian.bitbucket.hook.repository.CommitAddedDetails;
import com.atlassian.bitbucket.hook.repository.CommitRemovedDetails;
import com.atlassian.bitbucket.hook.repository.PreRepositoryHookCommitCallback;
import com.atlassian.bitbucket.hook.repository.RepositoryHookCommitCallback;
import com.atlassian.bitbucket.hook.repository.RepositoryHookCommitFilter;
import com.atlassian.bitbucket.hook.repository.RepositoryHookRequest;
import com.atlassian.bitbucket.hook.repository.RepositoryHookResult;
import com.atlassian.bitbucket.hook.repository.RepositoryHookTrigger;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.util.Timer;
import com.atlassian.bitbucket.util.TimerUtils;
import com.atlassian.stash.internal.hook.repository.RepositoryHookCallbackRegistration;
import jakarta.annotation.Nonnull;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;
import org.slf4j.Logger;

class SafeRepositoryHookCommitCallback {
    private final boolean abortOnRejected;
    private final List<RepositoryHookCallbackRegistration> activeCallbacks;
    private final I18nService i18nService;
    private final Logger log;
    private final boolean preHook;
    private final Repository repository;
    private final RepositoryHookResult.Builder resultBuilder;
    private final RepositoryHookTrigger trigger;

    SafeRepositoryHookCommitCallback(RepositoryHookRequest request, boolean preHook, Logger log, I18nService i18nService, List<RepositoryHookCallbackRegistration> registrations, boolean abortOnRejected) {
        this.abortOnRejected = abortOnRejected;
        this.activeCallbacks = new ArrayList<RepositoryHookCallbackRegistration>(registrations.size());
        this.i18nService = i18nService;
        this.log = log;
        this.preHook = preHook;
        this.repository = request.getRepository();
        this.resultBuilder = new RepositoryHookResult.Builder();
        this.trigger = request.getTrigger();
        registrations.forEach(registration -> {
            if (!registration.getFilters().isEmpty()) {
                this.activeCallbacks.add((RepositoryHookCallbackRegistration)registration);
            }
        });
    }

    @Nonnull
    RepositoryHookResult getResult() {
        return this.resultBuilder.build();
    }

    boolean isDone() {
        return this.activeCallbacks.isEmpty() || this.abortOnRejected && this.resultBuilder.isRejected();
    }

    boolean matches(RepositoryHookCommitFilter filter) {
        return (!this.abortOnRejected || !this.resultBuilder.isRejected()) && this.activeCallbacks.stream().anyMatch(registration -> registration.matches(filter));
    }

    void onCommitAdded(@Nonnull CommitAddedDetails details) {
        this.invokeSafely("onCommitAdded", this.getFilter(details), callback -> callback.onCommitAdded(details));
    }

    void onCommitRemoved(@Nonnull CommitRemovedDetails details) {
        this.invokeSafely("onCommitRemoved", this.getFilter(details), callback -> callback.onCommitRemoved(details));
    }

    void onEnd() {
        this.activeCallbacks.forEach(this::wrapUp);
    }

    void onStart() {
        this.invokeSafely("onStart", null, callback -> {
            callback.onStart();
            return null;
        });
    }

    private void addFailureResult(String moduleKey, Throwable t) {
        if (this.preHook) {
            this.resultBuilder.add(RepositoryHookResult.rejected((String)this.i18nService.getMessage("bitbucket.service.hook.failed", new Object[]{moduleKey}), (String)t.getMessage()));
        }
    }

    private RepositoryHookCommitFilter getFilter(CommitAddedDetails details) {
        return details.isAddedToRepository() ? RepositoryHookCommitFilter.ADDED_TO_REPOSITORY : RepositoryHookCommitFilter.ADDED_TO_ANY_REF;
    }

    private RepositoryHookCommitFilter getFilter(CommitRemovedDetails details) {
        return details.isRemovedFromRepository() ? RepositoryHookCommitFilter.REMOVED_FROM_REPOSITORY : RepositoryHookCommitFilter.REMOVED_FROM_ANY_REF;
    }

    private void invokeSafely(String methodName, RepositoryHookCommitFilter filter, Function<RepositoryHookCommitCallback, Boolean> callbackAction) {
        Iterator<RepositoryHookCallbackRegistration> it = this.activeCallbacks.iterator();
        while (it.hasNext()) {
            RepositoryHookCallbackRegistration registration = it.next();
            if (filter != null && !registration.matches(filter)) continue;
            try {
                Boolean result;
                try (Timer ignored = TimerUtils.start((String)(registration.getModuleKey() + "#" + methodName));){
                    result = callbackAction.apply(registration.getCallback());
                }
                if (result != Boolean.FALSE) continue;
                it.remove();
                this.wrapUp(registration);
            }
            catch (Throwable t) {
                it.remove();
                String moduleKey = registration.getModuleKey();
                this.warnHookMethodFailed(methodName, moduleKey, t);
                this.wrapUpAfterFailure(registration);
                this.addFailureResult(moduleKey, t);
                if (t instanceof Error) {
                    throw (Error)t;
                }
                if (!this.abortOnRejected) continue;
                break;
            }
        }
    }

    private void warnHookMethodFailed(String methodName, String moduleKey, Throwable t) {
        this.log.warn("{}:{} failed: {}", new Object[]{moduleKey, methodName, t.getMessage(), this.log.isDebugEnabled() ? t : null});
    }

    private void wrapUp(RepositoryHookCallbackRegistration registration) {
        RepositoryHookCommitCallback callback = registration.getCallback();
        try {
            callback.onEnd();
            if (this.preHook) {
                RepositoryHookResult result = ((PreRepositoryHookCommitCallback)callback).getResult();
                this.log.debug("[{}] hook callback '{}' {} the {} request", new Object[]{this.repository, registration.getModuleKey(), result == null || result.isAccepted() ? "accepted" : "vetoed", this.trigger.getId()});
                this.resultBuilder.add(result);
            }
        }
        catch (Exception e) {
            String moduleKey = registration.getModuleKey();
            this.addFailureResult(moduleKey, e);
            this.warnHookMethodFailed("onEnd", moduleKey, e);
        }
    }

    private void wrapUpAfterFailure(RepositoryHookCallbackRegistration registration) {
        try {
            registration.getCallback().onEnd();
        }
        catch (Exception endException) {
            this.warnHookMethodFailed("onEnd", registration.getModuleKey(), endException);
        }
    }
}

