/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.hook.script;

import com.atlassian.bitbucket.auth.AuthenticationContext;
import com.atlassian.bitbucket.dmz.hook.script.HookScriptEnvironmentProvider;
import com.atlassian.bitbucket.hook.repository.MergeHookRequest;
import com.atlassian.bitbucket.hook.repository.PullRequestMergeHookRequest;
import com.atlassian.bitbucket.hook.repository.RepositoryHookRequest;
import com.atlassian.bitbucket.hook.script.HookScriptType;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.permission.PermissionService;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.repository.RepositoryCloneLinksRequest;
import com.atlassian.bitbucket.repository.RepositoryRef;
import com.atlassian.bitbucket.repository.RepositoryService;
import com.atlassian.bitbucket.server.ApplicationPropertiesService;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.bitbucket.user.SecurityService;
import com.atlassian.bitbucket.util.MoreCollectors;
import com.atlassian.bitbucket.util.NamedLink;
import com.google.common.collect.ImmutableMap;
import jakarta.annotation.Nonnull;
import java.net.URI;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="hookScriptEnvironmentProvider")
public class DefaultHookScriptEnvironmentProvider
implements HookScriptEnvironmentProvider {
    public static final String SUFFIX_PROJECT_KEY = "PROJECT_KEY";
    public static final String SUFFIX_REPO_CLONE_HTTP = "REPO_CLONE_HTTP";
    public static final String SUFFIX_REPO_CLONE_SSH = "REPO_CLONE_SSH";
    public static final String SUFFIX_REPO_IS_FORK = "REPO_IS_FORK";
    public static final String SUFFIX_REPO_IS_PUBLIC = "REPO_IS_PUBLIC";
    public static final String SUFFIX_REPO_SLUG = "REPO_SLUG";
    public static final String SUFFIX_USER_DISPLAY_NAME = "USER_DISPLAY_NAME";
    public static final String SUFFIX_USER_EMAIL = "USER_EMAIL";
    public static final String SUFFIX_USER_NAME = "USER_NAME";
    public static final String SUFFIX_USER_PERMISSION = "USER_PERMISSION";
    public static final String BB_BASE_URL = "BB_BASE_URL";
    public static final String BB_HOOK_IS_DRY_RUN = "BB_IS_DRY_RUN";
    public static final String BB_HOOK_TRIGGER_ID = "BB_HOOK_TRIGGER_ID";
    public static final String BB_HOOK_TYPE = "BB_HOOK_TYPE";
    public static final String BB_PROJECT_KEY = "BB_PROJECT_KEY";
    public static final String BB_REPO_CLONE_HTTP = "BB_REPO_CLONE_HTTP";
    public static final String BB_REPO_CLONE_SSH = "BB_REPO_CLONE_SSH";
    public static final String BB_REPO_IS_FORK = "BB_REPO_IS_FORK";
    public static final String BB_REPO_IS_PUBLIC = "BB_REPO_IS_PUBLIC";
    public static final String BB_REPO_SLUG = "BB_REPO_SLUG";
    public static final String BB_USER_DISPLAY_NAME = "BB_USER_DISPLAY_NAME";
    public static final String BB_USER_EMAIL = "BB_USER_EMAIL";
    public static final String BB_USER_NAME = "BB_USER_NAME";
    public static final String BB_USER_PERMISSION = "BB_USER_PERMISSION";
    public static final String BB_FROM_PROJECT_KEY = "BB_FROM_PROJECT_KEY";
    public static final String BB_FROM_HASH = "BB_FROM_HASH";
    public static final String BB_FROM_REF = "BB_FROM_REF";
    public static final String BB_FROM_REPO_CLONE_HTTP = "BB_FROM_REPO_CLONE_HTTP";
    public static final String BB_FROM_REPO_CLONE_SSH = "BB_FROM_REPO_CLONE_SSH";
    public static final String BB_FROM_REPO_IS_FORK = "BB_FROM_REPO_IS_FORK";
    public static final String BB_FROM_REPO_IS_PUBLIC = "BB_FROM_REPO_IS_PUBLIC";
    public static final String BB_FROM_REPO_SLUG = "BB_FROM_REPO_SLUG";
    public static final String BB_MERGE_HASH = "BB_MERGE_HASH";
    public static final String BB_MERGE_IS_CROSS_REPO = "BB_MERGE_IS_CROSS_REPO";
    public static final String BB_MERGE_STRATEGY_ID = "BB_MERGE_STRATEGY_ID";
    public static final String BB_TO_REF = "BB_TO_REF";
    public static final String BB_TO_HASH = "BB_TO_HASH";
    public static final String BB_PULL_REQUEST_AUTHOR_USER_NAME = "BB_PULL_REQUEST_AUTHOR_USER_NAME";
    public static final String BB_PULL_REQUEST_AUTHOR_USER_DISPLAY_NAME = "BB_PULL_REQUEST_AUTHOR_USER_DISPLAY_NAME";
    public static final String BB_PULL_REQUEST_AUTHOR_USER_EMAIL = "BB_PULL_REQUEST_AUTHOR_USER_EMAIL";
    public static final String BB_PULL_REQUEST_AUTHOR_USER_PERMISSION = "BB_PULL_REQUEST_AUTHOR_USER_PERMISSION";
    public static final String BB_PULL_REQUEST_ID = "BB_PULL_REQUEST_ID";
    private final ApplicationPropertiesService applicationPropertiesService;
    private final AuthenticationContext authenticationContext;
    private final PermissionService permissionService;
    private final RepositoryService repositoryService;
    private final SecurityService securityService;

    @Autowired
    public DefaultHookScriptEnvironmentProvider(ApplicationPropertiesService applicationPropertiesService, AuthenticationContext authenticationContext, PermissionService permissionService, RepositoryService repositoryService, SecurityService securityService) {
        this.applicationPropertiesService = applicationPropertiesService;
        this.authenticationContext = authenticationContext;
        this.permissionService = permissionService;
        this.repositoryService = repositoryService;
        this.securityService = securityService;
    }

    @Nonnull
    public Map<String, String> create(@Nonnull RepositoryHookRequest request, @Nonnull HookScriptType type) {
        Repository repository = request.getRepository();
        URI baseUrl = this.applicationPropertiesService.getBaseUrl();
        ImmutableMap.Builder envMap = ImmutableMap.builder().put((Object)BB_BASE_URL, (Object)(baseUrl == null ? "" : baseUrl.toASCIIString())).put((Object)BB_HOOK_TRIGGER_ID, (Object)request.getTrigger().getId()).put((Object)BB_HOOK_TYPE, (Object)type.name()).put((Object)BB_HOOK_IS_DRY_RUN, (Object)Boolean.toString(request.isDryRun()));
        envMap.putAll(this.repoDetails("BB_", repository));
        ApplicationUser currentUser = this.authenticationContext.getCurrentUser();
        if (currentUser != null) {
            envMap.putAll(this.userDetails("BB_", currentUser, repository));
        }
        if (request instanceof MergeHookRequest) {
            envMap.putAll(this.mergeVariables((MergeHookRequest)request));
        }
        if (request instanceof PullRequestMergeHookRequest) {
            envMap.putAll(this.pullRequestVariables((PullRequestMergeHookRequest)request));
        }
        return envMap.build();
    }

    private String calculateUserPermission(ApplicationUser user, Repository repository) {
        Permission maxPermission = null;
        if (this.permissionService.hasGlobalPermission(user, Permission.SYS_ADMIN)) {
            maxPermission = Permission.SYS_ADMIN;
        } else if (this.permissionService.hasGlobalPermission(user, Permission.ADMIN)) {
            maxPermission = Permission.ADMIN;
        } else if (this.permissionService.hasRepositoryPermission(user, repository, Permission.REPO_ADMIN)) {
            maxPermission = Permission.REPO_ADMIN;
        } else if (this.permissionService.hasRepositoryPermission(user, repository, Permission.REPO_WRITE)) {
            maxPermission = Permission.REPO_WRITE;
        } else if (this.permissionService.hasRepositoryPermission(user, repository, Permission.REPO_READ)) {
            maxPermission = Permission.REPO_READ;
        }
        return maxPermission == null ? "" : maxPermission.name();
    }

    private Map<String, String> cloneUrls(String prefix, Repository repository) {
        RepositoryCloneLinksRequest request = new RepositoryCloneLinksRequest.Builder().repository(repository).build();
        return (Map)((Set)this.securityService.withPermission(Permission.REPO_READ, (Object)repository, "Get clone URLs for hook script").call(() -> this.repositoryService.getCloneLinks(request))).stream().filter(link -> link.getName() != null).collect(MoreCollectors.toImmutableMap(link -> prefix + "REPO_CLONE_" + link.getName().toUpperCase(Locale.ROOT), NamedLink::getHref));
    }

    private Map<String, String> mergeVariables(MergeHookRequest request) {
        RepositoryRef fromRef = request.getFromRef();
        RepositoryRef toRef = request.getToRef();
        return ImmutableMap.builder().putAll(this.repoDetails("BB_FROM_", fromRef.getRepository())).put((Object)BB_FROM_HASH, (Object)fromRef.getLatestCommit()).put((Object)BB_FROM_REF, (Object)fromRef.getDisplayId()).put((Object)BB_TO_HASH, (Object)toRef.getLatestCommit()).put((Object)BB_TO_REF, (Object)toRef.getDisplayId()).put((Object)BB_MERGE_HASH, (Object)request.getMergeHash().orElse("")).put((Object)BB_MERGE_IS_CROSS_REPO, (Object)Boolean.toString(!fromRef.getRepository().equals((Object)toRef.getRepository()))).put((Object)BB_MERGE_STRATEGY_ID, (Object)request.getStrategyId().orElse("")).build();
    }

    private Map<String, String> pullRequestVariables(PullRequestMergeHookRequest request) {
        return ImmutableMap.builder().put((Object)BB_PULL_REQUEST_ID, (Object)Long.toString(request.getPullRequest().getId())).putAll(this.userDetails("BB_PULL_REQUEST_AUTHOR_", request.getPullRequest().getAuthor().getUser(), request.getToRef().getRepository())).build();
    }

    private Map<String, String> repoDetails(String prefix, Repository repository) {
        return ImmutableMap.builder().put((Object)(prefix + SUFFIX_PROJECT_KEY), (Object)repository.getProject().getKey()).put((Object)(prefix + SUFFIX_REPO_SLUG), (Object)repository.getSlug()).put((Object)(prefix + SUFFIX_REPO_IS_FORK), (Object)Boolean.toString(repository.isFork())).put((Object)(prefix + SUFFIX_REPO_IS_PUBLIC), (Object)Boolean.toString(repository.isPublic())).putAll(this.cloneUrls(prefix, repository)).build();
    }

    private Map<String, String> userDetails(String prefix, ApplicationUser user, Repository repository) {
        return ImmutableMap.builder().put((Object)(prefix + SUFFIX_USER_DISPLAY_NAME), (Object)user.getDisplayName()).put((Object)(prefix + SUFFIX_USER_EMAIL), (Object)StringUtils.defaultString((String)user.getEmailAddress())).put((Object)(prefix + SUFFIX_USER_PERMISSION), (Object)this.calculateUserPermission(user, repository)).put((Object)(prefix + SUFFIX_USER_NAME), (Object)user.getName()).build();
    }
}

