/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.hook.script;

import com.atlassian.bitbucket.hook.repository.RepositoryHookRequest;
import com.atlassian.bitbucket.hook.repository.RepositoryHookResult;
import com.atlassian.bitbucket.hook.script.HookScriptType;
import com.atlassian.bitbucket.hook.script.MinimalHookScript;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.internal.mesh.RpcHookScriptClient;
import com.atlassian.diagnostics.AlertRequest;
import com.atlassian.diagnostics.AlertTrigger;
import com.atlassian.diagnostics.ComponentMonitor;
import com.atlassian.diagnostics.Issue;
import com.atlassian.diagnostics.MonitoringService;
import com.atlassian.diagnostics.Severity;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.stash.internal.hook.script.HookScriptInvoker;
import com.atlassian.stash.internal.hook.script.HookScriptRunner;
import com.atlassian.stash.internal.hook.script.HookScriptRunnerFactory;
import com.atlassian.stash.internal.hook.script.HookScriptStore;
import com.atlassian.stash.internal.hook.script.HookScriptSummary;
import com.atlassian.stash.internal.hook.script.InternalHookScriptService;
import com.atlassian.util.profiling.Metrics;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import jakarta.annotation.Nonnull;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Component;

@Component(value="hookScriptInvoker")
@ConditionalOnMissingBean(value={RpcHookScriptClient.class})
public class DefaultHookScriptInvoker
implements HookScriptInvoker {
    private static final Logger log = LoggerFactory.getLogger(DefaultHookScriptInvoker.class);
    private final I18nService i18nService;
    private final ComponentMonitor monitor;
    private final PluginAccessor pluginAccessor;
    private final HookScriptRunnerFactory runnerFactory;
    private final InternalHookScriptService scriptService;
    private final HookScriptStore scriptStore;
    private final Issue slowIssue;
    private final Issue timedOutIssue;
    private long slowWarning;
    private long timeout;

    @Autowired
    public DefaultHookScriptInvoker(I18nService i18nService, MonitoringService monitoringService, PluginAccessor pluginAccessor, HookScriptRunnerFactory runnerFactory, InternalHookScriptService scriptService, HookScriptStore scriptStore) {
        this(i18nService, monitoringService, pluginAccessor, runnerFactory, scriptService, scriptStore, TimeUnit.MINUTES.toSeconds(1L), TimeUnit.MINUTES.toSeconds(2L));
    }

    @VisibleForTesting
    DefaultHookScriptInvoker(I18nService i18nService, MonitoringService monitoringService, PluginAccessor pluginAccessor, HookScriptRunnerFactory runnerFactory, InternalHookScriptService scriptService, HookScriptStore scriptStore, long slowWarning, long timeout) {
        this.i18nService = i18nService;
        this.pluginAccessor = pluginAccessor;
        this.runnerFactory = runnerFactory;
        this.scriptService = scriptService;
        this.scriptStore = scriptStore;
        this.slowWarning = TimeUnit.SECONDS.toMillis(slowWarning);
        this.timeout = TimeUnit.SECONDS.toMillis(timeout);
        this.monitor = monitoringService.createMonitor("HookScript", "bitbucket.diagnostics.hook.script.name");
        this.slowIssue = this.monitor.defineIssue(2002).severity(Severity.WARNING).summaryI18nKey("bitbucket.diagnostics.hook.script.2002.summary").descriptionI18nKey("bitbucket.diagnostics.hook.script.2002.description").build();
        this.timedOutIssue = this.monitor.defineIssue(2003).severity(Severity.WARNING).summaryI18nKey("bitbucket.diagnostics.hook.script.2003.summary").descriptionI18nKey("bitbucket.diagnostics.hook.script.2003.description").build();
    }

    @Override
    public void postUpdate(@Nonnull RepositoryHookRequest request) {
        List summaries = this.scriptService.getSummariesByHookRequest(request, HookScriptType.POST);
        if (summaries.isEmpty()) {
            return;
        }
        HookScriptRunner executor = this.runnerFactory.create(request, HookScriptType.POST);
        for (HookScriptSummary script : summaries) {
            HookScriptRunner.Result result = executor.run(this.scriptStore.getExecutable((MinimalHookScript)script), script.getName(), DefaultHookScriptInvoker.metricName(script, "execution"));
            if (result.toHookResult().isAccepted()) {
                this.maybeRaiseSlowIssue(HookScriptType.POST, request, script, result);
                Metrics.histogram((String)DefaultHookScriptInvoker.metricName(script, "success")).update(1L);
                continue;
            }
            Metrics.histogram((String)DefaultHookScriptInvoker.metricName(script, "success")).update(0L);
            if (result.isTimedOut()) {
                this.raiseTimeoutIssue(HookScriptType.POST, request, script, result);
                continue;
            }
            log.debug("{}: {} rejected the request, but post-update hook scripts can't reject changes", (Object)request.getRepository(), (Object)script);
        }
    }

    @Override
    public RepositoryHookResult preUpdate(@Nonnull RepositoryHookRequest request) {
        List summaries = this.scriptService.getSummariesByHookRequest(request, HookScriptType.PRE);
        if (summaries.isEmpty()) {
            return RepositoryHookResult.accepted();
        }
        boolean abortOnFirstVeto = request.getTrigger().isAbortOnFirstVeto();
        HookScriptRunner executor = this.runnerFactory.create(request, HookScriptType.PRE);
        RepositoryHookResult.Builder resultBuilder = new RepositoryHookResult.Builder();
        for (HookScriptSummary script : summaries) {
            HookScriptRunner.Result result = executor.run(this.scriptStore.getExecutable((MinimalHookScript)script), script.getName(), DefaultHookScriptInvoker.metricName(script, "execution"));
            RepositoryHookResult hookResult = result.toHookResult();
            resultBuilder.add(hookResult);
            if (hookResult.isAccepted()) {
                this.maybeRaiseSlowIssue(HookScriptType.PRE, request, script, result);
                Metrics.histogram((String)DefaultHookScriptInvoker.metricName(script, "success")).update(1L);
            } else {
                Metrics.histogram((String)DefaultHookScriptInvoker.metricName(script, "success")).update(0L);
                if (result.isTimedOut()) {
                    this.raiseTimeoutIssue(HookScriptType.PRE, request, script, result);
                }
            }
            if (!abortOnFirstVeto || !resultBuilder.isRejected()) continue;
            break;
        }
        return resultBuilder.build();
    }

    @Value(value="${hookscripts.timeout:120}")
    public void setTimeout(long timeout) {
        this.timeout = TimeUnit.SECONDS.toMillis(Math.max(timeout, 30L));
    }

    @Value(value="${diagnostics.issues.hookscript.slow.time.seconds:30}")
    public void setSlowWarning(long time) {
        this.slowWarning = TimeUnit.SECONDS.toMillis(Math.max(time, 10L));
    }

    private static String metricName(HookScriptSummary script, String qualifier) {
        return "hook-scripts." + script.getPluginKey().replace('.', '/') + "." + script.getName().replace('.', '_') + "." + qualifier;
    }

    private void maybeRaiseSlowIssue(HookScriptType type, RepositoryHookRequest request, HookScriptSummary script, HookScriptRunner.Result result) {
        if (result.getDuration().toMillis() > this.slowWarning) {
            this.raiseIssue(type, request, script, this.slowIssue, result);
        }
    }

    private void raiseIssue(HookScriptType type, RepositoryHookRequest request, HookScriptSummary script, Issue issue, HookScriptRunner.Result result) {
        Plugin plugin = this.pluginAccessor.getPlugin(script.getPluginKey());
        String version = "Uninstalled";
        if (plugin != null) {
            version = plugin.getPluginInformation().getVersion();
        }
        AlertTrigger trigger = new AlertTrigger.Builder().plugin(script.getPluginKey(), version).module(this.i18nService.getMessage("bitbucket.diagnostics.hook.script.plugin.module", new Object[]{script.getName()})).build();
        this.monitor.alert(new AlertRequest.Builder(issue).trigger(trigger).details(() -> ImmutableMap.builder().put((Object)this.i18nService.getMessage("bitbucket.diagnostics.hook.script.details.duration", new Object[0]), (Object)Long.toString(result.getDuration().toMillis())).put((Object)this.i18nService.getMessage("bitbucket.diagnostics.hook.script.details.script", new Object[0]), (Object)script.getName()).put((Object)this.i18nService.getMessage("bitbucket.diagnostics.hook.script.details.script.id", new Object[0]), (Object)Long.toString(script.getId())).put((Object)this.i18nService.getMessage("bitbucket.diagnostics.hook.script.details.project", new Object[0]), (Object)request.getRepository().getProject().getName()).put((Object)this.i18nService.getMessage("bitbucket.diagnostics.hook.script.details.repository", new Object[0]), (Object)request.getRepository().getName()).put((Object)this.i18nService.getMessage("bitbucket.diagnostics.hook.script.details.trigger", new Object[0]), (Object)request.getTrigger().getId()).put((Object)this.i18nService.getMessage("bitbucket.diagnostics.hook.script.details.type", new Object[0]), (Object)type.name()).build()).build());
    }

    private void raiseTimeoutIssue(HookScriptType type, RepositoryHookRequest request, HookScriptSummary script, HookScriptRunner.Result result) {
        this.raiseIssue(type, request, script, this.timedOutIssue, result);
    }
}

