/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.hook.script;

import com.atlassian.bitbucket.dmz.hook.script.HookScriptEnvironmentProvider;
import com.atlassian.bitbucket.dmz.process.NioStdioHandler;
import com.atlassian.bitbucket.hook.repository.RepositoryHookRequest;
import com.atlassian.bitbucket.hook.repository.RepositoryHookResult;
import com.atlassian.bitbucket.hook.script.HookScriptType;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.internal.process.NioCommand;
import com.atlassian.bitbucket.internal.process.NioProcessHelper;
import com.atlassian.bitbucket.internal.process.NioProcessParameters;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.scm.CommandExitHandler;
import com.atlassian.bitbucket.scm.CommandTimeoutException;
import com.atlassian.stash.internal.hook.script.HookScriptCommandLineFactory;
import com.atlassian.stash.internal.hook.script.HookScriptRunner;
import com.atlassian.stash.internal.hook.script.HookScriptRunnerFactory;
import com.atlassian.stash.internal.hook.script.ScriptNioProcessHandler;
import com.atlassian.stash.internal.hook.script.ScriptProcessHandler;
import com.atlassian.stash.internal.server.InternalStorageService;
import com.atlassian.util.profiling.Ticker;
import com.atlassian.util.profiling.Timers;
import com.google.common.annotations.VisibleForTesting;
import jakarta.annotation.Nonnull;
import java.nio.file.Path;
import java.time.Duration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component(value="hookScriptExecutorFactory")
public class DefaultHookScriptRunnerFactory
implements HookScriptRunnerFactory {
    private static final Logger log = LoggerFactory.getLogger(DefaultHookScriptRunnerFactory.class);
    private final HookScriptCommandLineFactory commandLineFactory;
    private final List<HookScriptEnvironmentProvider> environmentProviders;
    private final I18nService i18nService;
    private final NioProcessHelper nioProcessHelper;
    private final InternalStorageService storageService;
    private int maxOutput;
    private long timeout;

    @Autowired
    public DefaultHookScriptRunnerFactory(HookScriptCommandLineFactory commandLineFactory, List<HookScriptEnvironmentProvider> environmentProviders, I18nService i18nService, @Autowired(required=false) NioProcessHelper nioProcessHelper, InternalStorageService storageService) {
        this(commandLineFactory, environmentProviders, i18nService, nioProcessHelper, storageService, 32768, TimeUnit.MINUTES.toSeconds(2L));
    }

    @VisibleForTesting
    DefaultHookScriptRunnerFactory(HookScriptCommandLineFactory commandLineFactory, List<HookScriptEnvironmentProvider> environmentProviders, I18nService i18nService, NioProcessHelper nioProcessHelper, InternalStorageService storageService, int maxOutput, long timeout) {
        this.commandLineFactory = commandLineFactory;
        this.environmentProviders = environmentProviders;
        this.i18nService = i18nService;
        this.maxOutput = maxOutput;
        this.nioProcessHelper = nioProcessHelper;
        this.storageService = storageService;
        this.timeout = TimeUnit.SECONDS.toMillis(timeout);
    }

    @Nonnull
    public HookScriptRunner create(@Nonnull RepositoryHookRequest hookRequest, @Nonnull HookScriptType type) {
        int maxBytes = type == HookScriptType.PRE || hookRequest.getScmHookDetails().isPresent() ? this.maxOutput : 0;
        return new SimpleHookScriptInvoker(hookRequest, this.prepareEnvironment(hookRequest, type), maxBytes);
    }

    @Value(value="${hookscripts.output.max:32768}")
    public void setMaxOutput(int maxOutput) {
        this.maxOutput = Math.max(maxOutput, 16384);
    }

    @Value(value="${hookscripts.timeout:120}")
    public void setTimeout(long timeout) {
        this.timeout = TimeUnit.SECONDS.toMillis(Math.max(timeout, 30L));
    }

    private static boolean isTimeout(Exception e) {
        return e instanceof CommandTimeoutException;
    }

    private Map<String, String> prepareEnvironment(RepositoryHookRequest request, HookScriptType type) {
        HashMap<String, String> environment = new HashMap<String, String>();
        this.environmentProviders.stream().map(provider -> provider.create(request, type)).forEach(environment::putAll);
        return environment;
    }

    private class SimpleHookScriptInvoker
    implements HookScriptRunner {
        private final Map<String, String> environment;
        private final int maxBytes;
        private final RepositoryHookRequest request;

        private SimpleHookScriptInvoker(RepositoryHookRequest request, Map<String, String> environment, int maxBytes) {
            this.environment = environment;
            this.maxBytes = maxBytes;
            this.request = request;
        }

        @Nonnull
        public HookScriptRunner.Result run(@Nonnull Path script, @Nonnull String scriptName, @Nonnull String metricName) {
            long start = System.nanoTime();
            ScriptProcessHandler handler = this.executeScript(script, metricName);
            Duration duration = Duration.ofNanos(System.nanoTime() - start);
            boolean written = this.request.getScmHookDetails().map(handler::writeResponse).orElse(Boolean.FALSE);
            RepositoryHookResult.Builder resultBuilder = new RepositoryHookResult.Builder();
            Exception exception = handler.getException();
            boolean timedOut = DefaultHookScriptRunnerFactory.isTimeout(exception);
            if (exception == null) {
                if (handler.getExitCode() != 0) {
                    String declinedMessage = DefaultHookScriptRunnerFactory.this.i18nService.getMessage("bitbucket.service.hook.script.veto.declined.summary", new Object[]{scriptName});
                    if (written || !handler.hasResponse()) {
                        resultBuilder.add(RepositoryHookResult.rejected((String)declinedMessage, (String)declinedMessage));
                    } else {
                        resultBuilder.add(RepositoryHookResult.rejected((String)declinedMessage, (String)handler.getResponse()));
                    }
                }
            } else if (timedOut) {
                log.error("{}: Script {} timed out after {}ms", new Object[]{this.request.getRepository(), script, duration.toMillis()});
                resultBuilder.add(RepositoryHookResult.rejected((String)DefaultHookScriptRunnerFactory.this.i18nService.getMessage("bitbucket.service.hook.script.veto.timeout.summary", new Object[]{scriptName}), (String)DefaultHookScriptRunnerFactory.this.i18nService.getMessage("bitbucket.service.hook.script.veto.timeout.detail", new Object[]{TimeUnit.MILLISECONDS.toSeconds(DefaultHookScriptRunnerFactory.this.timeout)})));
            } else {
                log.error("{}: Script {} failed", new Object[]{this.request.getRepository(), script, exception});
                resultBuilder.add(RepositoryHookResult.rejected((String)DefaultHookScriptRunnerFactory.this.i18nService.getMessage("bitbucket.service.hook.script.veto.failed.summary", new Object[]{scriptName}), (String)DefaultHookScriptRunnerFactory.this.i18nService.getMessage("bitbucket.service.hook.script.veto.failed.detail", new Object[0])));
            }
            return new SimpleResult(resultBuilder.build(), duration, handler.getExitCode(), timedOut, exception);
        }

        private ScriptProcessHandler executeScript(Path script, String metricName) {
            Repository repository = this.request.getRepository();
            ScriptNioProcessHandler handler = new ScriptNioProcessHandler(DefaultHookScriptRunnerFactory.this.i18nService, this.request.getRefChanges(), this.maxBytes);
            try (Ticker ignored = Timers.timerWithMetric((String)"run NIO hook script", (String)metricName).start(new Object[]{script});){
                List<String> command = DefaultHookScriptRunnerFactory.this.commandLineFactory.create(script.toString());
                NioProcessParameters parameters = new NioProcessParameters.Builder((NioStdioHandler)handler, (CommandExitHandler)handler).arguments(command).environment(this.environment).executionInterval(Duration.ofMillis(DefaultHookScriptRunnerFactory.this.timeout)).idleInterval(Duration.ofMillis(DefaultHookScriptRunnerFactory.this.timeout)).throwOnNonZeroExit(false).workDir(DefaultHookScriptRunnerFactory.this.storageService.getRepositoryDir(repository)).build();
                new NioCommand(DefaultHookScriptRunnerFactory.this.nioProcessHelper, parameters).call();
            }
            return handler;
        }
    }

    private static class SimpleResult
    implements HookScriptRunner.Result {
        private final Duration duration;
        private final Throwable exception;
        private final int exitCode;
        private final RepositoryHookResult hookResult;
        private final boolean timedOut;

        private SimpleResult(RepositoryHookResult hookResult, Duration duration, int exitCode, boolean timedOut, Throwable exception) {
            this.duration = duration;
            this.exception = exception;
            this.exitCode = exitCode;
            this.hookResult = hookResult;
            this.timedOut = timedOut;
        }

        @Nonnull
        public Duration getDuration() {
            return this.duration;
        }

        public Throwable getException() {
            return this.exception;
        }

        public int getExitCode() {
            return this.exitCode;
        }

        public boolean isTimedOut() {
            return this.timedOut;
        }

        @Nonnull
        public RepositoryHookResult toHookResult() {
            return this.hookResult;
        }
    }
}

