/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.hook.script;

import com.atlassian.bitbucket.concurrent.LockService;
import com.atlassian.bitbucket.dmz.features.RequireFeature;
import com.atlassian.bitbucket.dmz.hook.script.DmzHookScriptService;
import com.atlassian.bitbucket.event.project.ProjectDeletionRequestedEvent;
import com.atlassian.bitbucket.event.repository.RepositoryDeletionRequestedEvent;
import com.atlassian.bitbucket.hook.repository.RepositoryHookRequest;
import com.atlassian.bitbucket.hook.script.HookScript;
import com.atlassian.bitbucket.hook.script.HookScriptConfig;
import com.atlassian.bitbucket.hook.script.HookScriptConfigurationRemovedEvent;
import com.atlassian.bitbucket.hook.script.HookScriptConfigurationSetEvent;
import com.atlassian.bitbucket.hook.script.HookScriptCreateRequest;
import com.atlassian.bitbucket.hook.script.HookScriptCreatedEvent;
import com.atlassian.bitbucket.hook.script.HookScriptDeletedEvent;
import com.atlassian.bitbucket.hook.script.HookScriptRemoveConfigurationRequest;
import com.atlassian.bitbucket.hook.script.HookScriptService;
import com.atlassian.bitbucket.hook.script.HookScriptSetConfigurationRequest;
import com.atlassian.bitbucket.hook.script.HookScriptType;
import com.atlassian.bitbucket.hook.script.HookScriptUpdateRequest;
import com.atlassian.bitbucket.hook.script.HookScriptUpdatedEvent;
import com.atlassian.bitbucket.hook.script.MinimalHookScript;
import com.atlassian.bitbucket.hook.script.NoSuchHookScriptException;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.io.InputSupplier;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.permission.PermissionValidationService;
import com.atlassian.bitbucket.project.Project;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.scope.GlobalScope;
import com.atlassian.bitbucket.scope.ProjectScope;
import com.atlassian.bitbucket.scope.RepositoryScope;
import com.atlassian.bitbucket.scope.Scope;
import com.atlassian.bitbucket.scope.ScopeVisitor;
import com.atlassian.bitbucket.scope.Scopes;
import com.atlassian.bitbucket.server.Feature;
import com.atlassian.bitbucket.server.FeatureManager;
import com.atlassian.bitbucket.server.StandardFeature;
import com.atlassian.bitbucket.util.MoreCollectors;
import com.atlassian.bitbucket.util.Page;
import com.atlassian.bitbucket.util.PageRequest;
import com.atlassian.bitbucket.util.PageUtils;
import com.atlassian.bitbucket.util.concurrent.LockGuard;
import com.atlassian.bitbucket.validation.ArgumentValidationException;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.spring.AvailableToPlugins;
import com.atlassian.scheduler.JobRunnerRequest;
import com.atlassian.scheduler.JobRunnerResponse;
import com.atlassian.scheduler.SchedulerService;
import com.atlassian.scheduler.SchedulerServiceException;
import com.atlassian.scheduler.config.JobConfig;
import com.atlassian.scheduler.config.JobId;
import com.atlassian.scheduler.config.JobRunnerKey;
import com.atlassian.scheduler.config.RunMode;
import com.atlassian.scheduler.config.Schedule;
import com.atlassian.stash.internal.AbstractService;
import com.atlassian.stash.internal.annotation.Secured;
import com.atlassian.stash.internal.annotation.Unsecured;
import com.atlassian.stash.internal.hook.script.HookScriptConfigCriteria;
import com.atlassian.stash.internal.hook.script.HookScriptConfigDao;
import com.atlassian.stash.internal.hook.script.HookScriptDao;
import com.atlassian.stash.internal.hook.script.HookScriptStore;
import com.atlassian.stash.internal.hook.script.HookScriptSummary;
import com.atlassian.stash.internal.hook.script.HookScriptsDeletedByPluginKeyEvent;
import com.atlassian.stash.internal.hook.script.InternalHookScript;
import com.atlassian.stash.internal.hook.script.InternalHookScriptConfig;
import com.atlassian.stash.internal.hook.script.InternalHookScriptService;
import com.atlassian.stash.internal.hook.script.SimpleHookScriptSummary;
import com.atlassian.stash.internal.hook.script.StagedHookScript;
import com.atlassian.stash.internal.mode.DefaultApplicationMode;
import com.atlassian.stash.internal.scheduling.ScheduledJobSource;
import com.atlassian.stash.internal.spring.SpringTransactionUtils;
import com.atlassian.stash.internal.spring.TransactionSynchronizer;
import com.google.common.annotations.VisibleForTesting;
import jakarta.annotation.Nonnull;
import java.io.InputStream;
import java.time.Duration;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.apache.commons.lang3.ObjectUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.support.TransactionSynchronization;
import org.springframework.transaction.support.TransactionSynchronizationAdapter;
import org.springframework.transaction.support.TransactionTemplate;

@AvailableToPlugins(interfaces={DmzHookScriptService.class, HookScriptService.class})
@RequireFeature(value=StandardFeature.HOOK_SCRIPTS)
@Service(value="hookScriptService")
public class DefaultHookScriptService
extends AbstractService
implements InternalHookScriptService,
ScheduledJobSource {
    private static final JobId JOB_ID = JobId.of((String)(HookScriptService.class.getSimpleName() + ".cleanupJob"));
    private static final JobRunnerKey JOB_RUNNER_KEY = JobRunnerKey.of((String)(HookScriptService.class.getName() + ".cleanupJob"));
    private static final String LOCK_NAME = HookScriptService.class.getName() + ".cleanupJob";
    private static final int MINIMUM_MAX_HOOK_SCRIPTS = 50;
    private static final Duration ONE_DAY = Duration.ofDays(1L);
    private final HookScriptConfigDao configDao;
    private final FeatureManager featureManager;
    private final I18nService i18nService;
    private final LockService lockService;
    private final PluginAccessor pluginAccessor;
    private final EventPublisher publisher;
    private final HookScriptDao scriptDao;
    private final HookScriptStore scriptStore;
    private final TransactionSynchronizer synchronizer;
    private final TransactionTemplate transactionTemplate;
    private final PermissionValidationService validationService;
    private int maxHookScriptsPerPage;

    @Autowired
    public DefaultHookScriptService(HookScriptConfigDao configDao, FeatureManager featureManager, I18nService i18nService, LockService lockService, PluginAccessor pluginAccessor, EventPublisher publisher, HookScriptDao scriptDao, HookScriptStore scriptStore, TransactionSynchronizer synchronizer, PlatformTransactionManager transactionManager, PermissionValidationService validationService) {
        this.configDao = configDao;
        this.featureManager = featureManager;
        this.i18nService = i18nService;
        this.lockService = lockService;
        this.pluginAccessor = pluginAccessor;
        this.publisher = publisher;
        this.scriptDao = scriptDao;
        this.scriptStore = scriptStore;
        this.synchronizer = synchronizer;
        this.transactionTemplate = new TransactionTemplate(transactionManager, SpringTransactionUtils.definitionFor((int)0, (boolean)true));
        this.validationService = validationService;
        this.maxHookScriptsPerPage = 100;
    }

    @VisibleForTesting
    DefaultHookScriptService(HookScriptConfigDao configDao, FeatureManager featureManager, I18nService i18nService, LockService lockService, PluginAccessor pluginAccessor, EventPublisher publisher, HookScriptDao scriptDao, HookScriptStore scriptStore, TransactionSynchronizer synchronizer, TransactionTemplate transactionTemplate, PermissionValidationService validationService) {
        this.configDao = configDao;
        this.featureManager = featureManager;
        this.i18nService = i18nService;
        this.lockService = lockService;
        this.pluginAccessor = pluginAccessor;
        this.publisher = publisher;
        this.scriptDao = scriptDao;
        this.scriptStore = scriptStore;
        this.synchronizer = synchronizer;
        this.transactionTemplate = transactionTemplate;
        this.validationService = validationService;
        this.maxHookScriptsPerPage = 100;
    }

    @Nonnull
    @PreAuthorize(value="hasGlobalPermission('SYS_ADMIN')")
    @Transactional
    public InternalHookScript create(@Nonnull HookScriptCreateRequest request) {
        Objects.requireNonNull(request, "request");
        try (StagedHookScript staged = this.scriptStore.stage((InputSupplier<InputStream>)request.getContent());){
            InternalHookScript script = new InternalHookScript.Builder(request).hash(staged.getHash()).size(staged.getSize()).build();
            script = (InternalHookScript)this.scriptDao.create((Object)script);
            this.scriptStore.commit((MinimalHookScript)script, staged);
            this.publisher.publish((Object)new HookScriptCreatedEvent((Object)this, (HookScript)script));
            this.cleanUpOnTransactionFailure((MinimalHookScript)script);
            InternalHookScript internalHookScript = script;
            return internalHookScript;
        }
    }

    @PreAuthorize(value="hasGlobalPermission('SYS_ADMIN')")
    @Transactional
    public void delete(final @Nonnull HookScript script) {
        Objects.requireNonNull(script, "script");
        this.scriptDao.delete((Object)((InternalHookScript)script));
        this.publisher.publish((Object)new HookScriptDeletedEvent((Object)this, script));
        this.synchronizer.register((TransactionSynchronization)new TransactionSynchronizationAdapter(){

            public void afterCommit() {
                DefaultHookScriptService.this.scriptStore.delete((MinimalHookScript)script);
            }
        });
    }

    @PreAuthorize(value="hasGlobalPermission('SYS_ADMIN')")
    @Transactional
    public int deleteByPluginKey(@Nonnull String pluginKey) {
        final Set scripts = this.scriptDao.deleteByPluginKey(Objects.requireNonNull(pluginKey, "pluginKey"));
        if (scripts.isEmpty()) {
            return 0;
        }
        int count = scripts.size();
        this.publisher.publish((Object)new HookScriptsDeletedByPluginKeyEvent(this, pluginKey, count));
        this.synchronizer.register((TransactionSynchronization)new TransactionSynchronizationAdapter(){

            public void afterCommit() {
                scripts.forEach(DefaultHookScriptService.this.scriptStore::delete);
            }
        });
        return count;
    }

    @Nonnull
    @Unsecured(value="Anyone can retrieve an existing script")
    public Optional<HookScript> findById(long scriptId) {
        return Optional.ofNullable((HookScript)this.scriptDao.getById((Object)scriptId));
    }

    @Nonnull
    @Unsecured(value="Anyone can search existing scripts")
    public Page<HookScript> findByPluginKey(@Nonnull String pluginKey, @Nonnull PageRequest pageRequest) {
        Objects.requireNonNull(pluginKey, "pluginKey");
        Objects.requireNonNull(pageRequest, "pageRequest");
        return PageUtils.asPageOf(HookScript.class, (Page)this.scriptDao.findByPluginKey(pluginKey, pageRequest.buildRestrictedPageRequest(this.maxHookScriptsPerPage)));
    }

    @Nonnull
    @Secured(value="Secured internally using a scope-appropriate permission check")
    public Page<HookScriptConfig> findConfigsByScope(@Nonnull Scope scope, @Nonnull PageRequest pageRequest) {
        Objects.requireNonNull(scope, "scope");
        Objects.requireNonNull(pageRequest, "pageRequest");
        this.requireAdminForScope(scope);
        return PageUtils.asPageOf(HookScriptConfig.class, (Page)this.configDao.findByScope(scope, pageRequest));
    }

    @Secured(value="Secured internally using a scope-appropriate permission check")
    public void forEachConfig(@Nonnull Scope scope, @Nonnull Consumer<HookScriptConfig> consumer) {
        Objects.requireNonNull(scope, "scope");
        Objects.requireNonNull(consumer, "consumer");
        this.requireAdminForScope(scope);
        try (Stream stream = this.configDao.stream(HookScriptConfigCriteria.forScope((Scope)scope));){
            stream.forEach(consumer);
        }
    }

    public void forEachScript(@Nonnull Consumer<HookScript> consumer) {
        PageUtils.toStream(arg_0 -> ((HookScriptDao)this.scriptDao).findAll(arg_0), (int)100).forEach(consumer);
    }

    @Unsecured(value="Anyone can retrieve an existing script")
    public HookScript getById(long scriptId) {
        InternalHookScript script = (InternalHookScript)this.scriptDao.getById((Object)scriptId);
        if (script == null) {
            throw new NoSuchHookScriptException(this.i18nService.createKeyedMessage("bitbucket.service.hook.script.notfound", new Object[]{scriptId}), scriptId);
        }
        return script;
    }

    @Unsecured(value="Anyone can check the max size")
    public int getMaxSize() {
        return this.scriptStore.getMaxSize();
    }

    @Nonnull
    @Unsecured(value="Internal interface method")
    @RequireFeature(value=StandardFeature.HOOK_SCRIPTS, skip=true)
    public List<HookScriptSummary> getSummariesByHookRequest(final @Nonnull RepositoryHookRequest request, @Nonnull HookScriptType type) {
        if (!this.featureManager.isEnabled((Feature)StandardFeature.HOOK_SCRIPTS)) {
            return Collections.emptyList();
        }
        return (List)DefaultHookScriptService.scopesFor(request.getRepository()).map(scope -> new HookScriptConfigCriteria.Builder(scope).type(type).build()).flatMap(arg_0 -> ((HookScriptConfigDao)this.configDao).stream(arg_0)).filter(new Predicate<InternalHookScriptConfig>(){
            private final Set<Long> seenHookIds = new HashSet<Long>();
            private final String triggerId = request.getTrigger().getId();

            @Override
            public boolean test(InternalHookScriptConfig config) {
                InternalHookScript script = config.getScript();
                if (this.seenHookIds.add(script.getId()) && DefaultHookScriptService.this.pluginAccessor.isPluginEnabled(script.getPluginKey())) {
                    Set triggerIds = config.getTriggerIds();
                    return triggerIds.isEmpty() || triggerIds.contains(this.triggerId);
                }
                return false;
            }
        }).map(config -> new SimpleHookScriptSummary((HookScript)config.getScript())).collect(MoreCollectors.toImmutableList());
    }

    @EventListener
    @RequireFeature(value=StandardFeature.HOOK_SCRIPTS, skip=true)
    public void onProjectDeletionRequested(ProjectDeletionRequestedEvent event) {
        if (!event.isCanceled()) {
            this.configDao.deleteByScope((Scope)Scopes.project((Project)event.getProject()));
        }
    }

    @EventListener
    @RequireFeature(value=StandardFeature.HOOK_SCRIPTS, skip=true)
    public void onRepositoryDeletionRequested(RepositoryDeletionRequestedEvent event) {
        if (!event.isCanceled()) {
            this.configDao.deleteByScope((Scope)Scopes.repository((Repository)event.getRepository()));
        }
    }

    @Nonnull
    @PreAuthorize(value="hasGlobalPermission('SYS_ADMIN')")
    public InputSupplier<InputStream> read(@Nonnull HookScript script) {
        return this.scriptStore.read((MinimalHookScript)script);
    }

    @Secured(value="Secured internally using a scope-appropriate permission check")
    @Transactional
    public boolean removeConfiguration(@Nonnull HookScriptRemoveConfigurationRequest request) {
        boolean deleted;
        Objects.requireNonNull(request, "request");
        Scope scope = this.requireAdminForScope(request.getScope());
        InternalHookScript script = (InternalHookScript)request.getScript();
        boolean bl = deleted = this.configDao.deleteByScopeAndScript(scope, script) > 0;
        if (deleted) {
            this.publisher.publish((Object)new HookScriptConfigurationRemovedEvent((Object)this, (HookScript)script, scope));
        }
        return deleted;
    }

    @DefaultApplicationMode
    @RequireFeature(value=StandardFeature.HOOK_SCRIPTS, skip=true)
    public void schedule(@Nonnull SchedulerService schedulerService) throws SchedulerServiceException {
        schedulerService.registerJobRunner(JOB_RUNNER_KEY, this::runCleanupJob);
        JobConfig jobConfig = JobConfig.forJobRunnerKey((JobRunnerKey)JOB_RUNNER_KEY).withRunMode(RunMode.RUN_ONCE_PER_CLUSTER).withSchedule(Schedule.forInterval((long)ONE_DAY.toMillis(), (Date)new Date()));
        schedulerService.scheduleJob(JOB_ID, jobConfig);
    }

    @Nonnull
    @Secured(value="Secured internally using a scope-appropriate permission check")
    @Transactional
    public HookScriptConfig setConfiguration(@Nonnull HookScriptSetConfigurationRequest request) {
        Objects.requireNonNull(request, "request");
        Scope scope = this.requireAdminForScope(request.getScope());
        InternalHookScript script = (InternalHookScript)request.getScript();
        Set triggerIds = request.getTriggerIds();
        InternalHookScriptConfig config = this.configDao.findByScopeAndScript(scope, script);
        if (config == null) {
            config = (InternalHookScriptConfig)this.configDao.create((Object)new InternalHookScriptConfig(script, scope, triggerIds));
        } else {
            config.setTriggerIds(triggerIds);
            this.configDao.update((Object)config);
        }
        this.publisher.publish((Object)new HookScriptConfigurationSetEvent((Object)this, (HookScriptConfig)config));
        return config;
    }

    @Value(value="${page.max.hookscripts}")
    public void setMaxHookScriptsPerPage(int maxHookScriptsPerPage) {
        this.maxHookScriptsPerPage = Math.max(maxHookScriptsPerPage, 50);
    }

    @RequireFeature(value=StandardFeature.HOOK_SCRIPTS, skip=true)
    public void unschedule(@Nonnull SchedulerService schedulerService) throws SchedulerServiceException {
        schedulerService.unscheduleJob(JOB_ID);
        schedulerService.unregisterJobRunner(JOB_RUNNER_KEY);
    }

    @Nonnull
    @PreAuthorize(value="hasGlobalPermission('SYS_ADMIN')")
    @Transactional
    public InternalHookScript update(@Nonnull HookScriptUpdateRequest request) {
        Objects.requireNonNull(request, "request");
        try (StagedHookScript staged = request.getContent().map(this.scriptStore::stage).orElse(null);){
            InternalHookScript.Builder builder = new InternalHookScript.Builder(request).updatedDate(new Date());
            if (staged != null) {
                builder.hash(staged.getHash()).size(staged.getSize());
            }
            InternalHookScript toBeUpdated = builder.build();
            InternalHookScript existing = new InternalHookScript.Builder((InternalHookScript)ObjectUtils.firstNonNull((Object[])new InternalHookScript[]{(InternalHookScript)this.scriptDao.getById((Object)toBeUpdated.getId()), toBeUpdated})).build();
            InternalHookScript script = (InternalHookScript)this.scriptDao.updateAndFlush((Object)toBeUpdated);
            if (staged != null) {
                this.scriptStore.commit((MinimalHookScript)script, staged);
            }
            this.publisher.publish((Object)new HookScriptUpdatedEvent((Object)this, (HookScript)script, (HookScript)existing));
            this.cleanUpOnTransactionFailure((MinimalHookScript)script);
            InternalHookScript internalHookScript = script;
            return internalHookScript;
        }
    }

    @PreAuthorize(value="hasGlobalPermission('SYS_ADMIN')")
    @Transactional
    public int updatePluginKey(@Nonnull String oldPluginKey, @Nonnull String newPluginKey) {
        Objects.requireNonNull(oldPluginKey, "oldPluginKey");
        Objects.requireNonNull(newPluginKey, "newPluginKey");
        if (this.pluginAccessor.getPlugin(oldPluginKey) == null) {
            if (this.pluginAccessor.isPluginEnabled(newPluginKey)) {
                return this.scriptDao.updatePluginKey(oldPluginKey, newPluginKey);
            }
            throw new ArgumentValidationException(this.i18nService.createKeyedMessage("bitbucket.service.hook.script.updatepluginkey.newnotinstalled", new Object[]{oldPluginKey, newPluginKey}));
        }
        throw new ArgumentValidationException(this.i18nService.createKeyedMessage("bitbucket.service.hook.script.updatepluginkey.oldstillinstalled", new Object[]{oldPluginKey, newPluginKey}));
    }

    @RequireFeature(value=StandardFeature.HOOK_SCRIPTS, skip=true)
    @VisibleForTesting
    JobRunnerResponse runCleanupJob(JobRunnerRequest request) {
        try (LockGuard guard = LockGuard.tryLock((Lock)this.lockService.getLock(LOCK_NAME));){
            if (guard != null) {
                Set scripts = (Set)this.transactionTemplate.execute(action -> this.scriptDao.getAll());
                this.scriptStore.deleteUnreferencedScripts(scripts);
            }
        }
        catch (Exception e) {
            return JobRunnerResponse.failed((Throwable)e);
        }
        return JobRunnerResponse.success();
    }

    private static Stream<Scope> scopesFor(Repository repository) {
        return Stream.of(Scopes.repository((Repository)repository), Scopes.project((Project)repository.getProject()), Scopes.global());
    }

    private void cleanUpOnTransactionFailure(final MinimalHookScript scriptToCleanUp) {
        this.synchronizer.register((TransactionSynchronization)new TransactionSynchronizationAdapter(){

            public void afterCompletion(int status) {
                if (status != 0) {
                    DefaultHookScriptService.this.scriptStore.deleteVersion(scriptToCleanUp);
                }
            }
        });
    }

    private Scope requireAdminForScope(Scope scope) {
        return (Scope)scope.accept((ScopeVisitor)new ScopeVisitor<Scope>(){

            public Scope visit(@Nonnull GlobalScope scope) {
                DefaultHookScriptService.this.validationService.validateForGlobal(Permission.ADMIN);
                return scope;
            }

            public Scope visit(@Nonnull ProjectScope scope) {
                DefaultHookScriptService.this.validationService.validateForProject(scope.getProject(), Permission.PROJECT_ADMIN);
                return scope;
            }

            public Scope visit(@Nonnull RepositoryScope scope) {
                DefaultHookScriptService.this.validationService.validateForRepository(scope.getRepository(), Permission.REPO_ADMIN);
                return scope;
            }
        });
    }
}

