/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.hook.script;

import com.atlassian.stash.internal.hook.script.StagedHookScript;
import jakarta.annotation.Nonnull;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.util.Objects;
import org.slf4j.LoggerFactory;

class FileStagedHookScript
implements StagedHookScript {
    private final String hash;
    private final int size;
    private final Path tempFile;

    FileStagedHookScript(@Nonnull Path tempFile, @Nonnull String hash, int size) {
        this.hash = Objects.requireNonNull(hash, "hash");
        this.size = size;
        this.tempFile = Objects.requireNonNull(tempFile, "tempFile");
    }

    @Override
    public void close() {
        try {
            Files.delete(this.tempFile);
        }
        catch (FileNotFoundException | NoSuchFileException iOException) {
        }
        catch (IOException e) {
            LoggerFactory.getLogger(this.getClass()).warn("Failed to delete temp file: {}", (Object)this.tempFile.toAbsolutePath(), (Object)e);
        }
    }

    @Override
    @Nonnull
    public String getHash() {
        return this.hash;
    }

    @Override
    public int getSize() {
        return this.size;
    }

    Path getTempFile() {
        return this.tempFile;
    }
}

