/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.hook.script;

import com.atlassian.bitbucket.hook.script.HookScript;
import com.atlassian.bitbucket.scope.Scope;
import com.atlassian.bitbucket.server.Feature;
import com.atlassian.bitbucket.server.FeatureManager;
import com.atlassian.bitbucket.server.StandardFeature;
import com.atlassian.bitbucket.util.NumberUtils;
import com.atlassian.bitbucket.util.Timer;
import com.atlassian.bitbucket.util.TimerUtils;
import com.atlassian.stash.internal.hook.script.InternalHookScriptService;
import com.atlassian.troubleshooting.spi.SupportDataBuilder;
import jakarta.annotation.Nonnull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class HookScriptSupportDataHelper {
    private static final String HOOK_SCRIPT = "bitbucket.atst.hook.script";
    private static final String CONFIGURED_SCRIPT = "bitbucket.atst.hook.script.configured";
    private static final String CONFIGURED_SCRIPTS = "bitbucket.atst.hook.script.configured.root";
    private static final String DESCRIPTION = "bitbucket.atst.hook.script.description";
    private static final String HOOK_SCRIPTS = "bitbucket.atst.hook.script.root";
    private static final String ID = "bitbucket.atst.hook.script.id";
    private static final String NAME = "bitbucket.atst.hook.script.name";
    private static final String PLUGIN_KEY = "bitbucket.atst.hook.script.plugin.key";
    private static final String SIZE = "bitbucket.atst.hook.script.size";
    private static final String TRIGGERS = "bitbucket.atst.hook.script.triggers";
    private static final String TYPE = "bitbucket.atst.hook.script.type";
    private static final String VERSION = "bitbucket.atst.hook.script.version";
    private final FeatureManager featureManager;
    private final InternalHookScriptService hookScriptService;

    @Autowired
    public HookScriptSupportDataHelper(FeatureManager featureManager, InternalHookScriptService hookScriptService) {
        this.featureManager = featureManager;
        this.hookScriptService = hookScriptService;
    }

    public void addAllScriptData(@Nonnull SupportDataBuilder builder) {
        if (!this.featureManager.isEnabled((Feature)StandardFeature.HOOK_SCRIPTS)) {
            return;
        }
        try (Timer ignored = TimerUtils.start((String)"Adding hook script info");){
            SupportDataBuilder scriptsBuilder = builder.addCategory(HOOK_SCRIPTS);
            this.hookScriptService.forEachScript(script -> {
                SupportDataBuilder scriptBuilder = scriptsBuilder.addCategory(HOOK_SCRIPT).addValue(ID, Long.toString(script.getId())).addValue(NAME, script.getName()).addValue(PLUGIN_KEY, script.getPluginKey()).addValue(SIZE, NumberUtils.formatSize((double)script.getSize())).addValue(TYPE, script.getType().name()).addValue(VERSION, Integer.toString(script.getVersion()));
                script.getDescription().ifPresent(description -> scriptBuilder.addValue(DESCRIPTION, description));
            });
        }
    }

    public void addConfiguredHookScriptData(@Nonnull SupportDataBuilder builder, @Nonnull Scope scope) {
        if (!this.featureManager.isEnabled((Feature)StandardFeature.HOOK_SCRIPTS)) {
            return;
        }
        try (Timer ignored = TimerUtils.start((String)"Adding configured hook script info");){
            SupportDataBuilder scriptsBuilder = builder.addCategory(CONFIGURED_SCRIPTS);
            this.hookScriptService.forEachConfig(scope, config -> {
                HookScript script = config.getScript();
                scriptsBuilder.addCategory(CONFIGURED_SCRIPT).addValue(ID, Long.toString(script.getId())).addValue(NAME, script.getName()).addValue(PLUGIN_KEY, script.getPluginKey()).addValue(TRIGGERS, String.join((CharSequence)", ", config.getTriggerIds()));
            });
        }
    }
}

