/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.hook.script;

import com.atlassian.bitbucket.dmz.hook.script.HookScriptEnvironmentProvider;
import com.atlassian.bitbucket.hook.ScmHookDetails;
import com.atlassian.bitbucket.hook.repository.RepositoryHookRequest;
import com.atlassian.bitbucket.hook.repository.RepositoryHookResult;
import com.atlassian.bitbucket.hook.script.HookScriptType;
import com.atlassian.bitbucket.hook.script.MinimalHookScript;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.internal.mesh.HookScriptCallback;
import com.atlassian.bitbucket.internal.mesh.HookScriptOutcome;
import com.atlassian.bitbucket.internal.mesh.RpcHookScriptClient;
import com.atlassian.bitbucket.io.InputSupplier;
import com.atlassian.bitbucket.mesh.rpc.util.ByteStringUtils;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcCallHookScriptsRequest;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcGitTimeouts;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcHookScriptOptions;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcRefUpdate;
import com.atlassian.bitbucket.repository.RefChange;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.diagnostics.AlertRequest;
import com.atlassian.diagnostics.AlertTrigger;
import com.atlassian.diagnostics.ComponentMonitor;
import com.atlassian.diagnostics.Issue;
import com.atlassian.diagnostics.MonitoringService;
import com.atlassian.diagnostics.Severity;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.stash.internal.hook.script.HookScriptInvoker;
import com.atlassian.stash.internal.hook.script.HookScriptStore;
import com.atlassian.stash.internal.hook.script.HookScriptSummary;
import com.atlassian.stash.internal.hook.script.InternalHookScriptService;
import com.atlassian.util.profiling.Metrics;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import com.google.protobuf.ByteString;
import io.grpc.Status;
import jakarta.annotation.Nonnull;
import java.io.InputStream;
import java.time.Duration;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.stereotype.Component;

@Component(value="meshHookScriptInvoker")
@ConditionalOnBean(value={RpcHookScriptClient.class})
public class MeshHookScriptInvoker
implements HookScriptInvoker {
    private static final Logger log = LoggerFactory.getLogger(MeshHookScriptInvoker.class);
    private final List<HookScriptEnvironmentProvider> environmentProviders;
    private final RpcHookScriptClient hookScriptClient;
    private final I18nService i18nService;
    private final ComponentMonitor monitor;
    private final PluginAccessor pluginAccessor;
    private final InternalHookScriptService scriptService;
    private final HookScriptStore scriptStore;
    private final Issue slowIssue;
    private final Issue timedOutIssue;
    private int maxOutput;
    private long slowWarning;
    private RpcGitTimeouts timeouts;

    @Autowired
    public MeshHookScriptInvoker(List<HookScriptEnvironmentProvider> environmentProviders, RpcHookScriptClient hookScriptClient, I18nService i18nService, MonitoringService monitoringService, PluginAccessor pluginAccessor, InternalHookScriptService scriptService, HookScriptStore scriptStore) {
        this(environmentProviders, hookScriptClient, i18nService, monitoringService, pluginAccessor, scriptService, scriptStore, 32768, TimeUnit.MINUTES.toSeconds(1L), TimeUnit.MINUTES.toSeconds(2L));
    }

    @VisibleForTesting
    MeshHookScriptInvoker(List<HookScriptEnvironmentProvider> environmentProviders, RpcHookScriptClient hookScriptClient, I18nService i18nService, MonitoringService monitoringService, PluginAccessor pluginAccessor, InternalHookScriptService scriptService, HookScriptStore scriptStore, int maxOutput, long slowWarning, long timeout) {
        this.environmentProviders = environmentProviders;
        this.hookScriptClient = hookScriptClient;
        this.i18nService = i18nService;
        this.maxOutput = maxOutput;
        this.pluginAccessor = pluginAccessor;
        this.scriptService = scriptService;
        this.scriptStore = scriptStore;
        this.slowWarning = TimeUnit.SECONDS.toMillis(slowWarning);
        this.monitor = monitoringService.createMonitor("HookScript", "bitbucket.diagnostics.hook.script.name");
        this.slowIssue = this.monitor.defineIssue(2002).severity(Severity.WARNING).summaryI18nKey("bitbucket.diagnostics.hook.script.2002.summary").descriptionI18nKey("bitbucket.diagnostics.hook.script.2002.description").build();
        this.timedOutIssue = this.monitor.defineIssue(2003).severity(Severity.WARNING).summaryI18nKey("bitbucket.diagnostics.hook.script.2003.summary").descriptionI18nKey("bitbucket.diagnostics.hook.script.2003.description").build();
        this.timeouts = RpcGitTimeouts.newBuilder().setExecution(timeout).setIdle(timeout).build();
    }

    @Override
    public void postUpdate(@Nonnull RepositoryHookRequest request) {
        Map<String, HookScriptSummary> scripts = this.getHookScriptsByRpcName(request, HookScriptType.POST);
        if (scripts.isEmpty()) {
            return;
        }
        try {
            this.hookScriptClient.callHookScripts(request.getRepository(), RpcCallHookScriptsRequest.newBuilder().addAllHookScript(scripts.keySet()).addAllRefUpdates((Iterable)request.getRefChanges().stream().map(MeshHookScriptInvoker::toRpcRefUpdate).collect(Collectors.toList())).setHookScriptOptions(this.hookScriptOptions(request, HookScriptType.POST)), (ScmHookDetails)request.getScmHookDetails().orElse(null), (HookScriptCallback)new PostUpdateHookCallback(request, scripts));
        }
        catch (RuntimeException e) {
            String scriptNames = scripts.values().stream().map(HookScriptSummary::toString).collect(Collectors.joining(", "));
            if (MeshHookScriptInvoker.isTimeout(e)) {
                log.warn("Post-receive hook scripts [{}] timed out.", (Object)scriptNames);
            }
            log.warn("Post-receive hook scripts [{}] failed", (Object)scriptNames, (Object)e);
        }
    }

    @Override
    public RepositoryHookResult preUpdate(@Nonnull RepositoryHookRequest request) {
        Map<String, HookScriptSummary> scripts = this.getHookScriptsByRpcName(request, HookScriptType.PRE);
        if (scripts.isEmpty()) {
            return RepositoryHookResult.accepted();
        }
        PreUpdateHookCallback callback = new PreUpdateHookCallback(request, scripts);
        this.hookScriptClient.callHookScripts(request.getRepository(), RpcCallHookScriptsRequest.newBuilder().addAllHookScript(scripts.keySet()).addAllRefUpdates((Iterable)request.getRefChanges().stream().map(MeshHookScriptInvoker::toRpcRefUpdate).collect(Collectors.toList())).setAbortOnFirstVeto(request.getTrigger().isAbortOnFirstVeto()).setHookScriptOptions(this.hookScriptOptions(request, HookScriptType.PRE)), (ScmHookDetails)request.getScmHookDetails().orElse(null), (HookScriptCallback)callback);
        try {
            return callback.getResult();
        }
        catch (RuntimeException e) {
            String scriptNames = scripts.values().stream().map(HookScriptSummary::toString).collect(Collectors.joining(", "));
            if (MeshHookScriptInvoker.isTimeout(e)) {
                log.warn("Timed out waiting for the pre-receive hook scripts [{}] to complete. Aborting", (Object)scriptNames);
                return RepositoryHookResult.rejected((String)this.i18nService.getMessage("bitbucket.service.hook.script.veto.timeout.summary", new Object[]{scriptNames}), (String)this.i18nService.getMessage("bitbucket.service.hook.script.veto.timeout.detail", new Object[]{this.timeouts.getExecution()}));
            }
            log.warn("Pre-receive hook scripts [{}] failed", (Object)scriptNames, (Object)e);
            return RepositoryHookResult.rejected((String)this.i18nService.getMessage("bitbucket.service.hook.script.veto.failed.summary", new Object[0]), (String)this.i18nService.getMessage("bitbucket.service.hook.script.veto.timeout.detail", new Object[]{scriptNames}));
        }
    }

    @Value(value="${hookscripts.output.max:32768}")
    public void setMaxOutput(int maxOutput) {
        this.maxOutput = Math.max(maxOutput, 16384);
    }

    @Value(value="${hookscripts.timeout:120}")
    public void setTimeout(long timeout) {
        timeout = Math.max(timeout, 30L);
        this.timeouts = RpcGitTimeouts.newBuilder().setExecution(timeout).setIdle(timeout).build();
    }

    @Value(value="${diagnostics.issues.hookscript.slow.time.seconds:30}")
    public void setSlowWarning(long time) {
        this.slowWarning = TimeUnit.SECONDS.toMillis(Math.max(time, 10L));
    }

    @VisibleForTesting
    static String getRpcName(MinimalHookScript script) {
        return "hook-scripts/" + script.getId() + "/" + script.getVersion();
    }

    private static boolean isTimeout(Throwable t) {
        return Status.fromThrowable((Throwable)t).getCode() == Status.Code.DEADLINE_EXCEEDED;
    }

    private static String metricName(HookScriptSummary script, String qualifier) {
        return "hook-scripts." + script.getPluginKey().replace('.', '/') + "." + script.getName().replace('.', '_') + "." + qualifier;
    }

    private static RpcRefUpdate toRpcRefUpdate(RefChange refChange) {
        return RpcRefUpdate.newBuilder().setRefId(ByteString.copyFromUtf8((String)refChange.getRef().getId())).setOldHash(refChange.getFromHash()).setNewHash(refChange.getToHash()).build();
    }

    private Map<String, HookScriptSummary> getHookScriptsByRpcName(RepositoryHookRequest request, HookScriptType scriptType) {
        List summaries = this.scriptService.getSummariesByHookRequest(request, scriptType);
        if (summaries.isEmpty()) {
            return Collections.emptyMap();
        }
        return summaries.stream().collect(Collectors.toMap(MeshHookScriptInvoker::getRpcName, Function.identity()));
    }

    private RpcHookScriptOptions.Builder hookScriptOptions(RepositoryHookRequest request, HookScriptType type) {
        RpcHookScriptOptions.Builder builder = RpcHookScriptOptions.newBuilder().setTimeouts(this.timeouts);
        if (type == HookScriptType.POST && !request.getScmHookDetails().isPresent()) {
            builder.setMaxOutputLength(0);
        } else {
            builder.setMaxOutputLength(this.maxOutput);
        }
        this.environmentProviders.stream().map(provider -> provider.create(request, type)).forEach(environment -> builder.putAllEnvironment(ByteStringUtils.toByteStringsLazily((Map)environment)));
        return builder;
    }

    private void maybeRaiseSlowIssue(HookScriptType type, RepositoryHookRequest request, HookScriptSummary script, long duration) {
        if (duration > this.slowWarning) {
            this.raiseIssue(type, request, script, this.slowIssue, duration);
        }
    }

    private void raiseIssue(HookScriptType type, RepositoryHookRequest request, HookScriptSummary script, Issue issue, long timeInMillis) {
        Plugin plugin = this.pluginAccessor.getPlugin(script.getPluginKey());
        String version = "Uninstalled";
        if (plugin != null) {
            version = plugin.getPluginInformation().getVersion();
        }
        AlertTrigger trigger = new AlertTrigger.Builder().plugin(script.getPluginKey(), version).module(this.i18nService.getMessage("bitbucket.diagnostics.hook.script.plugin.module", new Object[]{script.getName()})).build();
        this.monitor.alert(new AlertRequest.Builder(issue).trigger(trigger).details(() -> ImmutableMap.builder().put((Object)this.i18nService.getMessage("bitbucket.diagnostics.hook.script.details.duration", new Object[0]), (Object)Long.toString(timeInMillis)).put((Object)this.i18nService.getMessage("bitbucket.diagnostics.hook.script.details.script", new Object[0]), (Object)script.getName()).put((Object)this.i18nService.getMessage("bitbucket.diagnostics.hook.script.details.script.id", new Object[0]), (Object)Long.toString(script.getId())).put((Object)this.i18nService.getMessage("bitbucket.diagnostics.hook.script.details.project", new Object[0]), (Object)request.getRepository().getProject().getName()).put((Object)this.i18nService.getMessage("bitbucket.diagnostics.hook.script.details.repository", new Object[0]), (Object)request.getRepository().getName()).put((Object)this.i18nService.getMessage("bitbucket.diagnostics.hook.script.details.trigger", new Object[0]), (Object)request.getTrigger().getId()).put((Object)this.i18nService.getMessage("bitbucket.diagnostics.hook.script.details.type", new Object[0]), (Object)type.name()).build()).build());
    }

    private void raiseTimeoutIssue(HookScriptType type, RepositoryHookRequest request, HookScriptSummary script, long duration) {
        this.raiseIssue(type, request, script, this.timedOutIssue, duration);
    }

    private class PostUpdateHookCallback
    implements HookScriptCallback {
        private final RepositoryHookRequest request;
        private final Map<String, HookScriptSummary> scripts;

        private PostUpdateHookCallback(RepositoryHookRequest request, Map<String, HookScriptSummary> scripts) {
            this.request = request;
            this.scripts = scripts;
        }

        @Nonnull
        public InputSupplier<InputStream> onMissingScript(@Nonnull String name) {
            return MeshHookScriptInvoker.this.scriptStore.read((MinimalHookScript)this.scripts.get(name));
        }

        public void onScriptResult(@Nonnull String name, @Nonnull HookScriptOutcome outcome, @Nonnull Duration duration, String output) {
            Repository repository = this.request.getRepository();
            HookScriptSummary script = this.scripts.get(name);
            long successMetricValue = 0L;
            switch (outcome) {
                case ACCEPTED: {
                    successMetricValue = 1L;
                    MeshHookScriptInvoker.this.maybeRaiseSlowIssue(HookScriptType.POST, this.request, script, duration.toMillis());
                    break;
                }
                case ERROR: {
                    log.warn("{}: Post-update script {} failed with '{}'", new Object[]{repository, script, output});
                    break;
                }
                case NOT_CALLED: {
                    return;
                }
                case REJECTED: {
                    log.debug("{}: {} rejected the changes, but post-update hook scripts can't reject changes", (Object)repository, (Object)script);
                    break;
                }
                case TIMED_OUT: {
                    long durationMs = duration.toMillis();
                    log.warn("{}: Post-update script {} timed out after {}ms", new Object[]{repository, script, durationMs});
                    MeshHookScriptInvoker.this.raiseTimeoutIssue(HookScriptType.POST, this.request, script, durationMs);
                }
            }
            Metrics.histogram((String)MeshHookScriptInvoker.metricName(script, "success")).update(successMetricValue);
        }
    }

    private class PreUpdateHookCallback
    implements HookScriptCallback {
        private final RepositoryHookRequest request;
        private final RepositoryHookResult.Builder resultBuilder;
        private final Map<String, HookScriptSummary> scripts;

        private PreUpdateHookCallback(RepositoryHookRequest request, Map<String, HookScriptSummary> scripts) {
            this.request = request;
            this.scripts = scripts;
            this.resultBuilder = new RepositoryHookResult.Builder();
        }

        @Nonnull
        public InputSupplier<InputStream> onMissingScript(@Nonnull String name) {
            return MeshHookScriptInvoker.this.scriptStore.read((MinimalHookScript)this.scripts.get(name));
        }

        @Nonnull
        public RepositoryHookResult getResult() {
            return this.resultBuilder.build();
        }

        public void onScriptResult(@Nonnull String name, @Nonnull HookScriptOutcome outcome, @Nonnull Duration duration, String output) {
            Repository repository = this.request.getRepository();
            HookScriptSummary script = this.scripts.get(name);
            long successMetricValue = 0L;
            switch (outcome) {
                case ACCEPTED: {
                    successMetricValue = 1L;
                    Metrics.histogram((String)MeshHookScriptInvoker.metricName(script, "veto")).update(0L);
                    MeshHookScriptInvoker.this.maybeRaiseSlowIssue(HookScriptType.PRE, this.request, script, duration.toMillis());
                    break;
                }
                case ERROR: {
                    log.error("{}: Pre-update script {} failed with '{}'", new Object[]{repository, script, output});
                    this.resultBuilder.add(RepositoryHookResult.rejected((String)MeshHookScriptInvoker.this.i18nService.getMessage("bitbucket.service.hook.script.veto.failed.summary", new Object[]{script.getName()}), (String)MeshHookScriptInvoker.this.i18nService.getMessage("bitbucket.service.hook.script.veto.failed.detail", new Object[0])));
                    break;
                }
                case NOT_CALLED: {
                    return;
                }
                case REJECTED: {
                    String declinedMessage = MeshHookScriptInvoker.this.i18nService.getMessage("bitbucket.service.hook.script.veto.declined.summary", new Object[]{script.getName()});
                    Metrics.histogram((String)MeshHookScriptInvoker.metricName(script, "veto")).update(1L);
                    if (this.request.getScmHookDetails().isPresent() || StringUtils.isBlank((CharSequence)output)) {
                        output = declinedMessage;
                    }
                    this.resultBuilder.add(RepositoryHookResult.rejected((String)declinedMessage, (String)output));
                    break;
                }
                case TIMED_OUT: {
                    long durationMs = duration.toMillis();
                    log.error("{}: Pre-update script {} timed out after {}ms", new Object[]{repository, script, duration});
                    MeshHookScriptInvoker.this.raiseTimeoutIssue(HookScriptType.PRE, this.request, script, durationMs);
                    this.resultBuilder.add(RepositoryHookResult.rejected((String)MeshHookScriptInvoker.this.i18nService.getMessage("bitbucket.service.hook.script.veto.timeout.summary", new Object[]{script.getName()}), (String)MeshHookScriptInvoker.this.i18nService.getMessage("bitbucket.service.hook.script.veto.timeout.detail", new Object[]{MeshHookScriptInvoker.this.timeouts.getExecution()})));
                }
            }
            Metrics.histogram((String)MeshHookScriptInvoker.metricName(script, "success")).update(successMetricValue);
        }
    }
}

