/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.hook.script;

import com.atlassian.bitbucket.dmz.process.LineStdinHandler;
import com.atlassian.bitbucket.dmz.process.NioStdioHandler;
import com.atlassian.bitbucket.hook.ScmHookDetails;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.io.ContentDetectionUtils;
import com.atlassian.bitbucket.repository.RefChange;
import com.atlassian.bitbucket.scm.CommandExitHandler;
import com.atlassian.bitbucket.scm.Watchdog;
import com.atlassian.stash.internal.hook.script.ScriptProcessHandler;
import jakarta.annotation.Nonnull;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;

class ScriptNioProcessHandler
extends LineStdinHandler
implements CommandExitHandler,
NioStdioHandler<Void>,
ScriptProcessHandler {
    private final I18nService i18nService;
    private final int maxBytes;
    private final ByteBuffer stderrBytes;
    private final ByteBuffer stdoutBytes;
    private Exception exception;
    private int exitCode;
    private long stderrDropped;
    private long stdoutDropped;

    ScriptNioProcessHandler(I18nService i18nService, Iterable<RefChange> refChanges, int maxBytes) {
        super(ScriptNioProcessHandler.buildLines(refChanges));
        this.i18nService = i18nService;
        this.maxBytes = maxBytes;
        this.stderrBytes = ByteBuffer.allocate(maxBytes);
        this.stdoutBytes = ByteBuffer.allocate(maxBytes);
    }

    public void complete() {
        throw new UnsupportedOperationException("BIO output is not supported");
    }

    @Override
    @Nonnull
    public Exception getException() {
        return this.exception;
    }

    @Override
    public int getExitCode() {
        return this.exitCode;
    }

    public Void getOutput() {
        return null;
    }

    @Override
    @Nonnull
    public String getResponse() {
        String stderr = this.getStderr();
        String stdout = this.getStdout();
        if (stdout.length() == 0) {
            return stderr;
        }
        if (stderr.length() == 0) {
            return stdout;
        }
        return stdout + '\n' + stderr;
    }

    @Override
    public boolean hasResponse() {
        return this.stderrBytes.position() > 0 || this.stdoutBytes.position() > 0;
    }

    public void onCancel(@Nonnull String command, int exitCode, String stdErr, Throwable thrown) {
        this.exitCode = exitCode;
        if (thrown != null) {
            this.exception = (Exception)thrown;
        }
    }

    public void onExit(@Nonnull String command, int exitCode, String stdErr, Throwable thrown) {
        this.exitCode = exitCode;
        if (thrown != null) {
            this.exception = (Exception)thrown;
        }
    }

    public void onStderr(@Nonnull ByteBuffer buffer, boolean closed) {
        int bufferRemaining;
        int bytesRemaining = this.stderrBytes.remaining();
        if (bytesRemaining < (bufferRemaining = buffer.remaining())) {
            this.stderrDropped += (long)(bufferRemaining - bytesRemaining);
            if (bytesRemaining > 0) {
                this.stderrBytes.put(buffer.slice().limit(bytesRemaining));
            }
            buffer.position(buffer.position() + bufferRemaining);
        } else {
            this.stderrBytes.put(buffer);
        }
    }

    public void onStdout(@Nonnull ByteBuffer buffer, boolean closed) {
        int bufferRemaining;
        int bytesRemaining = this.stdoutBytes.remaining();
        if (bytesRemaining < (bufferRemaining = buffer.remaining())) {
            this.stdoutDropped += (long)(bufferRemaining - bytesRemaining);
            if (bytesRemaining > 0) {
                this.stdoutBytes.put(buffer.slice().limit(bytesRemaining));
            }
            buffer.position(buffer.position() + bufferRemaining);
        } else {
            this.stdoutBytes.put(buffer);
        }
    }

    public void process(@Nonnull InputStream output) throws IOException {
        throw new UnsupportedOperationException("BIO output is not supported");
    }

    public void setWatchdog(@Nonnull Watchdog watchdog) {
        throw new UnsupportedOperationException("BIO processes are not supported");
    }

    @Override
    public boolean writeResponse(@Nonnull ScmHookDetails details) {
        if (this.hasResponse()) {
            details.out().write(this.getStdout());
            details.err().write(this.getStderr());
            return true;
        }
        return false;
    }

    private static Iterable<String> buildLines(Iterable<RefChange> refChanges) {
        ArrayList<String> lines = new ArrayList<String>();
        for (RefChange refChange : refChanges) {
            StringBuilder builder = new StringBuilder(refChange.getFromHash()).append(' ').append(refChange.getToHash()).append(' ').append(refChange.getRef().getId());
            lines.add(builder.toString());
        }
        return lines;
    }

    private static CharsetDecoder createDecoder(@Nonnull ByteBuffer buffer) {
        return ScriptNioProcessHandler.detectCharset(buffer).newDecoder().onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE);
    }

    private static Charset detectCharset(ByteBuffer buffer) {
        return ScriptNioProcessHandler.toCharset(ContentDetectionUtils.detectEncoding((ByteBuffer)buffer));
    }

    private static Charset toCharset(String encoding) {
        return encoding == null ? StandardCharsets.UTF_8 : Charset.forName(encoding);
    }

    private String decodeBuffer(ByteBuffer buffer, String type, long dropped) {
        buffer.flip();
        StringBuilder builder = new StringBuilder();
        try {
            CharBuffer charBuffer = ScriptNioProcessHandler.createDecoder(buffer).decode(buffer);
            builder.append(charBuffer.array(), charBuffer.arrayOffset(), charBuffer.remaining());
        }
        catch (CharacterCodingException e) {
            builder.append(new String(buffer.array(), buffer.arrayOffset(), buffer.remaining(), StandardCharsets.UTF_8));
        }
        if (dropped > 0L) {
            String truncated = this.i18nService.getMessage("bitbucket.service.hook.script.output.truncated", new Object[]{type, this.maxBytes, dropped});
            builder.append("...\n").append(truncated);
        }
        return builder.toString();
    }

    private String getStderr() {
        return this.decodeBuffer(this.stderrBytes, "stderr", this.stderrDropped);
    }

    private String getStdout() {
        return this.decodeBuffer(this.stdoutBytes, "stdout", this.stdoutDropped);
    }
}

