/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.hook.script;

import com.atlassian.stash.internal.hook.script.HookScriptCommandLineFactory;
import com.google.common.collect.ImmutableList;
import com.google.common.io.ByteStreams;
import jakarta.annotation.Nonnull;
import jakarta.annotation.PostConstruct;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Profile;
import org.springframework.stereotype.Component;

@Component(value="hookScriptCommandLineFactory")
@Profile(value={"windows"})
public class WindowsHookScriptCommandLineFactory
implements HookScriptCommandLineFactory {
    private static final List<String> DEFAULT_LOCATIONS = ImmutableList.of((Object)"C:\\Program Files\\Git\\bin", (Object)"C:\\Program Files (x86)\\Git\\bin", (Object)"C:\\Git\\bin");
    private static final Logger log = LoggerFactory.getLogger(WindowsHookScriptCommandLineFactory.class);
    private final String configuredPath;
    private String bash;

    @Autowired
    public WindowsHookScriptCommandLineFactory(@Value(value="${hookscripts.path.shell:}") String path) {
        this.configuredPath = WindowsHookScriptCommandLineFactory.maybeApplyExtension(path);
    }

    @Override
    @Nonnull
    public List<String> create(@Nonnull String script) {
        Objects.requireNonNull(script, "script");
        return Arrays.asList(this.bash, "-c", script.replace('\\', '/'));
    }

    @PostConstruct
    public void findBash() {
        if (this.configuredPath != null) {
            File maybeBash = new File(this.configuredPath);
            if (maybeBash.isFile() && WindowsHookScriptCommandLineFactory.isGnuBash(maybeBash)) {
                log.info("Using configured GNU bash: {}", (Object)maybeBash);
                this.bash = maybeBash.getAbsolutePath();
                return;
            }
            log.warn("The configured GNU bash, {}, is not valid. Will search %PATH% instead", (Object)maybeBash);
        }
        this.bash = WindowsHookScriptCommandLineFactory.getSearchDirs().map(WindowsHookScriptCommandLineFactory::executableFor).filter(Objects::nonNull).filter(WindowsHookScriptCommandLineFactory::isGnuBash).findFirst().map(File::getAbsolutePath).orElseThrow(() -> new IllegalStateException("Could not find GNU bash; hook scripts will not work"));
        log.info("Found GNU bash at {}", (Object)this.bash);
    }

    private static File executableFor(File dir) {
        if (new File(dir, "git.exe").isFile()) {
            File bash;
            File file = bash = "cmd".equals(dir.getName()) ? new File(dir.getParent(), "bin\\bash.exe") : new File(dir, "bash.exe");
            if (bash.isFile()) {
                return bash;
            }
        }
        return null;
    }

    private static Stream<File> getSearchDirs() {
        Stream<Object> searchPaths = DEFAULT_LOCATIONS.stream();
        String path = System.getenv("PATH");
        if (path != null) {
            searchPaths = Stream.concat(searchPaths, Stream.of(path.split(File.pathSeparator)).filter(StringUtils::isNotBlank));
        }
        return searchPaths.map(File::new);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private static boolean isGnuBash(File bash) {
        try {
            Process process = new ProcessBuilder(bash.getAbsolutePath(), "--version").start();
            try {
                boolean bl;
                block13: {
                    InputStream stdout = process.getInputStream();
                    try {
                        byte[] bytes = ByteStreams.toByteArray((InputStream)ByteStreams.limit((InputStream)stdout, (long)8L));
                        ByteStreams.exhaust((InputStream)stdout);
                        bl = "GNU bash".equals(new String(bytes, StandardCharsets.UTF_8));
                        if (stdout == null) break block13;
                    }
                    catch (Throwable throwable) {
                        if (stdout != null) {
                            try {
                                stdout.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    stdout.close();
                }
                return bl;
            }
            finally {
                if (!process.waitFor(2L, TimeUnit.SECONDS)) {
                    log.warn("{} did not complete in time; it may not be GNU bash", (Object)bash);
                    process.destroy();
                }
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            log.warn("{} was interrupted prior to completion", (Object)bash, (Object)e);
        }
        catch (IOException e) {
            log.warn("{} failed testing", (Object)bash, (Object)e);
        }
        return false;
    }

    private static String maybeApplyExtension(String path) {
        if ((path = StringUtils.trimToNull((String)path)) == null) {
            return null;
        }
        return StringUtils.appendIfMissingIgnoreCase((String)path, (CharSequence)".exe", (CharSequence[])new CharSequence[0]);
    }
}

