/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.i18n;

import com.atlassian.bitbucket.util.Chainable;
import com.atlassian.bitbucket.util.MoreCollectors;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.Resources;
import com.atlassian.plugin.elements.ResourceDescriptor;
import com.atlassian.stash.internal.i18n.cache.MessageKey;
import com.atlassian.stash.internal.i18n.cache.MessageMap;
import com.atlassian.stash.internal.i18n.cache.UnresolvedLocales;
import com.atlassian.stash.internal.plugin.scan.PluginPathScanner;
import com.atlassian.stash.internal.plugin.scan.PluginPathScannerFactory;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.Multimaps;
import io.atlassian.fugue.Pair;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import org.apache.commons.lang3.LocaleUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class I18nClasspathScanner {
    private static final Logger log = LoggerFactory.getLogger(I18nClasspathScanner.class);
    private final PluginPathScannerFactory pluginPathScannerFactory;

    public I18nClasspathScanner(PluginPathScannerFactory pluginPathScannerFactory) {
        this.pluginPathScannerFactory = pluginPathScannerFactory;
    }

    public UnresolvedLocales<String> scanForMessages(Plugin plugin, Locale defaultLocale) {
        List<String> resources = I18nClasspathScanner.findResources(plugin);
        if (resources.isEmpty()) {
            log.trace("Skipping adding plugin {} - no i18n resources", (Object)plugin.getName());
            return new UnresolvedLocales<String>();
        }
        log.debug("Adding plugin {} with {}", (Object)plugin.getName(), resources);
        return I18nClasspathScanner.loadPropertiesLazy(plugin, defaultLocale, I18nClasspathScanner.scanForLocales(this.pluginPathScannerFactory.forPlugin(plugin), resources));
    }

    @VisibleForTesting
    static UnresolvedLocales<String> loadPropertiesLazy(Plugin plugin, Locale defaultLocale, Iterable<Pair<String, Optional<Locale>>> files) {
        ImmutableListMultimap perLocale = Multimaps.index(files, pair -> ((Optional)pair.right()).orElse(defaultLocale));
        log.trace("For plugin {} found the following {}", (Object)plugin, files);
        UnresolvedLocales.Builder builder = new UnresolvedLocales.Builder();
        for (Map.Entry localeFiles : perLocale.asMap().entrySet()) {
            builder.put((Locale)localeFiles.getKey(), () -> {
                try {
                    return I18nClasspathScanner.loadProperties(plugin, (Locale)localeFiles.getKey(), (Iterable<String>)Chainable.chain((Iterable)((Iterable)localeFiles.getValue())).transform(Pair::left));
                }
                catch (IOException e) {
                    log.error("Error loading locale from plugin {}", (Object)plugin, (Object)e);
                    return MessageMap.empty();
                }
            });
        }
        return builder.build();
    }

    @VisibleForTesting
    static Iterable<Pair<String, Optional<Locale>>> scanForLocales(PluginPathScanner pluginPathScanner, Collection<String> i18nResources) {
        ImmutableListMultimap dirsAndPaths = Multimaps.index(i18nResources, path -> {
            int index = (path = path.replaceAll("[\\.\\\\]", "/")).lastIndexOf(47) + 1;
            if (index == 0) {
                return "/";
            }
            return StringUtils.prependIfMissing((String)path.substring(0, index), (CharSequence)"/", (CharSequence[])new CharSequence[0]);
        });
        ArrayList<Pair<String, Optional<Locale>>> i18nFiles = new ArrayList<Pair<String, Optional<Locale>>>();
        for (Map.Entry entry : dirsAndPaths.asMap().entrySet()) {
            block1: for (String file : pluginPathScanner.getPaths((String)entry.getKey())) {
                for (String classpath : (Collection)entry.getValue()) {
                    Optional<Locale> locale = I18nClasspathScanner.getLocale(classpath.replace('.', '/'), file.substring(1));
                    if (locale == null) continue;
                    i18nFiles.add((Pair<String, Optional<Locale>>)Pair.pair((Object)file, locale));
                    continue block1;
                }
            }
        }
        return i18nFiles;
    }

    private static List<String> findResources(Plugin plugin) {
        return (List)plugin.getResourceDescriptors().stream().filter(new Resources.TypeFilterPredicate("i18n")).map(ResourceDescriptor::getLocation).collect(MoreCollectors.toImmutableList());
    }

    private static Optional<Locale> getLocale(String resource, String path) {
        if (path.startsWith(resource)) {
            char separator = path.charAt(resource.length());
            if (separator == '.') {
                return Optional.empty();
            }
            if (separator == '_') {
                String locale = path.substring(resource.length() + 1, path.lastIndexOf(46));
                try {
                    return Optional.of(LocaleUtils.toLocale((String)locale));
                }
                catch (IllegalArgumentException e) {
                    log.debug("Error in locale for {} file", (Object)path, (Object)e);
                }
            }
        }
        return null;
    }

    private static MessageMap<String> loadProperties(Plugin plugin, Locale locale, Iterable<String> files) throws IOException {
        MessageMap.Builder<String> builder = new MessageMap.Builder<String>();
        for (String pair : files) {
            Properties properties = new Properties();
            String path = pair.startsWith("/") ? pair.substring(1) : pair;
            try (InputStream in = plugin.getResourceAsStream(path);){
                properties.load(new InputStreamReader(in, StandardCharsets.UTF_8));
            }
            for (Map.Entry<Object, Object> e : properties.entrySet()) {
                builder.put(new MessageKey(e.getKey().toString(), locale), e.getValue().toString());
            }
        }
        return builder.build();
    }
}

