/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.i18n;

import com.atlassian.bitbucket.i18n.I18nKey;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.i18n.KeyedMessage;
import com.atlassian.bitbucket.util.Chainable;
import com.atlassian.plugin.event.PluginEventListener;
import com.atlassian.plugin.event.events.PluginDisabledEvent;
import com.atlassian.plugin.event.events.PluginEnabledEvent;
import com.atlassian.stash.internal.i18n.I18nClasspathScanner;
import com.atlassian.stash.internal.i18n.LocaleHolder;
import com.atlassian.stash.internal.i18n.cache.MessageCache;
import com.atlassian.stash.internal.i18n.cache.MessageLocaleMap;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Maps;
import jakarta.annotation.Nonnull;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PluginI18nService
implements I18nService {
    private static final Logger log = LoggerFactory.getLogger(PluginI18nService.class);
    private static final Locale defaultLocale = Locale.US;
    private final I18nClasspathScanner classpathScanner;
    private final LocaleHolder localeHolder;
    private final MessageCache<String, String> messageCache;

    public PluginI18nService(I18nClasspathScanner classpathScanner, LocaleHolder localeHolder) {
        this(classpathScanner, localeHolder, new MessageCache<String, String>());
    }

    @VisibleForTesting
    PluginI18nService(I18nClasspathScanner classpathScanner, LocaleHolder localeHolder, MessageCache<String, String> messageCache) {
        this.classpathScanner = classpathScanner;
        this.localeHolder = localeHolder;
        this.messageCache = messageCache;
    }

    @Nonnull
    public KeyedMessage createKeyedMessage(@Nonnull String key, Object ... arguments) {
        return this.getKeyedText(key, null, arguments);
    }

    @Nonnull
    public String getMessage(@Nonnull String key, Object ... arguments) {
        return this.getText(key, null, arguments);
    }

    @Nonnull
    public String getMessage(@Nonnull I18nKey key) {
        return this.getText(key.getKey(), null, key.getArguments());
    }

    @Nonnull
    public String getMessage(@Nonnull Locale locale, @Nonnull String key, Object ... arguments) {
        return this.getText(locale, key, null, arguments);
    }

    @Nonnull
    public Map<String, String> getAllTranslationsForPrefix(@Nonnull String prefix) {
        return this.getAllTranslationsForPrefix(prefix, this.localeHolder.getLocales(new Locale[0]));
    }

    @Nonnull
    public Map<String, String> getAllTranslationsForPrefix(@Nonnull String prefix, @Nonnull Locale locale) {
        return this.getAllTranslationsForPrefix(prefix, this.localeHolder.getLocales(new Locale[]{locale}));
    }

    @Nonnull
    public KeyedMessage getKeyedText(@Nonnull String key, String fallbackMessage, Object ... arguments) {
        Objects.requireNonNull(key, "key");
        return new KeyedMessage(key, this.getText(key, fallbackMessage, arguments), this.getText(defaultLocale, key, fallbackMessage, arguments));
    }

    @Nonnull
    public KeyedMessage getKeyedText(@Nonnull I18nKey i18nKey) {
        return this.createKeyedMessage(i18nKey.getKey(), i18nKey.getArguments());
    }

    public String getMessagePattern(@Nonnull String key) {
        return this.getMessagePattern(key, null);
    }

    public String getMessagePattern(@Nonnull String key, String fallbackPattern) {
        return this.getMessagePattern(this.localeHolder.getLocales(new Locale[0]), key, fallbackPattern);
    }

    public String getMessagePattern(@Nonnull Locale locale, @Nonnull String key) {
        return this.getMessagePattern(this.localeHolder.getLocales(new Locale[]{locale}), key, null);
    }

    @Nonnull
    public String getText(@Nonnull String key, String fallbackMessage, Object ... arguments) {
        return this.getText(this.localeHolder.getLocales(new Locale[0]), key, fallbackMessage, arguments);
    }

    @Nonnull
    public String getText(@Nonnull Locale locale, @Nonnull String key, String fallbackMessage, Object ... arguments) {
        return this.getText(this.localeHolder.getLocales(new Locale[]{locale}), key, fallbackMessage, arguments);
    }

    @PluginEventListener
    public void onPluginDisabled(PluginDisabledEvent event) {
        log.trace("Removing plugin {}", (Object)event.getPlugin().getName());
        this.messageCache.remove(event.getPlugin().getKey());
    }

    @PluginEventListener
    public void onPluginEnabled(PluginEnabledEvent event) {
        try {
            log.trace("Adding plugin {}", (Object)event.getPlugin().getName());
            this.messageCache.put(event.getPlugin().getKey(), this.classpathScanner.scanForMessages(event.getPlugin(), defaultLocale));
        }
        catch (Exception e) {
            log.error("Error loading i18n properties from plugin {}", (Object)event.getPlugin().getName(), (Object)e);
        }
    }

    private Map<String, String> getAllTranslationsForPrefix(String prefix, Iterable<Locale> locales) {
        HashMap translations = Maps.newHashMap();
        MessageLocaleMap<String> messages = this.messageCache.getMessages(locales);
        Set keys = Chainable.chain(messages.keySet()).filter(key -> StringUtils.startsWith((CharSequence)key, (CharSequence)prefix)).toSet();
        for (String key2 : keys) {
            String messageText = messages.get(key2);
            if (messageText == null) continue;
            translations.put(key2, messageText);
        }
        return translations;
    }

    private String getMessagePattern(Iterable<Locale> locales, String key, String fallbackPattern) {
        String messagePattern = this.messageCache.getMessages(locales).get(key);
        if (messagePattern == null) {
            log.debug("No values found in any valid locale for key {} and locales {}", (Object)key, locales);
        }
        return messagePattern == null ? fallbackPattern : messagePattern;
    }

    private String getText(@Nonnull Iterable<Locale> locales, @Nonnull String key, String fallbackMessage, Object ... arguments) {
        String messagePattern = this.getMessagePattern(Objects.requireNonNull(locales, "locales"), Objects.requireNonNull(key, "key"), fallbackMessage);
        String message = messagePattern != null ? MessageFormat.format(messagePattern, Objects.requireNonNull(arguments, "arguments")) : null;
        return message == null ? PluginI18nService.formatFallbackMessage(key, fallbackMessage, arguments) : message;
    }

    private static String formatFallbackMessage(String key, String fallbackMessage, Object[] arguments) {
        String message;
        if (fallbackMessage == null) {
            String string = message = key == null ? "(null)" : key;
            if (arguments != null && arguments.length > 0) {
                StringBuilder sb = new StringBuilder();
                sb.append(message);
                sb.append("[");
                String sep = "";
                for (Object argument : arguments) {
                    sb.append(sep);
                    sb.append(argument == null ? "(null)" : argument.toString());
                    sep = ", ";
                }
                sb.append("]");
                message = sb.toString();
            }
        } else {
            message = MessageFormat.format(fallbackMessage, arguments);
        }
        return message;
    }
}

