/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.i18n.cache;

import com.atlassian.stash.internal.i18n.cache.MessageLocaleMap;
import com.atlassian.stash.internal.i18n.cache.MessageMapIndex;
import com.atlassian.stash.internal.i18n.cache.UnresolvedLocales;
import com.google.common.base.Function;
import io.atlassian.util.concurrent.atomic.AtomicReference;
import jakarta.annotation.Nonnull;
import java.util.Locale;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class MessageCache<K, V> {
    private final AtomicReference<MessageMapIndex<K, V>> messagesRef = new AtomicReference(new MessageMapIndex());

    @Nonnull
    public MessageLocaleMap<V> getMessages(Iterable<Locale> locales) {
        return this.getOrLoadIndex(locales).getMessages(locales);
    }

    public void put(final K key, final UnresolvedLocales<V> locales) {
        this.messagesRef.update((java.util.function.Function)new Function<MessageMapIndex<K, V>, MessageMapIndex<K, V>>(){

            public MessageMapIndex<K, V> apply(MessageMapIndex<K, V> index) {
                return index.add(key, locales);
            }
        });
    }

    public void remove(final @Nonnull K key) {
        this.messagesRef.update((java.util.function.Function)new Function<MessageMapIndex<K, V>, MessageMapIndex<K, V>>(){

            public MessageMapIndex<K, V> apply(MessageMapIndex<K, V> state) {
                return state.remove(key);
            }
        });
    }

    private MessageMapIndex<K, V> getOrLoadIndex(final Iterable<Locale> locales) {
        MessageMapIndex index = (MessageMapIndex)this.messagesRef.get();
        if (!index.containsUnresolved(locales)) {
            return index;
        }
        return (MessageMapIndex)this.messagesRef.update((java.util.function.Function)new Function<MessageMapIndex<K, V>, MessageMapIndex<K, V>>(){

            public MessageMapIndex<K, V> apply(MessageMapIndex<K, V> index) {
                return index.loadAll(locales);
            }
        });
    }
}

