/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.idx;

import com.atlassian.bitbucket.commit.AbstractCommitCallback;
import com.atlassian.bitbucket.commit.Commit;
import com.atlassian.bitbucket.commit.CommitSummary;
import com.atlassian.bitbucket.commit.SimpleCommit;
import com.atlassian.bitbucket.user.Person;
import com.atlassian.bitbucket.user.SimplePerson;
import com.google.common.base.Preconditions;
import jakarta.annotation.Nonnull;
import java.util.Date;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class BlockingQueueCommitCallback
extends AbstractCommitCallback {
    private static final Logger log = LoggerFactory.getLogger(BlockingQueueCommitCallback.class);
    private static final Commit FINISHED = new SimpleCommit.Builder("finished").author((Person)new SimplePerson("user", "user@domain")).authorTimestamp(new Date()).displayId("finished").build();
    private final BlockingQueue<Commit> queue;
    private volatile boolean active;

    BlockingQueueCommitCallback(int queueSize) {
        Preconditions.checkArgument((queueSize > 0 ? 1 : 0) != 0);
        this.active = true;
        this.queue = new LinkedBlockingQueue<Commit>(queueSize);
    }

    public boolean onCommit(@Nonnull Commit commit) {
        try {
            while (this.active && !this.queue.offer(commit, 250L, TimeUnit.MILLISECONDS)) {
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            log.debug("Interrupted while waiting for space on the callback queue to become available", (Throwable)e);
            return false;
        }
        return this.active;
    }

    public void onEnd(@Nonnull CommitSummary summary) {
        try {
            if (!Thread.currentThread().isInterrupted()) {
                this.queue.offer(FINISHED);
            }
        }
        finally {
            this.active = false;
        }
    }

    void discard() {
        this.active = false;
        this.queue.clear();
    }

    Commit poll(long timeout, TimeUnit unit) throws InterruptedException {
        Commit result = this.active ? this.queue.poll(timeout, unit) : (Commit)this.queue.poll();
        return result == FINISHED ? null : result;
    }

    void reset() {
        this.queue.clear();
        this.active = true;
    }
}

