/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.idx;

import com.atlassian.bitbucket.concurrent.BucketProcessor;
import com.atlassian.bitbucket.concurrent.BucketedExecutor;
import com.atlassian.bitbucket.concurrent.BucketedExecutorSettings;
import com.atlassian.bitbucket.concurrent.ConcurrencyPolicy;
import com.atlassian.bitbucket.concurrent.ConcurrencyService;
import com.atlassian.bitbucket.event.repository.RepositoryImportedEvent;
import com.atlassian.bitbucket.event.repository.RepositoryRefsChangedEvent;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.event.api.EventListener;
import com.atlassian.stash.internal.idx.HierarchyIndexer;
import com.atlassian.stash.internal.idx.HierarchyIndexingRequest;
import com.atlassian.stash.internal.mode.DefaultApplicationMode;
import jakarta.annotation.PreDestroy;
import java.io.Serializable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
@DefaultApplicationMode
public class CommitIndexingScheduler {
    private static final Logger log = LoggerFactory.getLogger(CommitIndexingScheduler.class);
    private final BucketedExecutor<HierarchyIndexingRequest> executorDefault;
    private final BucketedExecutor<HierarchyIndexingRequest> executorImport;

    @Autowired
    public CommitIndexingScheduler(ConcurrencyService concurrencyService, HierarchyIndexer hierarchyIndexer, @Value(value="${indexing.max.threads}") int maxConcurrency, @Value(value="${indexing.import.max.threads}") int maxConcurrencyImport) {
        this.executorDefault = concurrencyService.getBucketedExecutor("commit-indexing", new BucketedExecutorSettings.Builder(HierarchyIndexingRequest.BUCKET_EXTRACTOR, (BucketProcessor)hierarchyIndexer).maxConcurrency(maxConcurrency, ConcurrencyPolicy.PER_NODE).build());
        this.executorImport = concurrencyService.getBucketedExecutor("commit-indexing-import", new BucketedExecutorSettings.Builder(HierarchyIndexingRequest.BUCKET_EXTRACTOR, (BucketProcessor)hierarchyIndexer).maxConcurrency(maxConcurrencyImport, ConcurrencyPolicy.PER_NODE).build());
    }

    @EventListener
    public void onRefsChanged(RepositoryRefsChangedEvent event) {
        Repository repository = event.getRepository();
        if (event.getRefChanges().isEmpty()) {
            log.debug("{}: Skipping indexing; no refs were changed (Remotely-merged pull request?)", (Object)repository);
        } else {
            this.executorDefault.submit((Serializable)new HierarchyIndexingRequest(repository));
        }
    }

    @EventListener
    public void onRepositoryImportedEvent(RepositoryImportedEvent event) {
        this.executorImport.submit((Serializable)new HierarchyIndexingRequest(event.getRepository()));
    }

    @PreDestroy
    public void shutdown() {
        this.executorDefault.shutdown();
        this.executorImport.shutdown();
    }
}

