/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.idx;

import com.atlassian.bitbucket.commit.Commit;
import com.atlassian.bitbucket.commit.MinimalRepositoryCommit;
import com.atlassian.bitbucket.commit.NoSuchCommitException;
import com.atlassian.bitbucket.commit.SimpleMinimalRepositoryCommit;
import com.atlassian.bitbucket.dmz.idx.DmzCommitIndex;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.idx.CommitIndex;
import com.atlassian.bitbucket.idx.IndexSearchRequest;
import com.atlassian.bitbucket.idx.IndexedCommit;
import com.atlassian.bitbucket.permission.PermissionPredicateFactory;
import com.atlassian.bitbucket.permission.PermissionService;
import com.atlassian.bitbucket.project.ProjectType;
import com.atlassian.bitbucket.property.PropertyMap;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.util.Page;
import com.atlassian.bitbucket.util.PageRequest;
import com.atlassian.bitbucket.util.PageUtils;
import com.atlassian.bitbucket.util.Timer;
import com.atlassian.bitbucket.util.TimerUtils;
import com.atlassian.plugin.spring.AvailableToPlugins;
import com.atlassian.stash.internal.InternalConverter;
import com.atlassian.stash.internal.content.IndexedCommitDao;
import com.atlassian.stash.internal.idx.InternalIndexedCommit;
import com.google.common.collect.Iterables;
import jakarta.annotation.Nonnull;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@AvailableToPlugins(interfaces={CommitIndex.class, DmzCommitIndex.class})
@Component(value="commitIndex")
@Transactional(readOnly=true)
public class DefaultCommitIndex
implements DmzCommitIndex {
    private static final int MIN_FILTER_LENGTH = 7;
    private final Predicate<Repository> canReadRepositoryPredicate;
    private final IndexedCommitDao commitDao;
    private final I18nService i18nService;
    private final PermissionService permissionService;
    @Value(value="${page.max.index.results}")
    private int maxIndexResults;

    @Autowired
    public DefaultCommitIndex(IndexedCommitDao commitDao, I18nService i18nService, PermissionPredicateFactory predicateFactory, PermissionService permissionService) {
        this.canReadRepositoryPredicate = predicateFactory.createRepositoryAccessiblePredicate();
        this.commitDao = commitDao;
        this.i18nService = i18nService;
        this.permissionService = permissionService;
    }

    @Transactional
    public void addCommit(@Nonnull Commit commit, @Nonnull Repository repository) {
        Objects.requireNonNull(commit, "commit");
        Objects.requireNonNull(repository, "repository");
        InternalIndexedCommit indexedCommit = (InternalIndexedCommit)this.commitDao.getById((Object)commit.getId());
        if (indexedCommit == null) {
            indexedCommit = new InternalIndexedCommit(commit.getId(), commit.getAuthorTimestamp());
            this.commitDao.create((Object)indexedCommit);
        }
        if (!DefaultCommitIndex.isPersonalFork(repository)) {
            this.commitDao.addMembership(indexedCommit, InternalConverter.convertToInternalRepository((Repository)repository));
        }
    }

    @Transactional
    public boolean addProperty(@Nonnull String commitId, @Nonnull String key, @Nonnull String value) {
        Objects.requireNonNull(commitId, "commitId");
        Objects.requireNonNull(key, "key");
        Objects.requireNonNull(value, "value");
        InternalIndexedCommit indexedCommit = (InternalIndexedCommit)this.commitDao.getById((Object)commitId);
        if (indexedCommit == null) {
            throw new NoSuchCommitException(this.i18nService.createKeyedMessage("bitbucket.service.commitindex.commitnotfound", new Object[]{commitId}), commitId);
        }
        return this.commitDao.addProperty(indexedCommit, key, value);
    }

    @Nonnull
    public Page<IndexedCommit> findByProperty(@Nonnull String propertyKey, @Nonnull String propertyValue, boolean caseSensitive, @Nonnull PageRequest pageRequest) {
        Objects.requireNonNull(propertyKey, "propertyKey");
        Objects.requireNonNull(propertyValue, "propertyValue");
        pageRequest = Objects.requireNonNull(pageRequest, "pageRequest").buildRestrictedPageRequest(this.maxIndexResults);
        try (Timer ignored = TimerUtils.start((String)String.format("Commit Index: Find at most %s commits visible to the user where property '%s' is '%s' (case-sensitive: %s)", pageRequest.getLimit(), propertyKey, propertyValue, caseSensitive));){
            Page page = PageUtils.asPageOf(IndexedCommit.class, (Page)this.commitDao.findByPropertyWithRepository(propertyKey, propertyValue, caseSensitive, pageRequest, this.cachingPredicate(arg_0 -> ((PermissionService)this.permissionService).isRepositoryAccessible(arg_0))));
            return page;
        }
    }

    @Nonnull
    public Page<IndexedCommit> findByPropertyUnauthenticated(@Nonnull String propertyKey, @Nonnull String propertyValue, boolean caseSensitive, @Nonnull PageRequest pageRequest) {
        Objects.requireNonNull(propertyKey, "propertyKey");
        Objects.requireNonNull(propertyValue, "propertyValue");
        pageRequest = Objects.requireNonNull(pageRequest, "pageRequest").buildRestrictedPageRequest(this.maxIndexResults);
        try (Timer ignored = TimerUtils.start((String)String.format("Commit Index: Find at most %s commits where property '%s' is '%s' (case-sensitive: %s)", pageRequest.getLimit(), propertyKey, propertyValue, caseSensitive));){
            Page page = PageUtils.asPageOf(IndexedCommit.class, (Page)this.commitDao.findByProperty(propertyKey, propertyValue, caseSensitive, pageRequest));
            return page;
        }
    }

    public IndexedCommit getCommit(@Nonnull String commitId) {
        Objects.requireNonNull(commitId, "commitId");
        IndexedCommit commit = (IndexedCommit)this.commitDao.getById((Object)commitId);
        if (commit != null) {
            if (Iterables.any((Iterable)commit.getRepositories(), this.canReadRepositoryPredicate::test)) {
                return commit;
            }
        }
        return null;
    }

    @Nonnull
    public PropertyMap getProperties(@Nonnull String commitId, @Nonnull Iterable<String> propertyKeys) {
        Objects.requireNonNull(commitId, "commitId");
        Objects.requireNonNull(propertyKeys, "propertyKeys");
        return this.commitDao.getProperties(commitId, propertyKeys);
    }

    @Nonnull
    public Map<String, PropertyMap> getProperties(@Nonnull Iterable<String> commitIds, @Nonnull Iterable<String> propertyKeys) {
        Objects.requireNonNull(commitIds, "commitIds");
        Objects.requireNonNull(propertyKeys, "propertyKeys");
        return this.commitDao.getProperties(commitIds, propertyKeys);
    }

    public boolean isIndexed(@Nonnull String commitId, @Nonnull Repository repository) {
        Objects.requireNonNull(commitId, "commitId");
        Objects.requireNonNull(repository, "repository");
        return this.canReadRepositoryPredicate.test(repository) && this.commitDao.isIndexed(commitId, InternalConverter.convertToInternalRepository((Repository)repository));
    }

    @Transactional
    public void removeCommit(@Nonnull String commitId, @Nonnull Repository repository) {
        Objects.requireNonNull(commitId, "commitId");
        Objects.requireNonNull(repository, "repository");
        this.commitDao.deleteMembership(commitId, InternalConverter.convertToInternalRepository((Repository)repository));
    }

    @Transactional
    public void removeProperty(@Nonnull String commitId, @Nonnull String key, @Nonnull String value) {
        Objects.requireNonNull(commitId, "commitId");
        Objects.requireNonNull(key, "key");
        Objects.requireNonNull(value, "value");
        this.commitDao.removeProperty(commitId, key, value);
    }

    @Nonnull
    public Page<IndexedCommit> search(@Nonnull IndexSearchRequest searchRequest, @Nonnull PageRequest pageRequest) {
        Objects.requireNonNull(searchRequest, "searchRequest");
        Objects.requireNonNull(pageRequest, "pageRequest");
        return PageUtils.asPageOf(IndexedCommit.class, (Page)this.commitDao.search(searchRequest, pageRequest));
    }

    @Nonnull
    public Page<MinimalRepositoryCommit> searchRepositoryCommits(@Nonnull IndexSearchRequest indexSearchRequest, @Nonnull PageRequest pageRequest) throws IllegalArgumentException {
        Objects.requireNonNull(indexSearchRequest, "indexSearchRequest");
        Objects.requireNonNull(pageRequest, "pageRequest");
        String filter = Objects.requireNonNull(indexSearchRequest.getFilter(), "filter");
        if (filter.length() < 7) {
            throw new IllegalArgumentException(String.format("Provided filter '%s' is too short. Must be at least %d characters long.", filter, 7));
        }
        Page membershipPage = this.commitDao.searchMemberships(filter, pageRequest, membership -> this.canReadRepositoryPredicate.test((Repository)membership.getRepository()));
        return membershipPage.transform(membership -> new SimpleMinimalRepositoryCommit.Builder(membership.getCommit().getId()).repository((Repository)membership.getRepository()).build());
    }

    private Predicate<Integer> cachingPredicate(Predicate<Integer> predicate) {
        HashMap permissionCache = new HashMap();
        return repoId -> permissionCache.computeIfAbsent(repoId, predicate::test);
    }

    private static boolean isPersonalFork(Repository repository) {
        return repository.isFork() && repository.getProject().getType() == ProjectType.PERSONAL;
    }
}

