/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.idx;

import com.atlassian.bitbucket.idx.IndexingContext;
import com.atlassian.bitbucket.repository.Repository;
import jakarta.annotation.Nonnull;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class DefaultIndexingContext
implements IndexingContext {
    private final Map<String, Object> propertyMap;
    private final Repository repository;

    public DefaultIndexingContext(@Nonnull Repository repository) {
        this.repository = Objects.requireNonNull(repository, "repository");
        this.propertyMap = new HashMap<String, Object>();
    }

    public <T> T get(String key) {
        return (T)this.propertyMap.get(key);
    }

    @Nonnull
    public Repository getRepository() {
        return this.repository;
    }

    public Object put(String key, Object value) {
        return this.propertyMap.put(key, value);
    }

    public Object remove(String key) {
        return this.propertyMap.remove(key);
    }

    public String toString() {
        return "DefaultIndexingContext{repository=" + String.valueOf(this.repository) + ", propertyMap=" + String.valueOf(this.propertyMap) + "}";
    }
}

