/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.idx;

import com.atlassian.bitbucket.NoSuchResourceException;
import com.atlassian.bitbucket.event.repository.RepositoryDeletedEvent;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.scm.Command;
import com.atlassian.bitbucket.scm.RefsCommandParameters;
import com.atlassian.bitbucket.scm.ScmService;
import com.atlassian.bitbucket.util.MoreCollectors;
import com.atlassian.bitbucket.util.MoreFiles;
import com.atlassian.event.api.EventListener;
import com.atlassian.stash.internal.HomeLayout;
import com.atlassian.stash.internal.idx.RepositorySnapshotService;
import com.google.common.collect.ImmutableSet;
import jakarta.annotation.Nonnull;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.DependsOn;
import org.springframework.stereotype.Service;

@DependsOn(value={"moveSnapshotDirUpgradeTask"})
@Service(value="repositorySnapshotService")
public class FileSystemRepositorySnapshotService
implements RepositorySnapshotService {
    public static final String SNAPSHOTS_PATH = "snapshots";
    public static final long TIMEOUT_DEFAULT = TimeUnit.MINUTES.toMillis(2L);
    public static final long TIMEOUT_MINIMUM = TimeUnit.MINUTES.toMillis(1L);
    static final RefsCommandParameters REFS_PARAMETERS = new RefsCommandParameters.Builder().build();
    private static final Logger log = LoggerFactory.getLogger(FileSystemRepositorySnapshotService.class);
    private final I18nService i18nService;
    private final ScmService scmService;
    private final Path snapshotDir;
    private long executionTimeout;
    private long idleTimeout;

    @Autowired
    public FileSystemRepositorySnapshotService(HomeLayout homeLayout, I18nService i18nService, ScmService scmService) {
        this.i18nService = i18nService;
        this.scmService = scmService;
        this.executionTimeout = TIMEOUT_DEFAULT;
        this.idleTimeout = TIMEOUT_DEFAULT;
        this.snapshotDir = MoreFiles.mkdir((Path)homeLayout.getDataDir(), (String)SNAPSHOTS_PATH);
    }

    @Override
    public Iterable<String> create(@Nonnull Repository repository, @Nonnull Long timestamp) {
        Objects.requireNonNull(repository, "repository");
        Objects.requireNonNull(timestamp, "timestamp");
        Path snapshotFile = this.getSnapshotFile(repository, timestamp);
        try {
            ArrayList heads = new ArrayList(1000);
            Command command = this.scmService.getCommandFactory(repository).refs(REFS_PARAMETERS, ref -> {
                heads.add(ref.getLatestCommit());
                return true;
            });
            command.setExecutionTimeout(this.executionTimeout);
            command.setIdleTimeout(this.idleTimeout);
            command.call();
            ImmutableSet uniqueHeads = ImmutableSet.copyOf(heads);
            Files.write(snapshotFile, (Iterable<? extends CharSequence>)uniqueHeads, StandardCharsets.UTF_8, new OpenOption[0]);
            return uniqueHeads;
        }
        catch (IOException e) {
            throw new RuntimeException("Could not write snapshot file [" + String.valueOf(snapshotFile.toAbsolutePath()) + "]", e);
        }
    }

    @Override
    public void deleteByRepository(@Nonnull Repository repository) {
        Objects.requireNonNull(repository, "repository");
        try {
            MoreFiles.deleteRecursively((Path)this.getSnapshotDir(repository));
        }
        catch (IOException e) {
            throw new RuntimeException("Error deleting the snapshot files for repository " + repository.getName(), e);
        }
    }

    @Override
    @Nonnull
    public Iterable<String> getByRepository(@Nonnull Repository repository, Long timestamp) {
        Objects.requireNonNull(repository, "repository");
        if (timestamp == null) {
            return Collections.emptySet();
        }
        Path snapshotFile = this.getSnapshotFile(repository, timestamp);
        try {
            return Files.readAllLines(snapshotFile, StandardCharsets.UTF_8);
        }
        catch (FileNotFoundException | NoSuchFileException e) {
            throw new NoSuchResourceException(this.i18nService.createKeyedMessage("bitbucket.service.repositorysnapshot.snapshotfilenotfound", new Object[0]), snapshotFile.getFileName().toString());
        }
        catch (IOException e) {
            throw new RuntimeException("Could not read snapshot file [" + String.valueOf(snapshotFile.toAbsolutePath()) + "]", e);
        }
    }

    @EventListener
    public void onRepositoryDeleted(RepositoryDeletedEvent event) {
        this.deleteByRepository(event.getRepository());
    }

    @Override
    public void pruneByRepository(@Nonnull Repository repository, @Nonnull Set<Long> timestampsToKeep) {
        Objects.requireNonNull(repository, "repository");
        Objects.requireNonNull(timestampsToKeep, "timestampsToKeep");
        Set snapshotFilesToKeep = (Set)timestampsToKeep.stream().map(value -> Long.toString(value)).collect(MoreCollectors.toImmutableSet());
        Path snapshotDir = this.getSnapshotDir(repository);
        try (Stream<Path> snapshots = Files.list(snapshotDir);){
            snapshots.forEach(snapshot -> {
                String name = snapshot.getFileName().toString();
                if (snapshotFilesToKeep.contains(name)) {
                    return;
                }
                try {
                    Files.delete(snapshot);
                }
                catch (IOException e) {
                    log.warn("{}: Snapshot {} could not be deleted", new Object[]{repository, name, e});
                }
            });
        }
        catch (IOException | UncheckedIOException e) {
            log.warn("{}: Failed to list snapshots for pruning", (Object)repository, (Object)e);
        }
    }

    @Value(value="${indexing.snapshot.timeout.execution}")
    public void setExecutionTimeout(long executionTimeout) {
        this.executionTimeout = Math.max(TimeUnit.SECONDS.toMillis(executionTimeout), TIMEOUT_MINIMUM);
    }

    @Value(value="${indexing.snapshot.timeout.idle}")
    public void setIdleTimeout(long idleTimeout) {
        this.idleTimeout = Math.max(TimeUnit.SECONDS.toMillis(idleTimeout), TIMEOUT_MINIMUM);
    }

    private Path getSnapshotDir(Repository repository) {
        return MoreFiles.mkdir((Path)this.snapshotDir, (String)String.valueOf(repository.getId()));
    }

    private Path getSnapshotFile(Repository repository, long timestamp) {
        return this.getSnapshotDir(repository).resolve(String.valueOf(timestamp));
    }
}

