/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.idx;

import com.atlassian.bitbucket.concurrent.BucketProcessor;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.repository.RepositoryService;
import com.atlassian.bitbucket.user.EscalatedSecurityContext;
import com.atlassian.bitbucket.user.SecurityService;
import com.atlassian.bitbucket.util.Operation;
import com.atlassian.bitbucket.util.UncheckedOperation;
import com.atlassian.stash.internal.idx.CommitIndexingService;
import com.atlassian.stash.internal.idx.HierarchyIndexingRequest;
import jakarta.annotation.Nonnull;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class HierarchyIndexer
implements BucketProcessor<HierarchyIndexingRequest> {
    private static final Logger log = LoggerFactory.getLogger(HierarchyIndexer.class);
    private final CommitIndexingService indexingService;
    private final RepositoryService repositoryService;
    private final EscalatedSecurityContext withRepoRead;

    @Autowired
    public HierarchyIndexer(CommitIndexingService indexingService, RepositoryService repositoryService, SecurityService securityService) {
        this.indexingService = indexingService;
        this.repositoryService = repositoryService;
        this.withRepoRead = securityService.withPermission(Permission.REPO_READ, "Commit indexing");
    }

    public void process(@Nonnull String hierarchyId, final @Nonnull List<HierarchyIndexingRequest> requests) {
        this.withRepoRead.call((Operation)new UncheckedOperation<Object>(){

            public Void perform() {
                for (HierarchyIndexingRequest request : requests) {
                    Repository repository = HierarchyIndexer.this.repositoryService.getById(request.getRepositoryId());
                    if (repository == null) {
                        log.info("[{}] Skipping indexing; it appears the repository has been deleted", (Object)request.getRepositoryId());
                        continue;
                    }
                    if (repository.getState() == Repository.State.OFFLINE) {
                        log.debug("[{}] Skipping indexing; the repository is offline", (Object)repository);
                        continue;
                    }
                    try {
                        HierarchyIndexer.this.indexingService.indexRepository(repository);
                    }
                    catch (Throwable t) {
                        if (HierarchyIndexer.this.indexingService.isActive()) {
                            log.error("[{}] Indexing failed", (Object)repository, (Object)t);
                            continue;
                        }
                        log.info("[{}] Indexing was aborted", (Object)repository);
                    }
                }
                return null;
            }
        });
    }
}

