/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.idx.upgrade;

import com.atlassian.bitbucket.util.MoreFiles;
import com.atlassian.stash.internal.HomeLayout;
import com.atlassian.stash.internal.upgrade.UpgradeTask;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.file.DeleteOption;
import org.apache.commons.io.file.PathUtils;
import org.apache.commons.io.file.StandardDeleteOption;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="moveSnapshotDirUpgradeTask")
@UpgradeTask(value="core-idx-snapshots")
public class MoveSnapshotDirUpgradeTask
implements InitializingBean {
    public static final String KEY_TASK = "core-idx-snapshots";
    private static final Logger log = LoggerFactory.getLogger(MoveSnapshotDirUpgradeTask.class);
    private static final String PATH_IDX_SNAPSHOTS = "idx-snapshots";
    private final HomeLayout homeLayout;

    @Autowired
    public MoveSnapshotDirUpgradeTask(HomeLayout homeLayout) {
        this.homeLayout = homeLayout;
    }

    public void afterPropertiesSet() throws Exception {
        File markerFile = this.homeLayout.getUpgradesDir().resolve(KEY_TASK).toFile();
        if (markerFile.exists()) {
            log.debug("Skipping upgrade task to move the repository snapshots as this has already been completed");
            return;
        }
        this.upgrade();
        Files.touch((File)markerFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void upgrade() {
        File previousSnapshotDir;
        File snapshotDir;
        block16: {
            snapshotDir = this.homeLayout.getDataDir().resolve("snapshots").toFile();
            previousSnapshotDir = this.homeLayout.getCacheDir().resolve(PATH_IDX_SNAPSHOTS).toFile();
            if (!previousSnapshotDir.exists()) {
                com.atlassian.bitbucket.util.FileUtils.mkdir((File)snapshotDir);
                return;
            }
            try {
                if (snapshotDir.exists()) {
                    log.warn("Cannot move snapshots from {}: {} already exists", (Object)previousSnapshotDir, (Object)snapshotDir);
                    return;
                }
                if (this.renameTo(snapshotDir, previousSnapshotDir)) break block16;
                log.warn("Failed to move {} to {}. Will attempt to copy and delete", (Object)previousSnapshotDir, (Object)snapshotDir);
                com.atlassian.bitbucket.util.FileUtils.mkdir((File)snapshotDir);
                try {
                    FileUtils.copyDirectory((File)previousSnapshotDir, (File)snapshotDir);
                }
                catch (IOException e) {
                    log.error("Error while moving {} to {}. Repository snapshots will be regenerated", new Object[]{previousSnapshotDir, snapshotDir, e});
                    try {
                        PathUtils.cleanDirectory((Path)snapshotDir.toPath(), (DeleteOption[])new DeleteOption[]{StandardDeleteOption.OVERRIDE_READ_ONLY});
                    }
                    catch (IOException e1) {
                        log.error("Error while cleaning {}", (Object)previousSnapshotDir, (Object)e);
                    }
                }
            }
            finally {
                try {
                    MoreFiles.deleteRecursively((Path)previousSnapshotDir.toPath());
                }
                catch (IOException e1) {
                    log.error("Error while deleting {}", (Object)previousSnapshotDir, (Object)e1);
                }
            }
        }
        log.info("Successfully moved {} to {}", (Object)previousSnapshotDir, (Object)snapshotDir);
    }

    @VisibleForTesting
    boolean renameTo(File snapshotDir, File previousSnapshotDir) {
        return previousSnapshotDir.renameTo(snapshotDir);
    }
}

