/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.integrity;

import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.scm.integrity.IntegrityCheckContext;
import jakarta.annotation.Nonnull;
import java.util.Map;
import java.util.Objects;
import java.util.OptionalLong;
import java.util.stream.Stream;

public class DefaultIntegrityCheckContext
implements IntegrityCheckContext {
    private final Stream<Repository> repositories;
    private final Map<Integer, Long> repositoryIdToHighestPullRequestId;

    public DefaultIntegrityCheckContext(Stream<Repository> repositories, Map<Integer, Long> repositoryIdToHighestPullRequestId) {
        this.repositories = repositories;
        this.repositoryIdToHighestPullRequestId = repositoryIdToHighestPullRequestId;
    }

    @Nonnull
    public OptionalLong getLatestPullRequestId(@Nonnull Repository repository) {
        Long highestUsedPrId = this.repositoryIdToHighestPullRequestId.get(Objects.requireNonNull(repository, "repository").getId());
        if (highestUsedPrId == null) {
            return OptionalLong.empty();
        }
        return OptionalLong.of(highestUsedPrId);
    }

    @Nonnull
    public Stream<Repository> getRepositories() {
        return this.repositories;
    }
}

