/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.integrity;

import com.atlassian.bitbucket.cluster.ClusterNode;
import com.atlassian.bitbucket.cluster.ClusterService;
import com.atlassian.bitbucket.util.MoreCollectors;
import com.atlassian.stash.internal.integrity.ApplicationIntegrityDao;
import com.atlassian.stash.internal.integrity.IntegrityCheckEventService;
import com.atlassian.stash.internal.integrity.IntegrityEventKey;
import com.atlassian.stash.internal.integrity.InternalIntegrityEvent;
import com.atlassian.stash.internal.spring.SpringTransactionUtils;
import jakarta.annotation.Nonnull;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionCallbackWithoutResult;
import org.springframework.transaction.support.TransactionTemplate;

@Service(value="integrityCheckEventService")
public class DefaultIntegrityCheckEventService
implements IntegrityCheckEventService {
    private static final Logger log = LoggerFactory.getLogger(DefaultIntegrityCheckEventService.class);
    private final ClusterService clusterService;
    private final ApplicationIntegrityDao integrityDao;
    private final TransactionTemplate transactionTemplate;

    @Autowired
    public DefaultIntegrityCheckEventService(ApplicationIntegrityDao integrityDao, ClusterService clusterService, PlatformTransactionManager transactionManager) {
        this.integrityDao = integrityDao;
        this.clusterService = clusterService;
        this.transactionTemplate = new TransactionTemplate(transactionManager, SpringTransactionUtils.REQUIRES_NEW);
    }

    @Nonnull
    @PreAuthorize(value="hasGlobalPermission('SYS_ADMIN')")
    @Transactional(readOnly=true)
    public List<IntegrityEventKey> getLatest(int limit) {
        return (List)this.integrityDao.getLatestEvents(limit).stream().map(InternalIntegrityEvent::getKey).collect(MoreCollectors.toImmutableList());
    }

    @PreAuthorize(value="hasGlobalPermission('SYS_ADMIN')")
    public void markCheckFoundInconsistency() {
        log.info("Auto-integrity checking found an inconsistency");
        this.recordEvent(IntegrityEventKey.INCONSISTENCY);
    }

    @PreAuthorize(value="hasGlobalPermission('SYS_ADMIN')")
    public void markCheckResultAcknowledged() {
        log.info("Auto-integrity check results acknowledged by user");
        this.recordEvent(IntegrityEventKey.ACKNOWLEDGED);
    }

    @PreAuthorize(value="hasGlobalPermission('SYS_ADMIN')")
    public void markFullCheckCompletedLocally() {
        log.info("Auto-integrity checks complete");
        this.recordEvent(IntegrityEventKey.COMPLETED);
    }

    @PreAuthorize(value="hasGlobalPermission('SYS_ADMIN')")
    public boolean markFullCheckStartedLocally() {
        if (this.recordEventIfFirstClusterNode(IntegrityEventKey.STARTED)) {
            log.info("Auto-integrity checks started");
            return true;
        }
        return false;
    }

    @PreAuthorize(value="hasGlobalPermission('SYS_ADMIN')")
    public void markCheckStartedLocally() {
        this.recordEvent(IntegrityEventKey.STARTED);
        log.info("Import integrity checks started");
    }

    private boolean clusterNodeExists(String nodeVmId) {
        return this.clusterService.getInformation().getNodes().stream().map(ClusterNode::getVmId).anyMatch(vmId -> vmId.equals(nodeVmId));
    }

    private void recordEvent(final @Nonnull IntegrityEventKey key) {
        final String nodeVmId = this.clusterService.getInformation().getLocalNode().getVmId();
        int tries = 1;
        while (true) {
            try {
                this.transactionTemplate.execute((TransactionCallback)new TransactionCallbackWithoutResult(){

                    protected void doInTransactionWithoutResult(TransactionStatus status) {
                        DefaultIntegrityCheckEventService.this.integrityDao.setTimestamp(key, nodeVmId);
                    }
                });
            }
            catch (DataIntegrityViolationException e) {
                if (tries >= 2) {
                    throw e;
                }
                ++tries;
                continue;
            }
            break;
        }
    }

    private boolean recordEventIfFirstClusterNode(@Nonnull IntegrityEventKey key) {
        String nodeVmId = this.clusterService.getInformation().getLocalNode().getVmId();
        try {
            return (Boolean)this.transactionTemplate.execute(status -> {
                InternalIntegrityEvent event = (InternalIntegrityEvent)this.integrityDao.getById((Object)key);
                if (event == null) {
                    this.integrityDao.createWithTimestamp(key, nodeVmId);
                    return true;
                }
                if (!this.clusterNodeExists(event.getNode())) {
                    return this.integrityDao.updateTimestampIfSameNode(key, event.getNode(), nodeVmId);
                }
                log.info("Integrity checks not {} on this node, node {} has already {} them", new Object[]{key, event.getNode(), key});
                return false;
            });
        }
        catch (DataIntegrityViolationException e) {
            log.info("Integrity checks not {} on this node, database insert failed", (Object)key);
            log.debug("Exception", (Throwable)e);
            return false;
        }
    }
}

