/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.integrity;

import com.atlassian.stash.internal.integrity.IntegrityCheckEventService;
import com.atlassian.stash.internal.integrity.IntegrityCheckReporter;
import jakarta.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DefaultIntegrityCheckReporter
implements IntegrityCheckReporter {
    private static final Logger log = LoggerFactory.getLogger(DefaultIntegrityCheckReporter.class);
    private final IntegrityCheckEventService checkEventService;

    @Autowired
    public DefaultIntegrityCheckReporter(IntegrityCheckEventService checkEventService) {
        this.checkEventService = checkEventService;
    }

    public void complete() {
        log.info("Integrity checking complete");
        this.checkEventService.markFullCheckCompletedLocally();
    }

    public void debug(@Nonnull String message, Object ... objects) {
        log.debug(message, objects);
    }

    public void error(@Nonnull String message, Object ... objects) {
        log.error(message, objects);
    }

    public void inconsistency(String message, Object ... objects) {
        this.checkEventService.markCheckFoundInconsistency();
        this.warning(message, objects);
    }

    public void info(@Nonnull String message, Object ... objects) {
        log.info(message, objects);
    }

    public boolean startedFull() {
        log.info("Started full integrity checking");
        return this.checkEventService.markFullCheckStartedLocally();
    }

    public void startedForImport() {
        this.checkEventService.markCheckStartedLocally();
    }

    public void warning(@Nonnull String message, Object ... objects) {
        log.warn(message, objects);
    }
}

