/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.integrity;

import com.atlassian.bitbucket.avatar.AvatarSupplier;
import com.atlassian.bitbucket.pull.PullRequestState;
import com.atlassian.bitbucket.repository.RefService;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.scm.ScmService;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.bitbucket.user.SecurityService;
import com.atlassian.bitbucket.user.ServiceUser;
import com.atlassian.bitbucket.user.ServiceUserCreateRequest;
import com.atlassian.bitbucket.user.UserAdminService;
import com.atlassian.bitbucket.util.MoreCollectors;
import com.atlassian.bitbucket.util.Page;
import com.atlassian.bitbucket.util.PageRequest;
import com.atlassian.bitbucket.util.PageUtils;
import com.atlassian.stash.internal.InternalConverter;
import com.atlassian.stash.internal.activity.IntegrityCheckMergeActivity;
import com.atlassian.stash.internal.annotation.Profiled;
import com.atlassian.stash.internal.avatar.ResourceAvatarSupplier;
import com.atlassian.stash.internal.integrity.IntegrityCheckReporter;
import com.atlassian.stash.internal.integrity.IntegrityCheckService;
import com.atlassian.stash.internal.integrity.PullRequestIntegrityCheckRequest;
import com.atlassian.stash.internal.integrity.PullRequestIntegrityHelper;
import com.atlassian.stash.internal.integrity.RepositoryIntegrityHelper;
import com.atlassian.stash.internal.mode.DefaultApplicationMode;
import com.atlassian.stash.internal.pull.InternalPullRequest;
import com.atlassian.stash.internal.pull.InternalPullRequestService;
import com.atlassian.stash.internal.pull.PullRequestActivityDao;
import com.atlassian.stash.internal.pull.PullRequestDao;
import com.atlassian.stash.internal.pull.PullRequestSearchCriteria;
import com.atlassian.stash.internal.pull.rescope.PullRequestRescopeScheduler;
import com.atlassian.stash.internal.repository.RepositoryDao;
import com.atlassian.stash.internal.spring.SpringTransactionUtils;
import com.atlassian.stash.internal.user.InternalApplicationUser;
import com.atlassian.stash.internal.user.InternalUserService;
import com.google.common.base.Suppliers;
import jakarta.annotation.Nonnull;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.support.TransactionTemplate;

@DefaultApplicationMode
@Profiled
@Service(value="integrityCheckService")
public class DefaultIntegrityCheckService
implements IntegrityCheckService {
    private static final int DEFAULT_BATCH_SIZE = 1000;
    private static final int DEFAULT_PR_ACTIVITY_WINDOW_DAYS = 7;
    private final IntegrityCheckReporter checkReporter;
    private final PullRequestActivityDao pullRequestActivityDao;
    private final PullRequestDao pullRequestDao;
    private final PullRequestIntegrityHelper pullRequestIntegrityHelper;
    private final RepositoryDao repositoryDao;
    private final RepositoryIntegrityHelper repositoryIntegrityHelper;
    private final PullRequestRescopeScheduler rescopeScheduler;
    private final TransactionTemplate transactionTemplate;
    private final UserAdminService userAdminService;
    private final InternalUserService userService;
    private final Supplier<InternalApplicationUser> userSupplier;
    private int batchSize;
    private long defaultPrActivityWindow;

    @Autowired
    public DefaultIntegrityCheckService(IntegrityCheckReporter checkReporter, PullRequestActivityDao pullRequestActivityDao, PullRequestDao pullRequestDao, InternalPullRequestService pullRequestService, RefService refService, RepositoryDao repositoryDao, RepositoryIntegrityHelper repositoryIntegrityHelper, PullRequestRescopeScheduler rescopeScheduler, ScmService scmService, SecurityService securityService, PlatformTransactionManager transactionManager, UserAdminService userAdminService, InternalUserService userService) {
        this.checkReporter = checkReporter;
        this.repositoryDao = repositoryDao;
        this.batchSize = 1000;
        this.defaultPrActivityWindow = TimeUnit.MILLISECONDS.convert(7L, TimeUnit.DAYS);
        this.pullRequestDao = pullRequestDao;
        this.pullRequestActivityDao = pullRequestActivityDao;
        this.repositoryIntegrityHelper = repositoryIntegrityHelper;
        this.rescopeScheduler = rescopeScheduler;
        this.transactionTemplate = new TransactionTemplate(transactionManager, SpringTransactionUtils.REQUIRES_NEW);
        this.userAdminService = userAdminService;
        this.userService = userService;
        this.userSupplier = () -> ((com.google.common.base.Supplier)Suppliers.memoize(this::getOrCreateIntegrityCheckServiceUser)).get();
        this.pullRequestIntegrityHelper = new PullRequestIntegrityHelper(pullRequestService, refService, scmService, securityService, this.userSupplier);
    }

    @Nonnull
    @PreAuthorize(value="hasGlobalPermission('SYS_ADMIN')")
    public Set<IntegrityCheckMergeActivity> checkMergedPullRequests(@Nonnull PullRequestIntegrityCheckRequest checkRequest) {
        Objects.requireNonNull(checkRequest, "request");
        this.checkReporter.debug("Integrity checks for merged pull requests have started", new Object[0]);
        Set modifiedPullRequests = (Set)this.streamMergeActivities(checkRequest).filter(mergeActivity -> {
            if (mergeActivity.getMergeCommit() == null) {
                this.checkReporter.debug("{}: Merge activity for pull request #{} does not have associated commit hash. It may have been remotely merged. Not performing integrity checks.", new Object[]{mergeActivity.getScopeRepository(), mergeActivity.getPullRequestId()});
                return false;
            }
            try {
                return this.pullRequestIntegrityHelper.checkIntegrity((IntegrityCheckMergeActivity)mergeActivity, this.checkReporter);
            }
            catch (Exception unexpected) {
                this.checkReporter.error("{}: Unexpected error integrity checking pull request #{}, this error has been caught and will not affect subsequent integrity checks", new Object[]{mergeActivity.getScopeRepository(), mergeActivity.getPullRequestId(), unexpected});
                return true;
            }
        }).collect(MoreCollectors.toImmutableSet());
        this.checkReporter.debug("Integrity checks for merged pull requests have completed", new Object[0]);
        return modifiedPullRequests;
    }

    @Nonnull
    @PreAuthorize(value="hasGlobalPermission('SYS_ADMIN')")
    public Map<Repository, List<String>> checkRepositories() {
        this.checkReporter.debug("Integrity checks for repositories have started", new Object[0]);
        HashMap<Repository, List<String>> result = new HashMap<Repository, List<String>>();
        this.repositoryIntegrityHelper.checkRepositoriesExistAndAreConsistent((repository, message) -> result.computeIfAbsent((Repository)repository, ignored -> new ArrayList()).add(message));
        this.repositoryIntegrityHelper.checkRepositoryContents((repository, message) -> result.computeIfAbsent((Repository)repository, repo -> new ArrayList()).add(message));
        result.forEach((repository, inconsistencies) -> this.checkReporter.inconsistency("{}: The following {} inconsistencies were found: {}", new Object[]{repository, inconsistencies.size(), inconsistencies}));
        this.checkReporter.debug("Integrity checks for repositories have completed", new Object[0]);
        return result;
    }

    @Nonnull
    @PreAuthorize(value="hasGlobalPermission('SYS_ADMIN')")
    public Map<Repository, List<String>> checkRepositories(@Nonnull String hierarchyId) {
        Objects.requireNonNull(hierarchyId, "hierarchyId");
        this.checkReporter.debug("Integrity checks for repositories have started", new Object[0]);
        HashMap<Repository, List<String>> result = new HashMap<Repository, List<String>>();
        this.repositoryIntegrityHelper.checkRepositoriesExistAndAreConsistentForHierarchy(hierarchyId, (repository, message) -> result.computeIfAbsent((Repository)repository, ignored -> new ArrayList()).add(message));
        this.repositoryIntegrityHelper.checkRepositoryContentsForHierarchy(hierarchyId, (repository, message) -> result.computeIfAbsent((Repository)repository, ignored -> new ArrayList()).add(message));
        result.forEach((repository, inconsistencies) -> this.checkReporter.inconsistency("{}: The following {} inconsistencies were found: {}", new Object[]{repository, inconsistencies.size(), inconsistencies}));
        this.checkReporter.debug("Integrity checks for repositories have completed", new Object[0]);
        return result;
    }

    @PreAuthorize(value="hasGlobalPermission('SYS_ADMIN')")
    public long scheduleOpenPullRequestChecksByRescope(@Nonnull PullRequestIntegrityCheckRequest checkRequest) {
        Objects.requireNonNull(checkRequest, "checkRequest");
        this.checkReporter.debug("Scheduling of rescopes for repositories containing open pull requests has started", new Object[0]);
        InternalApplicationUser user = this.userSupplier.get();
        HashSet scheduledIds = new HashSet();
        this.streamOpenPullRequests(checkRequest).map(pullRequest -> pullRequest.getFromRef().getRepository()).filter(repository -> scheduledIds.add(repository.getId())).forEach(repository -> {
            this.checkReporter.debug("Scheduling repository '{}' for rescope processing", new Object[]{repository});
            this.rescopeScheduler.schedule(repository, user, Collections.emptySet());
        });
        this.checkReporter.debug("Scheduled rescopes for {} repositories containing open pull requests", new Object[]{scheduledIds.size()});
        return scheduledIds.size();
    }

    @Value(value="${integrity.check.pullRequest.batchSize}")
    public void setBatchSize(int batchSize) {
        this.batchSize = batchSize;
    }

    @Value(value="${integrity.check.pullRequest.updatedSinceDays}")
    public void setDefaultPrActivityWindow(int days) {
        this.defaultPrActivityWindow = TimeUnit.MILLISECONDS.convert(days, TimeUnit.DAYS);
    }

    private Date calculatePrStateChangeWindowStart(PullRequestIntegrityCheckRequest request) {
        long window = request.getActivityWindow(TimeUnit.MILLISECONDS).orElse(this.defaultPrActivityWindow);
        return (Date)this.transactionTemplate.execute(ignored -> {
            String hierarchyId = request.getHierarchyId().orElse(null);
            Optional<InternalPullRequest> pr = hierarchyId == null ? this.pullRequestDao.findAll(PageUtils.newRequest((int)0, (int)1)).stream().findFirst() : Optional.ofNullable(this.pullRequestDao.findLatestByRepositoryHierarchyId(hierarchyId));
            Instant matchingPrMostRecentlyUpdatedOrNow = pr.map(InternalPullRequest::getUpdatedDate).map(Date::toInstant).orElseGet(Instant::now);
            return Date.from(matchingPrMostRecentlyUpdatedOrNow.minus(window, ChronoUnit.MILLIS));
        });
    }

    private InternalApplicationUser getOrCreateIntegrityCheckServiceUser() {
        ServiceUser serviceUser = this.userService.getServiceUserByName("integrity-check-service-user");
        return InternalConverter.convertToInternalUser((ApplicationUser)((ApplicationUser)Optional.ofNullable(serviceUser).orElseGet(() -> (ServiceUser)this.transactionTemplate.execute(status -> {
            ServiceUser user = this.userAdminService.createServiceUser(((ServiceUserCreateRequest.Builder)((ServiceUserCreateRequest.Builder)((ServiceUserCreateRequest.Builder)new ServiceUserCreateRequest.Builder().active(true)).displayName("Integrity Checker")).name("integrity-check-service-user")).build());
            this.userService.updateAvatar((ApplicationUser)user, (AvatarSupplier)new ResourceAvatarSupplier("avatars/integrity-check/ingrid.png"));
            return user;
        }))));
    }

    private Stream<IntegrityCheckMergeActivity> streamMergeActivities(PullRequestIntegrityCheckRequest request) {
        Date mergedWindowStart = this.calculatePrStateChangeWindowStart(request);
        this.checkReporter.debug("Checking integrity of all pull requests merged since {}", new Object[]{mergedWindowStart});
        Function findMergeActivity = pageRequest -> request.getHierarchyId().map(hierarchyId -> this.pullRequestActivityDao.findLatestMergeActivityInHierarchySince(mergedWindowStart, hierarchyId, pageRequest)).orElse(this.pullRequestActivityDao.findLatestMergeActivitySince(mergedWindowStart, pageRequest));
        return this.txBatched(findMergeActivity);
    }

    private Stream<InternalPullRequest> streamOpenPullRequests(PullRequestIntegrityCheckRequest request) {
        PullRequestSearchCriteria searchCriteria = new PullRequestSearchCriteria.Builder().state(PullRequestState.OPEN).hierarchyId((String)request.getHierarchyId().orElse(null)).build();
        return this.txBatched(pageRequest -> this.pullRequestDao.search(searchCriteria, pageRequest, p -> true));
    }

    private <E> Stream<E> txBatched(Function<PageRequest, Page<E>> search) {
        return PageUtils.toStream(pageRequest -> (Page)this.transactionTemplate.execute(ignored -> (Page)search.apply(pageRequest)), (int)this.batchSize);
    }
}

