/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.integrity;

import com.atlassian.bitbucket.Product;
import com.atlassian.bitbucket.ServiceException;
import com.atlassian.bitbucket.dmz.mesh.DmzMeshConsistencyCheckService;
import com.atlassian.bitbucket.dmz.server.DataStore;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.scm.AvailableScm;
import com.atlassian.bitbucket.scm.CreateCommandParameters;
import com.atlassian.bitbucket.scm.ForkCommandParameters;
import com.atlassian.bitbucket.scm.ScmFeature;
import com.atlassian.bitbucket.scm.integrity.IntegrityCheckCallback;
import com.atlassian.bitbucket.scm.integrity.IntegrityCheckContext;
import com.atlassian.bitbucket.util.Page;
import com.atlassian.bitbucket.util.PageProvider;
import com.atlassian.bitbucket.util.PageRequest;
import com.atlassian.bitbucket.util.PageUtils;
import com.atlassian.stash.internal.HomeLayout;
import com.atlassian.stash.internal.integrity.DefaultIntegrityCheckContext;
import com.atlassian.stash.internal.integrity.IntegrityCheckReporter;
import com.atlassian.stash.internal.integrity.RepositoryIntegrityCallback;
import com.atlassian.stash.internal.integrity.RepositoryIntegrityHelper;
import com.atlassian.stash.internal.mode.DefaultApplicationMode;
import com.atlassian.stash.internal.pull.PullRequestDao;
import com.atlassian.stash.internal.repository.InternalRepository;
import com.atlassian.stash.internal.repository.RepositoryDao;
import com.atlassian.stash.internal.scm.InternalScmService;
import com.atlassian.stash.internal.server.DataStoreDao;
import com.atlassian.stash.internal.server.DataStoreLayout;
import com.atlassian.stash.internal.server.InternalDataStore;
import com.atlassian.stash.internal.server.InternalStorageService;
import com.atlassian.stash.internal.spring.SpringTransactionUtils;
import jakarta.annotation.Nonnull;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.support.TransactionTemplate;

@Component(value="repositoryIntegrityHelper")
@DefaultApplicationMode
public class DefaultRepositoryIntegrityHelper
implements RepositoryIntegrityHelper {
    private static final int DEFAULT_BATCH_SIZE = 1000;
    private final DataStoreDao dataStoreDao;
    private final HomeLayout homeLayout;
    private final IntegrityCheckReporter integrityCheckReporter;
    private final DmzMeshConsistencyCheckService meshConsistencyCheckService;
    private final PullRequestDao pullRequestDao;
    private final RepositoryDao repositoryDao;
    private final InternalScmService scmService;
    private final InternalStorageService storageService;
    private final TransactionTemplate transactionTemplate;
    private int batchSize;

    @Autowired
    public DefaultRepositoryIntegrityHelper(DataStoreDao dataStoreDao, HomeLayout homeLayout, IntegrityCheckReporter integrityCheckReporter, Optional<DmzMeshConsistencyCheckService> meshConsistencyCheckService, PullRequestDao pullRequestDao, RepositoryDao repositoryDao, InternalScmService scmService, InternalStorageService storageService, PlatformTransactionManager transactionManager) {
        this.dataStoreDao = dataStoreDao;
        this.homeLayout = homeLayout;
        this.integrityCheckReporter = integrityCheckReporter;
        this.meshConsistencyCheckService = meshConsistencyCheckService.orElse(null);
        this.pullRequestDao = pullRequestDao;
        this.repositoryDao = repositoryDao;
        this.scmService = scmService;
        this.storageService = storageService;
        this.batchSize = 1000;
        this.transactionTemplate = new TransactionTemplate(transactionManager, SpringTransactionUtils.REQUIRES_NEW);
        this.transactionTemplate.setReadOnly(true);
    }

    public void checkRepositoriesExistAndAreConsistent(@Nonnull BiConsumer<Repository, String> callback) {
        Objects.requireNonNull(callback, "callback");
        this.createMissingLocalRepositories(repository -> callback.accept((Repository)repository, "To restore integrity the repository had to be created"));
        this.checkConsistencyForAllRemoteRepositories(callback);
    }

    public void checkRepositoriesExistAndAreConsistentForHierarchy(@Nonnull String hierarchyId, @Nonnull BiConsumer<Repository, String> callback) {
        Objects.requireNonNull(callback, "callback");
        Objects.requireNonNull(hierarchyId, "hierarchyId");
        try {
            this.transactionTemplate.executeWithoutResult(tx -> {
                InternalRepository repository = this.getFirstHierarchyRepository(hierarchyId);
                if (repository.isRemote()) {
                    this.checkConsistencyForRemoteHierarchy(hierarchyId, callback);
                } else {
                    this.createMissingRepositoriesForLocalHierarchy((Repository)repository, restored -> callback.accept((Repository)restored, "To restore integrity the repository had to be created"));
                }
            });
        }
        catch (Exception e) {
            this.integrityCheckReporter.error("Failed to check for missing of inconistent repositories.", new Object[]{e});
        }
    }

    public void checkRepositoryContents(@Nonnull BiConsumer<Repository, String> callback) {
        Objects.requireNonNull(callback, "callback");
        RepositoryIntegrityCallback integrityCallback = new RepositoryIntegrityCallback(this.integrityCheckReporter);
        try {
            this.transactionTemplate.execute(status -> {
                Map repositoryToHighestPullRequestId = this.pullRequestDao.getHighestScopedIdsByRepository();
                this.scmService.getAvailable().stream().map(AvailableScm::getId).filter(scmId -> this.scmService.isSupported(scmId, ScmFeature.INTEGRITY_CHECKS)).forEach(scmId -> {
                    Stream repositories = PageUtils.toStream(request -> this.repositoryDao.findByScmId(scmId, request), (int)this.batchSize);
                    this.scmService.checkIntegrity(scmId, (IntegrityCheckContext)new DefaultIntegrityCheckContext(repositories.map(internalRepository -> internalRepository), repositoryToHighestPullRequestId), (IntegrityCheckCallback)integrityCallback);
                });
                return null;
            });
        }
        catch (Exception e) {
            this.integrityCheckReporter.error("Repository integrity checks failed.", new Object[]{e});
        }
        integrityCallback.getInconsistencies().forEach((repository, messages) -> messages.forEach(message -> callback.accept((Repository)repository, (String)message)));
    }

    public void checkRepositoryContentsForHierarchy(@Nonnull String hierarchyId, @Nonnull BiConsumer<Repository, String> callback) {
        Objects.requireNonNull(callback, "callback");
        Objects.requireNonNull(hierarchyId, "hierarchyId");
        RepositoryIntegrityCallback integrityCallback = new RepositoryIntegrityCallback(this.integrityCheckReporter);
        try {
            this.transactionTemplate.executeWithoutResult(status -> {
                InternalRepository repository = this.getFirstHierarchyRepository(hierarchyId);
                if (repository != null) {
                    String scmId = repository.getScmId();
                    if (!this.scmService.isSupported(scmId, ScmFeature.INTEGRITY_CHECKS)) {
                        this.integrityCheckReporter.warning("Integrity checks are not supported for SCM {}", new Object[]{scmId});
                        return;
                    }
                    Map repoToHighestPullRequestId = this.pullRequestDao.getHighestScopedIdsByRepository();
                    this.scmService.checkIntegrity(scmId, (IntegrityCheckContext)new DefaultIntegrityCheckContext(this.streamRepositoriesByHierarchy(hierarchyId).map(internalRepository -> internalRepository), repoToHighestPullRequestId), (IntegrityCheckCallback)integrityCallback);
                }
            });
        }
        catch (Exception e) {
            this.integrityCheckReporter.error("Repository integrity checks failed for hierarchy ID: {}", new Object[]{hierarchyId, e});
        }
        integrityCallback.getInconsistencies().forEach((repository, inconsistencies) -> inconsistencies.forEach(message -> callback.accept((Repository)repository, (String)message)));
    }

    @Value(value="${integrity.check.repository.batchSize}")
    public void setBatchSize(int batchSize) {
        this.batchSize = batchSize;
    }

    private void checkConsistencyForAllRemoteRepositories(BiConsumer<Repository, String> callback) {
        if (this.meshConsistencyCheckService == null) {
            this.integrityCheckReporter.info("Skipping consistency checks for remote repositories because {} is not enabled", new Object[]{Product.MESH_NAME});
        }
        this.transactionTemplate.executeWithoutResult(status -> {
            DmzMeshConsistencyCheckService.Checker checker = this.meshConsistencyCheckService.newChecker(callback);
            this.repositoryDao.streamByRemote(true, repository -> {
                try {
                    checker.startCheck(repository);
                }
                catch (RuntimeException e) {
                    this.integrityCheckReporter.warning("Failed to check consistency of {}", new Object[]{repository, e});
                }
                return true;
            });
            try {
                checker.await();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                this.integrityCheckReporter.warning("Interrupted while waiting for {} consistency checks to complete", new Object[]{Product.MESH_NAME});
            }
            catch (RuntimeException e) {
                this.integrityCheckReporter.warning("Error while waiting for {} consistency checks to complete", new Object[]{Product.MESH_NAME, e});
            }
        });
    }

    private void checkConsistencyForRemoteHierarchy(String hierarchyId, BiConsumer<Repository, String> callback) {
        if (this.meshConsistencyCheckService == null) {
            this.integrityCheckReporter.error("Cannot perform consistency checks for remote hierarchy {} because {} is disabled", new Object[]{hierarchyId, Product.MESH_NAME});
            return;
        }
        DmzMeshConsistencyCheckService.Checker checker = this.meshConsistencyCheckService.newChecker(callback);
        this.streamRepositoriesByHierarchy(hierarchyId).forEach(repository -> {
            try {
                checker.startCheck((Repository)repository);
            }
            catch (RuntimeException e) {
                this.integrityCheckReporter.warning("Failed to check consistency of {}", new Object[]{repository, e});
            }
        });
        try {
            checker.await();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            this.integrityCheckReporter.warning("Interrupted while waiting for {} consistency checks to complete", new Object[]{Product.MESH_NAME});
        }
        catch (RuntimeException e) {
            this.integrityCheckReporter.warning("Error while waiting for {} consistency checks to complete", new Object[]{Product.MESH_NAME, e});
        }
    }

    private void createMissingLocalRepositories(Consumer<Repository> callback) {
        try {
            this.transactionTemplate.executeWithoutResult(status -> {
                Set<Integer> missingRepositories = this.findMissingRepositoriesInSharedHome();
                this.dataStoreDao.listAll().forEach(store -> missingRepositories.addAll(this.findMissingRepositoriesInDataStore((InternalDataStore)store)));
                if (missingRepositories.isEmpty()) {
                    return;
                }
                ArrayList<InternalRepository> repositoriesToRestore = new ArrayList<InternalRepository>(this.getRepositoriesByIds(missingRepositories));
                if (repositoriesToRestore.isEmpty()) {
                    return;
                }
                while (!repositoriesToRestore.isEmpty()) {
                    this.restoreRepository((Repository)repositoriesToRestore.remove(0), repositoriesToRestore, callback);
                }
            });
        }
        catch (Exception e) {
            this.integrityCheckReporter.error("Failed to create missing repositories.", new Object[]{e});
        }
    }

    private void createMissingRepositoriesForLocalHierarchy(Repository repository, Consumer<Repository> callback) {
        List<InternalRepository> repositoriesToRestore = this.findMissingRepositoriesForLocalHierarchy(repository);
        while (!repositoriesToRestore.isEmpty()) {
            this.restoreRepository((Repository)repositoriesToRestore.remove(0), repositoriesToRestore, callback);
        }
    }

    private List<InternalRepository> findMissingRepositoriesForLocalHierarchy(@Nonnull Repository repository) {
        List<InternalRepository> list;
        block9: {
            Optional hierarchyDir = this.storageService.getHierarchyDir(repository);
            String hierarchyId = repository.getHierarchyId();
            if (!hierarchyDir.isPresent()) {
                return this.streamRepositoriesByHierarchy(hierarchyId).filter(repo -> !Files.exists(this.storageService.getRepositoryDir((Repository)repo), new LinkOption[0])).collect(Collectors.toList());
            }
            Stream<Path> stream = Files.list((Path)hierarchyDir.get());
            try {
                Set presentRepositories = stream.filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])).flatMap(this::pathToId).collect(Collectors.toSet());
                list = this.streamRepositoriesByHierarchy(hierarchyId).filter(repo -> !presentRepositories.contains(repo.getId())).collect(Collectors.toList());
                if (stream == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    this.integrityCheckReporter.error("An I/O error occurred while restoring repositories at path: {}", new Object[]{hierarchyDir.get(), e});
                    return Collections.emptyList();
                }
            }
            stream.close();
        }
        return list;
    }

    @Nonnull
    private Set<Integer> findMissingRepositoriesInDataStore(@Nonnull InternalDataStore store) {
        final HashSet<Integer> missingRepositories = new HashSet<Integer>(this.getLocalRepositoryIds(store));
        if (missingRepositories.isEmpty()) {
            return Collections.emptySet();
        }
        try {
            Files.walkFileTree(DataStoreLayout.getRepositoriesDir((DataStore)store), Collections.emptySet(), 3, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(this){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
                    if (attrs.isDirectory()) {
                        try {
                            Integer id = Integer.valueOf(file.getFileName().toString());
                            missingRepositories.remove(id);
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (IOException e) {
            this.integrityCheckReporter.error("An I/O error occurred while restoring repositories at path: {}", new Object[]{store.getPath(), e});
            return Collections.emptySet();
        }
        return missingRepositories;
    }

    @Nonnull
    private Set<Integer> findMissingRepositoriesInSharedHome() {
        HashSet<Integer> missingRepositories = new HashSet<Integer>(this.getLocalRepositoryIds(null));
        if (missingRepositories.isEmpty()) {
            return missingRepositories;
        }
        try (Stream<Path> stream = Files.list(this.homeLayout.getRepositoriesDir());){
            stream.filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])).flatMap(this::pathToId).forEach(missingRepositories::remove);
        }
        catch (IOException e) {
            this.integrityCheckReporter.error("An I/O error occurred while restoring repositories in the shared home.", new Object[0]);
            return Collections.emptySet();
        }
        return missingRepositories;
    }

    private InternalRepository getFirstHierarchyRepository(String hierarchyId) {
        Iterator it = this.repositoryDao.findByHierarchyId(hierarchyId, PageUtils.newRequest((int)0, (int)1)).getValues().iterator();
        return it.hasNext() ? (InternalRepository)it.next() : null;
    }

    @Nonnull
    private List<Integer> getLocalRepositoryIds(InternalDataStore store) {
        try {
            return this.repositoryDao.getIdsByDataStore(store, Boolean.FALSE);
        }
        catch (Exception e) {
            this.integrityCheckReporter.error("Unable to retrieve repository IDs from the database", new Object[]{e});
            return Collections.emptyList();
        }
    }

    @Nonnull
    private List<InternalRepository> getRepositoriesByIds(Collection<Integer> ids) {
        try {
            return this.repositoryDao.getByIds(ids);
        }
        catch (Exception e) {
            this.integrityCheckReporter.error("Unable to retrieve repositories with IDs [{}], from database", new Object[]{ids, e});
            return Collections.emptyList();
        }
    }

    @Nonnull
    private Stream<Integer> pathToId(@Nonnull Path path) {
        Objects.requireNonNull(path, "path");
        try {
            return Stream.of(Integer.valueOf(Integer.parseInt(path.getFileName().toString())));
        }
        catch (NumberFormatException e) {
            this.integrityCheckReporter.debug("Path does not correspond to a valid repository ID. Path: {}", new Object[]{path});
            return Stream.empty();
        }
    }

    private void restoreRepository(@Nonnull Repository repository, @Nonnull List<InternalRepository> repositoriesToRestore, @Nonnull Consumer<Repository> callback) {
        Objects.requireNonNull(repository, "repository");
        Objects.requireNonNull(repositoriesToRestore, "repositories");
        Path repositoryDir = this.storageService.getRepositoryDir(repository);
        try {
            InternalRepository origin = (InternalRepository)repository.getOrigin();
            if (origin != null) {
                if (repositoriesToRestore.remove(origin)) {
                    this.restoreRepository((Repository)origin, repositoriesToRestore, callback);
                }
                this.scmService.fork((Repository)origin, new ForkCommandParameters.Builder(repository).build());
            } else {
                this.scmService.create(repository, new CreateCommandParameters.Builder().build());
            }
            this.integrityCheckReporter.inconsistency("The repository {}/{} exists but the directory {} is missing. To restore integrity, an empty repository directory was created.", new Object[]{repository.getProject().getKey(), repository.getSlug(), repositoryDir});
            callback.accept(repository);
        }
        catch (ServiceException | UnsupportedOperationException e) {
            this.integrityCheckReporter.error("The repository {}/{} could not be restored. An error occurred while creating an empty git repository", new Object[]{repository.getProject().getKey(), repository.getSlug(), e});
        }
    }

    private Stream<InternalRepository> streamRepositoriesByHierarchy(final @Nonnull String hierarchyId) {
        return PageUtils.toStream((PageProvider)new PageProvider<InternalRepository>(){

            @Nonnull
            public Page<InternalRepository> get(@Nonnull PageRequest request) {
                return DefaultRepositoryIntegrityHelper.this.repositoryDao.findByHierarchyId(hierarchyId, request);
            }
        }, (int)this.batchSize);
    }
}

