/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.integrity;

import com.atlassian.bitbucket.event.server.DisasterRecoveryTriggeredEvent;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.stash.internal.activity.IntegrityCheckMergeActivity;
import com.atlassian.stash.internal.annotation.Profiled;
import com.atlassian.stash.internal.integrity.IntegrityCheckReporter;
import com.atlassian.stash.internal.integrity.IntegrityCheckService;
import com.atlassian.stash.internal.integrity.PullRequestIntegrityCheckRequest;
import com.atlassian.stash.internal.mode.DefaultApplicationMode;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@DefaultApplicationMode
@Profiled
@Component(value="fullIntegrityCheckService")
public class FullIntegrityCheckHelper {
    private final IntegrityCheckReporter integrityCheckReporter;
    private final IntegrityCheckService checkService;
    private final EventPublisher eventPublisher;

    @Autowired
    public FullIntegrityCheckHelper(IntegrityCheckReporter integrityCheckReporter, IntegrityCheckService checkService, EventPublisher eventPublisher) {
        this.integrityCheckReporter = integrityCheckReporter;
        this.checkService = checkService;
        this.eventPublisher = eventPublisher;
    }

    public void runChecks() {
        if (this.integrityCheckReporter.startedFull()) {
            try {
                this.runAndReport(this.integrityCheckReporter, () -> this.eventPublisher.publish((Object)new DisasterRecoveryTriggeredEvent((Object)this)));
                this.runAndReport(this.integrityCheckReporter, this::checkAllRepositories);
                this.runAndReport(this.integrityCheckReporter, this::checkRecentlyMergedPullRequests);
            }
            finally {
                this.integrityCheckReporter.complete();
            }
        }
    }

    public void scheduleOpenPullRequestChecksByRescope() {
        this.checkService.scheduleOpenPullRequestChecksByRescope(new PullRequestIntegrityCheckRequest.Builder().build());
    }

    private Map<Repository, List<String>> checkAllRepositories() {
        return this.checkService.checkRepositories();
    }

    private Set<IntegrityCheckMergeActivity> checkRecentlyMergedPullRequests() {
        return this.checkService.checkMergedPullRequests(new PullRequestIntegrityCheckRequest.Builder().build());
    }

    private void runAndReport(IntegrityCheckReporter reporter, Runnable runnable) {
        try {
            runnable.run();
        }
        catch (Exception e) {
            reporter.error("Error performing an integrity check. Further checks will continue", new Object[]{e});
        }
    }
}

