/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.integrity;

import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.server.ApplicationPropertiesService;
import com.atlassian.bitbucket.user.SecurityService;
import com.atlassian.scheduler.JobRunner;
import com.atlassian.scheduler.JobRunnerRequest;
import com.atlassian.scheduler.JobRunnerResponse;
import com.atlassian.scheduler.SchedulerService;
import com.atlassian.scheduler.SchedulerServiceException;
import com.atlassian.scheduler.config.JobConfig;
import com.atlassian.scheduler.config.JobId;
import com.atlassian.scheduler.config.JobRunnerKey;
import com.atlassian.scheduler.config.RunMode;
import com.atlassian.scheduler.config.Schedule;
import com.atlassian.stash.internal.integrity.FullIntegrityCheckHelper;
import com.atlassian.stash.internal.integrity.IntegrityCheckReporter;
import com.atlassian.stash.internal.mode.DefaultApplicationMode;
import com.atlassian.stash.internal.scheduling.ScheduledJobSource;
import com.atlassian.stash.internal.spring.AbstractSmartLifecycle;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@DefaultApplicationMode
@Component(value="fullIntegrityCheckStartupTask")
public class FullIntegrityCheckStartupTask
extends AbstractSmartLifecycle
implements ScheduledJobSource {
    static final JobId JOB_ID = JobId.of((String)FullIntegrityCheckJobRunner.class.getSimpleName());
    static final JobRunnerKey JOB_RUNNER_KEY = JobRunnerKey.of((String)FullIntegrityCheckJobRunner.class.getName());
    private final boolean enabled;
    private final FullIntegrityCheckHelper helper;
    private final IntegrityCheckReporter reporter;
    private final SecurityService securityService;

    @Autowired
    public FullIntegrityCheckStartupTask(FullIntegrityCheckHelper helper, ApplicationPropertiesService propertiesService, IntegrityCheckReporter reporter, SecurityService securityService) {
        this.reporter = reporter;
        this.enabled = FullIntegrityCheckStartupTask.isEnabled(propertiesService);
        this.helper = helper;
        this.securityService = securityService;
    }

    public int getPhase() {
        return 1550;
    }

    public void schedule(@Nonnull SchedulerService schedulerService) {
        if (this.enabled) {
            try {
                this.reporter.info("Scheduling integrity check job {} because this node was the first to start and the cluster is in disaster recovery mode", new Object[]{JOB_ID});
                FullIntegrityCheckJobRunner jobRunner = new FullIntegrityCheckJobRunner();
                schedulerService.registerJobRunner(JOB_RUNNER_KEY, (JobRunner)jobRunner);
                Date startTime = new Date(System.currentTimeMillis() + TimeUnit.SECONDS.toMillis(15L));
                schedulerService.scheduleJob(JOB_ID, JobConfig.forJobRunnerKey((JobRunnerKey)JOB_RUNNER_KEY).withRunMode(RunMode.RUN_ONCE_PER_CLUSTER).withSchedule(Schedule.runOnce((Date)startTime)));
            }
            catch (SchedulerServiceException e) {
                this.reporter.error("Failed to automatically schedule integrity check job {}", new Object[]{JOB_ID, e});
            }
        }
    }

    public void start() {
        super.start();
        if (this.enabled) {
            this.securityService.withPermission(Permission.SYS_ADMIN, "Full integrity check - node started in disaster recover mode").call(() -> {
                this.reporter.debug("Scheduling integrity-checking rescopes for all open pull requests because this node was the first to start and the cluster is in disaster recovery mode", new Object[0]);
                this.helper.scheduleOpenPullRequestChecksByRescope();
                return null;
            });
        }
    }

    public void unschedule(@Nonnull SchedulerService schedulerService) {
        if (this.enabled) {
            schedulerService.unregisterJobRunner(JOB_RUNNER_KEY);
        }
    }

    private static boolean isEnabled(ApplicationPropertiesService propertiesService) {
        return propertiesService.isDisasterRecovery();
    }

    private class FullIntegrityCheckJobRunner
    implements JobRunner {
        private FullIntegrityCheckJobRunner() {
        }

        @Nullable
        public JobRunnerResponse runJob(@Nonnull JobRunnerRequest jobRunnerRequest) {
            FullIntegrityCheckStartupTask.this.securityService.withPermission(Permission.SYS_ADMIN, "Full integrity check - node started in disaster recover mode").call(() -> {
                FullIntegrityCheckStartupTask.this.helper.runChecks();
                return null;
            });
            return JobRunnerResponse.success();
        }
    }
}

