/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.integrity;

import com.atlassian.bitbucket.commit.NoSuchCommitException;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.pull.DuplicatePullRequestException;
import com.atlassian.bitbucket.pull.PullRequestDeclineRequest;
import com.atlassian.bitbucket.pull.PullRequestRef;
import com.atlassian.bitbucket.repository.Ref;
import com.atlassian.bitbucket.repository.RefService;
import com.atlassian.bitbucket.repository.RefType;
import com.atlassian.bitbucket.repository.ResolveRefRequest;
import com.atlassian.bitbucket.repository.StandardRefType;
import com.atlassian.bitbucket.scm.CommitsCommandParameters;
import com.atlassian.bitbucket.scm.ScmService;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.bitbucket.user.SecurityService;
import com.atlassian.bitbucket.util.Page;
import com.atlassian.bitbucket.util.PageUtils;
import com.atlassian.stash.internal.activity.IntegrityCheckMergeActivity;
import com.atlassian.stash.internal.integrity.IntegrityCheckReporter;
import com.atlassian.stash.internal.pull.InternalPullRequestService;
import com.atlassian.stash.internal.user.InternalApplicationUser;
import java.util.function.Supplier;

class PullRequestIntegrityHelper {
    private final InternalPullRequestService pullRequestService;
    private final RefService refService;
    private final ScmService scmService;
    private final SecurityService securityService;
    private final Supplier<InternalApplicationUser> serviceUser;

    PullRequestIntegrityHelper(InternalPullRequestService pullRequestService, RefService refService, ScmService scmService, SecurityService securityService, Supplier<InternalApplicationUser> serviceUser) {
        this.pullRequestService = pullRequestService;
        this.refService = refService;
        this.scmService = scmService;
        this.securityService = securityService;
        this.serviceUser = serviceUser;
    }

    boolean checkIntegrity(IntegrityCheckMergeActivity mergeActivity, IntegrityCheckReporter reporter) {
        reporter.debug("{}: Integrity checking Pull Request #{}", new Object[]{mergeActivity.getScopeRepository(), mergeActivity.getPullRequestId()});
        return this.maybeReopenOrDecline(mergeActivity, reporter);
    }

    private void decline(IntegrityCheckMergeActivity mergeActivity, String reason, IntegrityCheckReporter reporter) {
        this.securityService.impersonating((ApplicationUser)this.serviceUser.get(), "Declining pull request").withPermission(Permission.REPO_READ).call(() -> {
            try {
                reporter.inconsistency("{}: Pull request #{} could not be reopened, declining instead. (Reason: {})", new Object[]{mergeActivity.getScopeRepository(), mergeActivity.getPullRequestId(), reason});
                this.pullRequestService.forceDecline(new PullRequestDeclineRequest.Builder(mergeActivity.getScopeRepository().getId(), mergeActivity.getPullRequestId(), mergeActivity.getPullRequestVersion()).build());
                reporter.info("{}: Pull request #{} declined successfully", new Object[]{mergeActivity.getScopeRepository(), mergeActivity.getPullRequestId()});
            }
            catch (RuntimeException e) {
                reporter.warning("{}: Pull request #{} {}: Pull request #{} could not be declined", new Object[]{mergeActivity.getScopeRepository(), mergeActivity.getPullRequestId(), e});
            }
            return null;
        });
    }

    private boolean maybeReopenOrDecline(IntegrityCheckMergeActivity mergeActivity, IntegrityCheckReporter reporter) {
        PullRequestRef toRef = mergeActivity.getToRef();
        CommitsCommandParameters parameters = new CommitsCommandParameters.Builder().exclude(toRef.getId(), new String[0]).include(mergeActivity.getMergeCommit(), new String[0]).ignoreMissing(false).build();
        try {
            Page commitPage = (Page)this.scmService.getCommandFactory(toRef.getRepository()).commits(parameters, PageUtils.newRequest((int)0, (int)1)).call();
            if (commitPage == null) {
                return false;
            }
            return commitPage.stream().findFirst().map(commit -> this.tryReopen(mergeActivity, reporter)).orElse(false);
        }
        catch (NoSuchCommitException e) {
            if (e.getCommitId().equals(mergeActivity.getMergeCommit())) {
                return this.tryReopen(mergeActivity, reporter);
            }
            if (toRef.getId().equals(e.getCommitId())) {
                reporter.info("{}: Pull request #{}'s target branch does not exist. This is a valid scenario. No attempt will be made to modify pull request state", new Object[]{mergeActivity.getScopeRepository(), mergeActivity.getPullRequestId()});
                return false;
            }
            this.decline(mergeActivity, "unexpected missing commit", reporter);
            return false;
        }
    }

    private boolean tryReopen(IntegrityCheckMergeActivity mergeActivity, IntegrityCheckReporter reporter) {
        reporter.inconsistency("{}: Pull request #{} is marked merged but the merge commit could not be found on the target ref. Trying to restore integrity by reopening", new Object[]{mergeActivity.getScopeRepository(), mergeActivity.getPullRequestId()});
        Ref fromRef = this.refService.resolveRef(new ResolveRefRequest.Builder(mergeActivity.getFromRef().getRepository()).refId(mergeActivity.getFromRef().getId()).type(null).build());
        if (fromRef == null) {
            this.decline(mergeActivity, "fromRef could not be resolved", reporter);
            return true;
        }
        if (mergeActivity.getScopeRepository().isArchived()) {
            reporter.info("{}: Pull request #{} could not be reopened because the repository is archived", new Object[]{mergeActivity.getScopeRepository(), mergeActivity.getPullRequestId()});
            return false;
        }
        Ref toRef = this.refService.resolveRef(new ResolveRefRequest.Builder(mergeActivity.getToRef().getRepository()).refId(mergeActivity.getToRef().getId()).type((RefType)StandardRefType.BRANCH).build());
        if (toRef == null) {
            reporter.info("{}: Could not find toRef for pull request #{} no further action will be taken", new Object[]{mergeActivity.getScopeRepository(), mergeActivity.getPullRequestId()});
            return false;
        }
        this.securityService.impersonating((ApplicationUser)this.serviceUser.get(), "Reopening unmerged pull request").withPermission(Permission.REPO_READ).call(() -> {
            try {
                this.pullRequestService.forceReopen(mergeActivity.getScopeRepository().getId(), mergeActivity.getPullRequestId());
                reporter.info("{}: Pull request #{} has been successfully reopened", new Object[]{mergeActivity.getScopeRepository(), mergeActivity.getPullRequestId()});
            }
            catch (DuplicatePullRequestException exception) {
                this.decline(mergeActivity, "an open pull request with the same to and from refs already exists", reporter);
            }
            catch (RuntimeException e) {
                reporter.warning("{}: Pull request #{} could not be reopened", new Object[]{mergeActivity.getScopeRepository(), mergeActivity.getPullRequestId(), e});
            }
            return null;
        });
        return true;
    }
}

