/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.integrity;

import com.atlassian.bitbucket.i18n.KeyedMessage;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.scm.integrity.IntegrityCheckCallback;
import com.atlassian.stash.internal.integrity.IntegrityCheckReporter;
import jakarta.annotation.Nonnull;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class RepositoryIntegrityCallback
implements IntegrityCheckCallback {
    private final Map<Repository, Set<Long>> extraPullRequestsByRepository = new HashMap<Repository, Set<Long>>();
    private final Map<Repository, Set<Long>> missingPullRequestsByRepository = new HashMap<Repository, Set<Long>>();
    private final IntegrityCheckReporter reporter;

    public RepositoryIntegrityCallback(@Nonnull IntegrityCheckReporter integrityCheckReporter) {
        this.reporter = Objects.requireNonNull(integrityCheckReporter, "integrityCheckReporter");
    }

    public Map<Repository, List<String>> getInconsistencies() {
        HashMap<Repository, List<String>> inconsistencies = new HashMap<Repository, List<String>>();
        this.extraPullRequestsByRepository.forEach((repository, extraIds) -> {
            String message = MessageFormat.format("{0}: The following extra pull {1,choice,1#request was|1<requests were} found on disk: {2}", repository, extraIds.size(), extraIds);
            this.addMessage((Map<Repository, List<String>>)inconsistencies, (Repository)repository, message);
        });
        this.missingPullRequestsByRepository.forEach((repository, missingIds) -> {
            String message = MessageFormat.format("{0}: The following pull {1,choice,1#request is|1<requests are} missing on disk: {2}", repository, missingIds.size(), missingIds);
            this.addMessage((Map<Repository, List<String>>)inconsistencies, (Repository)repository, message);
        });
        return inconsistencies;
    }

    public void onError(@Nonnull KeyedMessage message) {
        Objects.requireNonNull(message, "message");
        String formattedMessage = MessageFormat.format("Integrity checks encountered an error: {0}", message.getLocalisedMessage());
        this.reporter.error(formattedMessage, new Object[0]);
    }

    public void onError(@Nonnull Repository repository, @Nonnull KeyedMessage message) {
        Objects.requireNonNull(repository, "repository");
        Objects.requireNonNull(message, "message");
        String formattedMessage = MessageFormat.format("{0}: Integrity checks encountered an error: {1}", repository, message.getLocalisedMessage());
        this.reporter.error(formattedMessage, new Object[0]);
    }

    public void onExtraPullRequest(@Nonnull Repository repository, long pullRequestId) {
        Objects.requireNonNull(repository, "repository");
        this.extraPullRequestsByRepository.computeIfAbsent(repository, repo -> new HashSet()).add(pullRequestId);
    }

    public void onMissingPullRequest(@Nonnull Repository repository, long pullRequestId) {
        Objects.requireNonNull(repository, "repository");
        this.missingPullRequestsByRepository.computeIfAbsent(repository, repo -> new HashSet()).add(pullRequestId);
    }

    private void addMessage(Map<Repository, List<String>> inconsistencies, Repository repository, String message) {
        inconsistencies.computeIfAbsent(repository, repo -> new ArrayList()).add(message);
    }
}

