/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.jira;

import com.atlassian.crowd.model.application.ApplicationType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlElementWrapper;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.adapters.XmlAdapter;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.util.Collections;
import java.util.List;

@XmlRootElement(name="application")
public class CrowdApplicationEntity {
    @XmlElement
    private String name;
    @XmlElement
    @XmlJavaTypeAdapter(value=ApplicationTypeAdapter.class)
    private ApplicationType type;
    @XmlElement
    private String description;
    @XmlElement
    private boolean active;
    @XmlElementWrapper(name="password")
    @XmlElement(name="value")
    private List<String> password;

    public CrowdApplicationEntity() {
    }

    public CrowdApplicationEntity(ApplicationType type, String name, String password, String description, boolean active) {
        this.type = type;
        this.active = active;
        this.description = description;
        this.name = name;
        this.password = Collections.singletonList(password);
    }

    public String getName() {
        return this.name;
    }

    public String getPassword() {
        if (this.password == null || this.password.size() != 1) {
            throw new IllegalStateException("Invalid password: " + String.valueOf(this.password));
        }
        return this.password.get(0);
    }

    private static class ApplicationTypeAdapter
    extends XmlAdapter<String, ApplicationType> {
        private ApplicationTypeAdapter() {
        }

        public String marshal(ApplicationType v) throws Exception {
            return v.name();
        }

        public ApplicationType unmarshal(String v) throws Exception {
            return ApplicationType.valueOf((String)v);
        }
    }
}

